/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.optimizer;

import ai.djl.Device;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.training.optimizer.Optimizer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Adadelta
extends Optimizer {
    private float rho;
    private float epsilon;
    private Map<String, Map<Device, NDArray>> accumG;
    private Map<String, Map<Device, NDArray>> accumDelta;

    protected Adadelta(Builder builder) {
        super(builder);
        this.rho = builder.rho;
        this.epsilon = builder.epsilon;
        this.accumG = new ConcurrentHashMap<String, Map<Device, NDArray>>();
        this.accumDelta = new ConcurrentHashMap<String, Map<Device, NDArray>>();
    }

    @Override
    public void update(String parameterId, NDArray weight, NDArray grad) {
        float weightDecay = this.getWeightDecay();
        NDList inputs = new NDList(weight, grad, this.withDefaultState(this.accumG, parameterId, weight.getDevice(), k -> weight.zerosLike()), this.withDefaultState(this.accumDelta, parameterId, weight.getDevice(), k -> weight.zerosLike()));
        NDList weights = new NDList(weight);
        NDArrayEx ex = weight.getNDArrayInternal();
        ex.adadeltaUpdate(inputs, weights, weightDecay, this.rescaleGrad, this.clipGrad, this.rho, this.epsilon);
    }

    public static final class Builder
    extends Optimizer.OptimizerBuilder<Builder> {
        private float rho = 0.9f;
        private float epsilon = 1.0E-8f;

        Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder optRho(float rho) {
            this.rho = rho;
            return this;
        }

        public Builder optEpsilon(float epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public Adadelta build() {
            return new Adadelta(this);
        }
    }
}

