/*
 * Decompiled with CFR 0.152.
 */
package com.bianxianmao.offlinemodel.alg.util;

import com.bianxianmao.offlinemodel.api.enums.SerializerEnum;
import com.bianxianmao.offlinemodel.common.util.serialize.KryoUtil;
import com.bianxianmao.offlinemodel.common.util.serialize.SerializeTool;
import com.bianxianmao.offlinemodel.mllib.model.SparseFMModel;
import java.io.Serializable;
import org.apache.spark.mllib.linalg.SparseVector;

public class FMModelUtil
implements Serializable {
    private static final long serialVersionUID = -316102112618444922L;
    private SparseFMModel model = null;

    public void setModel(SparseFMModel model) {
        this.model = model;
    }

    public void setModel(String modelStr, SerializerEnum serializerEnum) {
        this.model = this.getModel(modelStr, serializerEnum);
    }

    public SparseFMModel getModel() {
        return this.model;
    }

    public SparseFMModel getModel(String src, SerializerEnum serializerEnum) {
        SparseFMModel ret = null;
        if (serializerEnum == SerializerEnum.JAVA_ORIGINAL) {
            ret = (SparseFMModel)SerializeTool.getObjectFromString((String)src);
        }
        if (serializerEnum == SerializerEnum.KRYO) {
            ret = (SparseFMModel)KryoUtil.deserializationObject((String)src, SparseFMModel.class);
        }
        return ret;
    }

    public String getModelStr(SparseFMModel model, SerializerEnum serializerEnum) {
        String ret = null;
        if (serializerEnum == SerializerEnum.JAVA_ORIGINAL) {
            ret = SerializeTool.object2String((Object)model);
        }
        if (serializerEnum == SerializerEnum.KRYO) {
            ret = KryoUtil.serializationObject((Serializable)model);
        }
        return ret;
    }

    public String getModelStr(SerializerEnum serializerEnum) {
        return this.getModelStr(this.model, serializerEnum);
    }

    public Double predict(SparseVector data) {
        if (this.getModel() == null) {
            return null;
        }
        return this.getModel().predict(data);
    }
}

