/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.query.mariadb;

import cn.smallbun.screw.core.exception.QueryException;
import cn.smallbun.screw.core.mapping.Mapping;
import cn.smallbun.screw.core.metadata.Column;
import cn.smallbun.screw.core.metadata.Database;
import cn.smallbun.screw.core.metadata.PrimaryKey;
import cn.smallbun.screw.core.query.AbstractDatabaseQuery;
import cn.smallbun.screw.core.query.mariadb.model.MariadbColumnModel;
import cn.smallbun.screw.core.query.mariadb.model.MariadbDatabaseModel;
import cn.smallbun.screw.core.query.mariadb.model.MariadbPrimaryKeyModel;
import cn.smallbun.screw.core.query.mariadb.model.MariadbTableModel;
import cn.smallbun.screw.core.util.Assert;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.JdbcUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;

public class MariaDbDataBaseQuery
extends AbstractDatabaseQuery {
    public MariaDbDataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Database getDataBase() throws QueryException {
        MariadbDatabaseModel model = new MariadbDatabaseModel();
        model.setDatabase(this.getCatalog());
        return model;
    }

    public List<MariadbTableModel> getTables() throws QueryException {
        List<MariadbTableModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables(this.getCatalog(), this.getSchema(), "%", new String[]{"TABLE"});
            list = Mapping.convertList(resultSet, MariadbTableModel.class);
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }

    public List<MariadbColumnModel> getTableColumns(String table) throws QueryException {
        List<MariadbColumnModel> list;
        String unsigned = "UNSIGNED";
        Assert.notEmpty(table, "Table name can not be empty!", new Object[0]);
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), table, "%");
            List<MariadbColumnModel> list2 = Mapping.convertList(resultSet, MariadbColumnModel.class);
            for (MariadbColumnModel model : list2) {
                String dbType = model.getTypeName();
                if (dbType.contains(unsigned)) {
                    model.setTypeName(dbType.replace(" UNSIGNED", ""));
                    continue;
                }
                if (!MariaDbDataBaseQuery.isNumberType(dbType)) continue;
                model.setColumnSize(String.valueOf(Integer.parseInt(model.getColumnSize()) + 1));
            }
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }

    @Override
    public List<? extends Column> getTableColumns() throws QueryException {
        return this.getTableColumns("%");
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys(String table) throws QueryException {
        List<MariadbPrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchema(), table);
            list = Mapping.convertList(resultSet, MariadbPrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws QueryException {
        List<MariadbPrimaryKeyModel> list;
        ResultSet resultSet = null;
        try {
            String sql = "SELECT A.TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM, A.TABLE_NAME, A.COLUMN_NAME, B.SEQ_IN_INDEX KEY_SEQ, B.INDEX_NAME PK_NAME FROM INFORMATION_SCHEMA.COLUMNS A, INFORMATION_SCHEMA.STATISTICS B WHERE A.COLUMN_KEY in('PRI', 'pri') AND B.INDEX_NAME = 'PRIMARY' AND (A.TABLE_SCHEMA = '%s') AND (B.TABLE_SCHEMA = '%s') AND A.TABLE_SCHEMA = B.TABLE_SCHEMA AND A.TABLE_NAME = B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME ORDER BY A.COLUMN_NAME";
            String database = this.getDataBase().getDatabase();
            resultSet = this.prepareStatement(String.format(sql, database, database)).executeQuery();
            list = Mapping.convertList(resultSet, MariadbPrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw new QueryException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close(resultSet);
        return list;
    }

    protected static boolean isNumberType(String dbType) {
        String[] arr = new String[]{"NUMERIC", "DECIMAL", "TINYINT", "SMALLINT", "INTEGER", "BIGINT", "REAL", "FLOAT", "DOUBLE"};
        return Arrays.asList(arr).contains(dbType);
    }
}

