/*
 * Decompiled with CFR 0.152.
 */
package com.lly835.bestpay.service.impl;

import com.lly835.bestpay.config.AliDirectPayConfig;
import com.lly835.bestpay.config.SignType;
import com.lly835.bestpay.service.impl.AbstractComponent;
import com.lly835.bestpay.utils.HttpRequestUtil;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

class AlipayPCSignature
extends AbstractComponent {
    private AliDirectPayConfig aliDirectPayConfig;

    public AlipayPCSignature(AliDirectPayConfig aliDirectPayConfig) {
        Objects.requireNonNull(aliDirectPayConfig, "aliDirectPayConfig is null.");
        this.aliDirectPayConfig = aliDirectPayConfig;
    }

    public String sign(SortedMap<String, String> sortedParamMap) {
        ArrayList paramList = new ArrayList();
        sortedParamMap.forEach((k, v) -> {
            if (StringUtils.isBlank((CharSequence)k) || k.equals("sign") || k.equals("sign_type") || StringUtils.isBlank((CharSequence)v)) {
                return;
            }
            paramList.add(k + "=" + v);
        });
        String param = String.join((CharSequence)"&", paramList);
        switch (this.aliDirectPayConfig.getSignType()) {
            case MD5: {
                return this.signParamWithMD5(param);
            }
            case RSA: {
                return this.signParamWithRSA(param);
            }
        }
        throw new IllegalStateException("unsupported sign type.");
    }

    public boolean verify(Map<String, String> toBeVerifiedParamMap, SignType signType, String sign) {
        Objects.requireNonNull(toBeVerifiedParamMap, "to be verified param map is null.");
        if (toBeVerifiedParamMap.isEmpty()) {
            throw new IllegalArgumentException("to be verified param map is empty.");
        }
        Objects.requireNonNull(signType, "sign type is null.");
        switch (signType) {
            case RSA2: {
                throw new IllegalArgumentException("unsupported sign type: RSA2.");
            }
        }
        if (StringUtils.isBlank((CharSequence)sign)) {
            throw new IllegalArgumentException("sign is blank.");
        }
        ArrayList paramList = new ArrayList();
        toBeVerifiedParamMap.forEach((k, v) -> {
            if (StringUtils.isBlank((CharSequence)k) || k.equals("sign_type") || k.equals("sign") || StringUtils.isEmpty((CharSequence)v)) {
                return;
            }
            paramList.add(k + "=" + v);
        });
        Collections.sort(paramList);
        String toBeVerifiedStr = String.join((CharSequence)"&", paramList);
        boolean r = false;
        switch (signType) {
            case MD5: {
                r = this.verifyParamWithMD5(toBeVerifiedStr, sign);
                break;
            }
            case RSA: {
                r = this.verifyParamWithRSA(toBeVerifiedStr, sign);
            }
        }
        if (!r) {
            this.logger.warn("fail to verify sign with sign type {}.", (Object)signType.name());
            return false;
        }
        String notifyId = toBeVerifiedParamMap.get("notify_id");
        if (!StringUtils.isEmpty((CharSequence)notifyId) && !(r = this.verifyNotifyId(notifyId))) {
            this.logger.warn("fail to verify notify id.");
            return false;
        }
        return true;
    }

    private boolean verifyNotifyId(String notifyId) {
        String veryfyUrl = "https://mapi.alipay.com/gateway.do?service=notify_verify&partner=" + this.aliDirectPayConfig.getPartnerId() + "&notify_id=" + notifyId;
        String result = HttpRequestUtil.get(veryfyUrl);
        return result.equals("true");
    }

    private String signParamWithMD5(String param) {
        return DigestUtils.md5Hex((String)(param + this.aliDirectPayConfig.getPartnerMD5Key()));
    }

    private String signParamWithRSA(String param) {
        try {
            Signature sig = Signature.getInstance("SHA1WithRSA");
            sig.initSign(this.aliDirectPayConfig.getPartnerRSAPrivateKeyObject());
            sig.update(param.getBytes(this.aliDirectPayConfig.getInputCharset()));
            return Base64.getEncoder().encodeToString(sig.sign());
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IllegalStateException("sign error.", e);
        }
    }

    private boolean verifyParamWithMD5(String param, String sign) {
        String expectedSign = DigestUtils.md5Hex((String)(param + this.aliDirectPayConfig.getPartnerMD5Key()));
        return sign.equals(expectedSign);
    }

    private boolean verifyParamWithRSA(String param, String sign) {
        try {
            Signature sig = Signature.getInstance("SHA1WithRSA");
            sig.initVerify(this.aliDirectPayConfig.getAlipayRSAPublicKeyObject());
            sig.update(param.getBytes("utf-8"));
            return sig.verify(Base64.getDecoder().decode(sign));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IllegalStateException("AliPay verify error.");
        }
    }
}

