/*
 * Decompiled with CFR 0.152.
 */
package com.lly835.bestpay.service.impl;

import com.lly835.bestpay.config.SignType;
import com.lly835.bestpay.config.WxPayH5Config;
import com.lly835.bestpay.model.PayRequest;
import com.lly835.bestpay.model.PayResponse;
import com.lly835.bestpay.model.RefundRequest;
import com.lly835.bestpay.model.RefundResponse;
import com.lly835.bestpay.model.wxpay.WxPayApi;
import com.lly835.bestpay.model.wxpay.request.WxPayRefundRequest;
import com.lly835.bestpay.model.wxpay.request.WxPayUnifiedorderRequest;
import com.lly835.bestpay.model.wxpay.response.WxPayAsyncResponse;
import com.lly835.bestpay.model.wxpay.response.WxPayRefundResponse;
import com.lly835.bestpay.model.wxpay.response.WxPaySyncResponse;
import com.lly835.bestpay.service.BestPayService;
import com.lly835.bestpay.service.impl.WxPaySignature;
import com.lly835.bestpay.utils.MoneyUtil;
import com.lly835.bestpay.utils.RandomUtil;
import com.lly835.bestpay.utils.XmlUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.simplexml.SimpleXmlConverterFactory;

public class WxPayServiceImpl
implements BestPayService {
    private static final Logger log = LoggerFactory.getLogger(WxPayServiceImpl.class);
    private WxPayH5Config wxPayH5Config;

    public void setWxPayH5Config(WxPayH5Config wxPayH5Config) {
        this.wxPayH5Config = wxPayH5Config;
    }

    @Override
    public PayResponse pay(PayRequest request) {
        WxPayUnifiedorderRequest wxRequest = new WxPayUnifiedorderRequest();
        wxRequest.setOutTradeNo(request.getOrderId());
        wxRequest.setTotalFee(MoneyUtil.Yuan2Fen(request.getOrderAmount()));
        wxRequest.setBody(request.getOrderName());
        wxRequest.setOpenid(request.getOpenid());
        wxRequest.setTradeType("JSAPI");
        wxRequest.setAppid(this.wxPayH5Config.getAppId());
        wxRequest.setMchId(this.wxPayH5Config.getMchId());
        wxRequest.setNotifyUrl(this.wxPayH5Config.getNotifyUrl());
        wxRequest.setNonceStr(RandomUtil.getRandomStr());
        wxRequest.setSpbillCreateIp("8.8.8.8");
        wxRequest.setSign(WxPaySignature.sign(this.buildMap(wxRequest), this.wxPayH5Config.getMchKey()));
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api.mch.weixin.qq.com").addConverterFactory((Converter.Factory)SimpleXmlConverterFactory.create()).build();
        String xml = XmlUtil.toXMl(wxRequest);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)xml);
        Call<WxPaySyncResponse> call = ((WxPayApi)retrofit.create(WxPayApi.class)).unifiedorder(body);
        Response retrofitResponse = null;
        try {
            retrofitResponse = call.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!retrofitResponse.isSuccessful()) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u7edf\u4e00\u652f\u4ed8\u3011\u53d1\u8d77\u652f\u4ed8, \u7f51\u7edc\u5f02\u5e38");
        }
        WxPaySyncResponse response = (WxPaySyncResponse)retrofitResponse.body();
        if (!response.getReturnCode().equals("SUCCESS")) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u7edf\u4e00\u652f\u4ed8\u3011\u53d1\u8d77\u652f\u4ed8, returnCode != SUCCESS, returnMsg = " + response.getReturnMsg());
        }
        if (!response.getResultCode().equals("SUCCESS")) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u7edf\u4e00\u652f\u4ed8\u3011\u53d1\u8d77\u652f\u4ed8, resultCode != SUCCESS, err_code = " + response.getErrCode() + " err_code_des=" + response.getErrCodeDes());
        }
        return this.buildPayResponse(response);
    }

    public boolean verify(Map map, SignType signType, String sign) {
        return WxPaySignature.verify(map, this.wxPayH5Config.getMchKey());
    }

    @Override
    public PayResponse syncNotify(HttpServletRequest request) {
        return null;
    }

    @Override
    public PayResponse asyncNotify(String notifyData) {
        WxPayAsyncResponse asyncResponse = (WxPayAsyncResponse)XmlUtil.fromXML(notifyData, WxPayAsyncResponse.class);
        if (!WxPaySignature.verify(this.buildMap(asyncResponse), this.wxPayH5Config.getMchKey()).booleanValue()) {
            log.error("\u3010\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u3011\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25, response={}", (Object)asyncResponse);
            throw new RuntimeException("\u3010\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u3011\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        if (!asyncResponse.getReturnCode().equals("SUCCESS")) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u3011\u53d1\u8d77\u652f\u4ed8, returnCode != SUCCESS, returnMsg = " + asyncResponse.getReturnMsg());
        }
        if (!asyncResponse.getResultCode().equals("SUCCESS") && asyncResponse.getErrCode().equals("ORDERPAID")) {
            return this.buildPayResponse(asyncResponse);
        }
        if (!asyncResponse.getResultCode().equals("SUCCESS")) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u3011\u53d1\u8d77\u652f\u4ed8, resultCode != SUCCESS, err_code = " + asyncResponse.getErrCode() + " err_code_des=" + asyncResponse.getErrCodeDes());
        }
        return this.buildPayResponse(asyncResponse);
    }

    @Override
    public RefundResponse refund(RefundRequest request) {
        WxPayRefundRequest wxRequest = new WxPayRefundRequest();
        wxRequest.setOutTradeNo(request.getOrderId());
        wxRequest.setOutRefundNo(request.getOrderId());
        wxRequest.setTotalFee(MoneyUtil.Yuan2Fen(request.getOrderAmount()));
        wxRequest.setRefundFee(MoneyUtil.Yuan2Fen(request.getOrderAmount()));
        wxRequest.setAppid(this.wxPayH5Config.getAppId());
        wxRequest.setMchId(this.wxPayH5Config.getMchId());
        wxRequest.setNonceStr(RandomUtil.getRandomStr());
        wxRequest.setSign(WxPaySignature.sign(this.buildMap(wxRequest), this.wxPayH5Config.getMchKey()));
        if (this.wxPayH5Config.getSslContext() == null) {
            this.wxPayH5Config.initSSLContext();
        }
        OkHttpClient.Builder okHttpClient = new OkHttpClient().newBuilder().sslSocketFactory(this.wxPayH5Config.getSslContext().getSocketFactory());
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api.mch.weixin.qq.com").addConverterFactory((Converter.Factory)SimpleXmlConverterFactory.create()).client(okHttpClient.build()).build();
        String xml = XmlUtil.toXMl(wxRequest);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)xml);
        Call<WxPayRefundResponse> call = ((WxPayApi)retrofit.create(WxPayApi.class)).refund(body);
        Response retrofitResponse = null;
        try {
            retrofitResponse = call.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!retrofitResponse.isSuccessful()) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u9000\u6b3e\u3011\u53d1\u8d77\u9000\u6b3e, \u7f51\u7edc\u5f02\u5e38");
        }
        WxPayRefundResponse response = (WxPayRefundResponse)retrofitResponse.body();
        if (!response.getReturnCode().equals("SUCCESS")) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u9000\u6b3e\u3011\u53d1\u8d77\u9000\u6b3e, returnCode != SUCCESS, returnMsg = " + response.getReturnMsg());
        }
        if (!response.getResultCode().equals("SUCCESS")) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u9000\u6b3e\u3011\u53d1\u8d77\u9000\u6b3e, resultCode != SUCCESS, err_code = " + response.getErrCode() + " err_code_des=" + response.getErrCodeDes());
        }
        return this.buildRefundResponse(response);
    }

    private RefundResponse buildRefundResponse(WxPayRefundResponse response) {
        RefundResponse refundResponse = new RefundResponse();
        refundResponse.setOrderId(response.getOutTradeNo());
        refundResponse.setOrderAmount(MoneyUtil.Fen2Yuan(response.getTotalFee()));
        refundResponse.setOutTradeNo(response.getTransactionId());
        refundResponse.setRefundId(response.getOutRefundNo());
        refundResponse.setOutRefundNo(response.getRefundId());
        return refundResponse;
    }

    private Map<String, String> buildMap(WxPayRefundRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appid", request.getAppid());
        map.put("mch_id", request.getMchId());
        map.put("nonce_str", request.getNonceStr());
        map.put("sign", request.getSign());
        map.put("sign_type", request.getSignType());
        map.put("transaction_id", request.getTransactionId());
        map.put("out_trade_no", request.getOutTradeNo());
        map.put("out_refund_no", request.getOutRefundNo());
        map.put("total_fee", String.valueOf(request.getTotalFee()));
        map.put("refund_fee", String.valueOf(request.getRefundFee()));
        map.put("refund_fee_type", request.getRefundFeeType());
        map.put("refund_desc", request.getRefundDesc());
        map.put("refund_account", request.getRefundAccount());
        return map;
    }

    private PayResponse buildPayResponse(WxPayAsyncResponse response) {
        PayResponse payResponse = new PayResponse();
        payResponse.setOrderAmount(MoneyUtil.Fen2Yuan(response.getTotalFee()));
        payResponse.setOrderId(response.getOutTradeNo());
        payResponse.setOutTradeNo(response.getTransactionId());
        return payResponse;
    }

    private Map<String, String> buildMap(WxPayAsyncResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("return_code", response.getReturnCode());
        map.put("return_msg", response.getReturnMsg());
        map.put("appid", response.getAppid());
        map.put("mch_id", response.getMchId());
        map.put("device_info", response.getDeviceInfo());
        map.put("nonce_str", response.getNonceStr());
        map.put("sign", response.getSign());
        map.put("result_code", response.getResultCode());
        map.put("err_code", response.getErrCode());
        map.put("err_code_des", response.getErrCodeDes());
        map.put("openid", response.getOpenid());
        map.put("is_subscribe", response.getIsSubscribe());
        map.put("trade_type", response.getTradeType());
        map.put("bank_type", response.getBankType());
        map.put("total_fee", String.valueOf(response.getTotalFee()));
        map.put("fee_type", response.getFeeType());
        map.put("cash_fee", response.getCashFee());
        map.put("cash_fee_type", response.getCashFeeType());
        map.put("coupon_fee", response.getCouponFee());
        map.put("coupon_count", response.getCouponCount());
        map.put("transaction_id", response.getTransactionId());
        map.put("out_trade_no", response.getOutTradeNo());
        map.put("attach", response.getAttach());
        map.put("time_end", response.getTimeEnd());
        return map;
    }

    private Map<String, String> buildMap(WxPayUnifiedorderRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appid", request.getAppid());
        map.put("mch_id", request.getMchId());
        map.put("nonce_str", request.getNonceStr());
        map.put("sign", request.getSign());
        map.put("attach", request.getAttach());
        map.put("body", request.getBody());
        map.put("detail", request.getDetail());
        map.put("notify_url", request.getNotifyUrl());
        map.put("openid", request.getOpenid());
        map.put("out_trade_no", request.getOutTradeNo());
        map.put("spbill_create_ip", request.getSpbillCreateIp());
        map.put("total_fee", String.valueOf(request.getTotalFee()));
        map.put("trade_type", request.getTradeType());
        return map;
    }

    private PayResponse buildPayResponse(WxPaySyncResponse response) {
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonceStr = RandomUtil.getRandomStr();
        String packAge = "prepay_id=" + response.getPrepayId();
        String signType = "MD5";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", response.getAppid());
        map.put("timeStamp", timeStamp);
        map.put("nonceStr", nonceStr);
        map.put("package", packAge);
        map.put("signType", signType);
        PayResponse payResponse = new PayResponse();
        payResponse.setAppId(response.getAppid());
        payResponse.setTimeStamp(timeStamp);
        payResponse.setNonceStr(nonceStr);
        payResponse.setPackAge(packAge);
        payResponse.setSignType(signType);
        payResponse.setPaySign(WxPaySignature.sign(map, this.wxPayH5Config.getMchKey()));
        return payResponse;
    }
}

