/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.parser.yaml;

import com.alibaba.cloud.ai.document.DocumentParser;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.ai.document.Document;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class YamlDocumentParser
implements DocumentParser {
    private final boolean strict;
    private final Class<? extends Object> beanClass;

    public YamlDocumentParser() {
        this(false, null);
    }

    public YamlDocumentParser(boolean strict) {
        this(strict, null);
    }

    public YamlDocumentParser(Class<? extends Object> beanClass) {
        this(false, beanClass);
    }

    public YamlDocumentParser(boolean strict, Class<? extends Object> beanClass) {
        this.strict = strict;
        this.beanClass = beanClass;
    }

    public List<Document> parse(InputStream inputStream) {
        try {
            LoaderOptions loaderOptions = new LoaderOptions();
            loaderOptions.setAllowDuplicateKeys(false);
            Constructor constructor = null;
            constructor = this.beanClass != null ? new Constructor(this.beanClass, loaderOptions) : new Constructor(loaderOptions);
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            Object data = yaml.load(inputStream);
            String textContent = this.convertToString(data);
            Document document = new Document(textContent);
            Map metaData = document.getMetadata();
            metaData.put("format", "YAML");
            metaData.put("source", "YAML input stream");
            metaData.put("originalData", data);
            return Collections.singletonList(document);
        }
        catch (Exception e) {
            if (this.strict) {
                throw new RuntimeException("Failed to parse YAML content", e);
            }
            return Collections.emptyList();
        }
    }

    private String convertToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Map) {
            return ((Map)obj).entrySet().stream().map(e -> e.getKey() + ": " + this.convertToString(e.getValue())).collect(Collectors.joining("\n"));
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).stream().map(this::convertToString).collect(Collectors.joining(", "));
        }
        return Objects.toString(obj);
    }
}

