/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.googlescholar;

import com.alibaba.cloud.ai.toolcalling.common.interfaces.SearchService;
import com.alibaba.cloud.ai.toolcalling.googlescholar.GoogleScholarProperties;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class GoogleScholarService
implements SearchService,
Function<Request, Response> {
    private static final Logger log = LoggerFactory.getLogger(GoogleScholarService.class);
    private final GoogleScholarProperties properties;

    public GoogleScholarService(GoogleScholarProperties properties) {
        this.properties = properties;
    }

    public SearchService.Response query(String query) {
        return this.apply(Request.simpleQuery(query));
    }

    @Override
    public Response apply(Request request) {
        if (!StringUtils.hasText((String)request.getQuery())) {
            throw new RuntimeException("Search query cannot be empty.");
        }
        try {
            String searchUrl = this.buildSearchUrl(request);
            log.debug("Google Scholar search URL: {}", (Object)searchUrl);
            Connection connection = Jsoup.connect((String)searchUrl).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36").timeout(this.properties.getTimeout()).followRedirects(true).ignoreHttpErrors(true);
            Document doc = connection.get();
            List<ScholarResult> results = this.parseSearchResults(doc);
            log.debug("Found {} search results", (Object)results.size());
            return new Response(results);
        }
        catch (IOException e) {
            log.error("Error searching Google Scholar: ", (Throwable)e);
            throw new RuntimeException("Failed to search Google Scholar: " + e.getMessage(), e);
        }
        catch (Exception e) {
            log.error("Unexpected error during Google Scholar search: ", (Throwable)e);
            throw new RuntimeException("Unexpected error during search: " + e.getMessage(), e);
        }
    }

    private String buildSearchUrl(Request request) {
        StringBuilder url = new StringBuilder(this.properties.getBaseUrl());
        url.append("/scholar?q=");
        url.append(URLEncoder.encode(request.getQuery(), StandardCharsets.UTF_8));
        if (StringUtils.hasText((String)request.author())) {
            url.append("&author=").append(URLEncoder.encode(request.author(), StandardCharsets.UTF_8));
        }
        if (StringUtils.hasText((String)request.publication())) {
            url.append("&publication=").append(URLEncoder.encode(request.publication(), StandardCharsets.UTF_8));
        }
        if (request.yearFrom() != null && request.yearFrom() > 0) {
            url.append("&as_ylo=").append(request.yearFrom());
        }
        if (request.yearTo() != null && request.yearTo() > 0) {
            url.append("&as_yhi=").append(request.yearTo());
        }
        url.append("&num=").append(Math.min(request.numResults() != null ? request.numResults() : 10, 20));
        url.append("&hl=").append(this.properties.getLanguage());
        return url.toString();
    }

    private List<ScholarResult> parseSearchResults(Document doc) {
        ArrayList<ScholarResult> results = new ArrayList<ScholarResult>();
        Elements resultElements = doc.select("div.gs_ri");
        for (Element element : resultElements) {
            try {
                ScholarResult result = this.parseScholarResult(element);
                if (result == null) continue;
                results.add(result);
            }
            catch (Exception e) {
                log.warn("Error parsing scholar result: ", (Throwable)e);
            }
        }
        return results;
    }

    private ScholarResult parseScholarResult(Element element) {
        Pattern yearPattern;
        Matcher yearMatcher;
        String url;
        Element titleElement = element.selectFirst("h3.gs_rt a");
        String title = titleElement != null ? titleElement.text() : "";
        String string = url = titleElement != null ? titleElement.attr("href") : "";
        if (!StringUtils.hasText((String)title)) {
            return null;
        }
        Element authorsElement = element.selectFirst("div.gs_a");
        String authors = authorsElement != null ? authorsElement.text() : "";
        Element snippetElement = element.selectFirst("div.gs_rs");
        String snippet = snippetElement != null ? snippetElement.text() : "";
        Integer citationCount = null;
        Element citationElement = element.selectFirst("div.gs_fl a:contains(Cited by)");
        if (citationElement != null && this.properties.isIncludeCitations()) {
            String citationText = citationElement.text();
            Pattern pattern = Pattern.compile("Cited by (\\d+)");
            Matcher matcher = pattern.matcher(citationText);
            if (matcher.find()) {
                citationCount = Integer.parseInt(matcher.group(1));
            }
        }
        String pdfUrl = null;
        Element pdfElement = element.selectFirst("div.gs_ggs.gs_fl a");
        if (pdfElement != null) {
            pdfUrl = pdfElement.attr("href");
        }
        Integer year = null;
        if (StringUtils.hasText((String)authors) && (yearMatcher = (yearPattern = Pattern.compile("(\\d{4})")).matcher(authors)).find()) {
            year = Integer.parseInt(yearMatcher.group(1));
        }
        return new ScholarResult(title, url, authors, snippet, citationCount, pdfUrl, year);
    }

    @JsonClassDescription(value="Google Scholar Search Request. Search for academic papers and publications.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Request(@JsonProperty(required=true, value="query") @JsonPropertyDescription(value="Search query for academic papers") String query, @JsonProperty(value="author") @JsonPropertyDescription(value="Filter by author name") String author, @JsonProperty(value="publication") @JsonPropertyDescription(value="Filter by publication name or journal") String publication, @JsonProperty(value="yearFrom") @JsonPropertyDescription(value="Start year for publication date filter") Integer yearFrom, @JsonProperty(value="yearTo") @JsonPropertyDescription(value="End year for publication date filter") Integer yearTo, @JsonProperty(value="numResults", defaultValue="10") @JsonPropertyDescription(value="Number of results to return (max 20)") Integer numResults) implements SearchService.Request
    {
        public String getQuery() {
            return this.query();
        }

        public static Request simpleQuery(String query) {
            return new Request(query, null, null, null, null, 10);
        }
    }

    @JsonClassDescription(value="Google Scholar Search Response")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Response(@JsonProperty(value="results") List<ScholarResult> results) implements SearchService.Response
    {
        public SearchService.SearchResult getSearchResult() {
            return new SearchService.SearchResult(this.results().stream().map(item -> new SearchService.SearchContent(item.title(), item.snippet(), item.url(), null)).toList());
        }
    }

    public record ScholarResult(String title, String url, String authors, String snippet, Integer citationCount, String pdfUrl, Integer year) {
    }
}

