/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.metaso;

import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.common.interfaces.SearchService;
import com.alibaba.cloud.ai.toolcalling.metaso.MetasoProperties;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MetasoService
implements SearchService,
Function<Request, Response> {
    private static final Logger log = LoggerFactory.getLogger(MetasoService.class);
    private final WebClientTool webClientTool;
    private final JsonParseTool jsonParseTool;
    private final MetasoProperties properties;

    public MetasoService(WebClientTool webClientTool, JsonParseTool jsonParseTool, MetasoProperties properties) {
        this.webClientTool = webClientTool;
        this.jsonParseTool = jsonParseTool;
        this.properties = properties;
    }

    public SearchService.Response query(String query) {
        return this.apply(Request.simplyQuery(query));
    }

    @Override
    public Response apply(Request request) {
        if (!StringUtils.hasText((String)this.properties.getApiKey())) {
            throw new RuntimeException("Service Api Key is Invalid.");
        }
        try {
            String responseStr = (String)this.webClientTool.post("search", (Object)request).block();
            log.debug("Response: {}", (Object)responseStr);
            return (Response)this.jsonParseTool.jsonToObject(responseStr, Response.class);
        }
        catch (Exception e) {
            log.error("Service Metaso Request Error: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @JsonClassDescription(value="\u6839\u636e\u95ee\u9898\u6216\u8005\u5173\u952e\u8bcd\uff0c\u8fd4\u56de\u7f51\u9875\u7b49\u6570\u636e\u6e90\u7684\u5b9e\u65f6\u641c\u7d22\u7ed3\u679c")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Request(@JsonProperty(required=true, value="q") @JsonPropertyDescription(value="\u67e5\u8be2") String q, @JsonProperty(value="scope", defaultValue="webpage") @JsonPropertyDescription(value="\u641c\u7d22\u8303\u56f4: `webpage` (\u7f51\u9875), `document` (\u6587\u5e93), `scholar` (\u5b66\u672f), `image` (\u56fe\u7247), `video` (\u89c6\u9891), `podcast` (\u64ad\u5ba2).") String scope, @JsonProperty(value="size", defaultValue="10") @JsonPropertyDescription(value="\u7ed3\u679c\u6570\u91cf. \u9ed8\u8ba4\u503c: 10") Integer size, @JsonProperty(value="includeSummary", defaultValue="true") @JsonPropertyDescription(value="\u901a\u8fc7\u7f51\u9875\u7684\u6458\u8981\u4fe1\u606f\u8fdb\u884c\u53ec\u56de\u589e\u5f3a. \u9ed8\u8ba4\u503c: true") Boolean includeSummary, @JsonProperty(value="includeRowContent", defaultValue="false") @JsonPropertyDescription(value="\u6293\u53d6\u6240\u6709\u6765\u6e90\u7f51\u9875\u539f\u6587`. \u9ed8\u8ba4\u503c: false") Boolean includeRowContent) implements SearchService.Request
    {
        public String getQuery() {
            return this.q();
        }

        public static Request simplyQuery(String query) {
            return new Request(query, "webpage", 10, true, false);
        }
    }

    @JsonClassDescription(value="Metaso AI Search Response")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Response(@JsonProperty(value="credits") Integer credits, @JsonProperty(value="total") Integer total, @JsonProperty(value="searchParameters") @JsonIgnoreProperties(ignoreUnknown=true) Request searchParameters, @JsonProperty(value="webpages") List<WebPage> webpages, @JsonProperty(value="documents") List<WebPage> documents, @JsonProperty(value="scholars") List<WebPage> scholars, @JsonProperty(value="images") List<Image> images, @JsonProperty(value="videos") List<Video> videos, @JsonProperty(value="podcasts") List<Podcast> podcasts) implements SearchService.Response
    {
        public SearchService.SearchResult getSearchResult() {
            Assert.isTrue((boolean)StringUtils.hasText((String)this.searchParameters.scope), (String)"searchParameters.scope is invalid");
            ResultType resultType = ResultType.getByType(this.searchParameters.scope);
            Assert.notNull((Object)((Object)resultType), (String)"resultType is null");
            switch (resultType) {
                case WEBPAGE: {
                    return new SearchService.SearchResult(this.webpages().stream().map(item -> new SearchService.SearchContent(item.title(), item.snippet(), item.link(), null)).toList());
                }
                case DOCUMENT: {
                    return new SearchService.SearchResult(this.documents().stream().map(item -> new SearchService.SearchContent(item.title(), item.snippet(), item.link(), null)).toList());
                }
                case SCHOLAR: {
                    return new SearchService.SearchResult(this.scholars().stream().map(item -> new SearchService.SearchContent(item.title(), item.snippet(), item.link(), null)).toList());
                }
                case IMAGE: {
                    return new SearchService.SearchResult(this.images().stream().map(item -> new SearchService.SearchContent(item.title(), null, item.imageUrl(), null)).toList());
                }
                case VIDEO: {
                    return new SearchService.SearchResult(this.videos().stream().map(item -> new SearchService.SearchContent(item.title(), item.snippet(), item.link(), item.coverImage)).toList());
                }
                case Podcast: {
                    return new SearchService.SearchResult(this.podcasts().stream().map(item -> new SearchService.SearchContent(item.title(), item.snippet(), item.link(), null)).toList());
                }
            }
            throw new IllegalStateException("Invalid result type: " + resultType);
        }

        public static enum ResultType {
            WEBPAGE("webpage"),
            DOCUMENT("document"),
            SCHOLAR("scholar"),
            IMAGE("image"),
            VIDEO("video"),
            Podcast("podcast");

            private final String type;

            private ResultType(String type) {
                this.type = type;
            }

            public static ResultType getByType(String type) {
                for (ResultType resultType : ResultType.values()) {
                    if (!resultType.type.equals(type)) continue;
                    return resultType;
                }
                return null;
            }
        }

        public record Podcast(String title, String link, String snippet, Integer position, String score, String date, String duration, List<String> authors) {
        }

        public record Video(String title, String link, String snippet, Integer position, String score, String date, String duration, String coverImage, List<String> authors) {
        }

        public record Image(String title, Integer position, String score, String imageUrl, Integer imageWidth, Integer imageHeight) {
        }

        public record WebPage(String title, String link, String snippet, String content, Integer position, String score, String date, String summary, List<String> authors) {
        }
    }
}

