/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.serpapi;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallUtils;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.common.interfaces.SearchService;
import com.alibaba.cloud.ai.toolcalling.serpapi.SerpApiProperties;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SerpApiService
implements SearchService,
Function<Request, Response> {
    private static final Logger logger = LoggerFactory.getLogger(SerpApiService.class);
    private final JsonParseTool jsonParseTool;
    private final WebClientTool webClientTool;
    private final SerpApiProperties properties;

    public SerpApiService(SerpApiProperties properties, JsonParseTool jsonParseTool, WebClientTool webClientTool) {
        this.properties = properties;
        this.jsonParseTool = jsonParseTool;
        this.webClientTool = webClientTool;
    }

    public SearchService.Response query(String query) {
        return this.apply(new Request(query));
    }

    @Override
    public Response apply(Request request) {
        if (CommonToolCallUtils.isInvalidateRequestParams((Object[])new Object[]{request, request.query})) {
            return null;
        }
        return (Response)CommonToolCallUtils.handleServiceError((String)"SerpApi", () -> {
            String response = (String)this.webClientTool.getWebClient().get().uri(uriBuilder -> uriBuilder.queryParam("api_key", new Object[]{this.properties.getApiKey()}).queryParam("engine", new Object[]{this.properties.getEngine()}).queryParam("q", new Object[]{request.query}).build(new Object[0])).acceptCharset(new Charset[]{StandardCharsets.UTF_8}).retrieve().bodyToMono(String.class).block();
            List results = (List)CommonToolCallUtils.handleResponse((String)response, this::parseJson, (Logger)logger);
            if (CollectionUtils.isEmpty((Collection)results)) {
                return null;
            }
            logger.info("serpapi search: {},result:{}", (Object)request.query, (Object)response);
            for (SearchResult d : results) {
                logger.info("{}\n{}", (Object)d.title(), (Object)d.text());
            }
            return new Response(results);
        }, (Logger)logger);
    }

    private List<SearchResult> parseJson(String jsonResponse) {
        ArrayList<SearchResult> resultList = new ArrayList<SearchResult>();
        try {
            TypeReference<List<Map<String, Object>>> typeRef = new TypeReference<List<Map<String, Object>>>(){};
            List organicResults = (List)this.jsonParseTool.getFieldValue(jsonResponse, (TypeReference)typeRef, "organic_results");
            for (Map result : organicResults) {
                Map aboutThisResult;
                Object sourceObj;
                String title = (String)result.get("title");
                String link = (String)result.get("link");
                String snippet = (String)result.get("snippet");
                String icon = null;
                Object aboutThisResultObj = result.get("about_this_result");
                if (aboutThisResultObj instanceof Map && (sourceObj = (aboutThisResult = (Map)aboutThisResultObj).get("source")) instanceof Map) {
                    Map source = (Map)sourceObj;
                    icon = (String)source.get("icon");
                }
                try {
                    Document document = Jsoup.connect((String)link).userAgent(SerpApiProperties.USER_AGENT_VALUE).get();
                    String textContent = document.body().text();
                    resultList.add(new SearchResult(title, textContent, link, icon));
                }
                catch (Exception e) {
                    logger.error("Failed to parse SERP API search link {}, caused by: {}", (Object)link, (Object)e.getMessage());
                    resultList.add(new SearchResult(title, snippet, link, icon));
                }
            }
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to parse JSON response, caused by: {}", (Object)e.getMessage());
        }
        return resultList;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonClassDescription(value="serpapi search request")
    public record Request(@JsonProperty(required=true, value="query") @JsonPropertyDescription(value="The query keyword e.g. Alibaba") String query) implements SearchService.Request
    {
        public String getQuery() {
            return this.query();
        }
    }

    @JsonClassDescription(value="serpapi search response")
    public record Response(List<SearchResult> results) implements SearchService.Response
    {
        public SearchService.SearchResult getSearchResult() {
            return new SearchService.SearchResult(this.results().stream().map(item -> new SearchService.SearchContent(item.title(), item.text(), item.url(), item.icon())).toList());
        }
    }

    public record SearchResult(String title, String text, String url, String icon) {
    }
}

