/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.tripadvisor;

import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.common.interfaces.SearchService;
import com.alibaba.cloud.ai.toolcalling.tripadvisor.TripAdvisorProperties;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class TripAdvisorService
implements SearchService,
Function<Request, Response> {
    private static final Logger logger = LoggerFactory.getLogger(TripAdvisorService.class);
    private final JsonParseTool jsonParseTool;
    private final WebClientTool webClientTool;
    private final TripAdvisorProperties properties;

    public TripAdvisorService(JsonParseTool jsonParseTool, WebClientTool webClientTool, TripAdvisorProperties properties) {
        this.jsonParseTool = jsonParseTool;
        this.webClientTool = webClientTool;
        this.properties = properties;
    }

    public SearchService.Response query(String query) {
        return this.apply(Request.searchLocations(this.properties.getApiKey(), query));
    }

    @Override
    public Response apply(Request request) {
        if (request == null) {
            return Response.errorResponse("request is null");
        }
        try {
            String responseData;
            if (StringUtils.hasText((String)request.locationId())) {
                String endpoint = "location/" + request.locationId() + "/details";
                LinkedMultiValueMap params = new LinkedMultiValueMap();
                params.add((Object)"key", (Object)request.apiKey());
                if (StringUtils.hasText((String)request.language())) {
                    params.add((Object)"language", (Object)request.language());
                }
                if (StringUtils.hasText((String)request.currency())) {
                    params.add((Object)"currency", (Object)request.currency());
                }
                responseData = (String)this.webClientTool.get(endpoint, (MultiValueMap)params).block();
            } else if (StringUtils.hasText((String)request.searchQuery())) {
                String endpoint = "location/search";
                LinkedMultiValueMap params = new LinkedMultiValueMap();
                params.add((Object)"key", (Object)request.apiKey());
                params.add((Object)"searchQuery", (Object)request.searchQuery());
                if (StringUtils.hasText((String)request.category())) {
                    params.add((Object)"category", (Object)request.category());
                }
                if (StringUtils.hasText((String)request.phone())) {
                    params.add((Object)"phone", (Object)request.phone());
                }
                if (StringUtils.hasText((String)request.address())) {
                    params.add((Object)"address", (Object)request.address());
                }
                if (StringUtils.hasText((String)request.latLong())) {
                    params.add((Object)"latLong", (Object)request.latLong());
                }
                if (StringUtils.hasText((String)request.radius())) {
                    params.add((Object)"radius", (Object)request.radius());
                }
                if (StringUtils.hasText((String)request.radiusUnit())) {
                    params.add((Object)"radiusUnit", (Object)request.radiusUnit());
                }
                if (StringUtils.hasText((String)request.language())) {
                    params.add((Object)"language", (Object)request.language());
                }
                responseData = (String)this.webClientTool.get(endpoint, (MultiValueMap)params).block();
            } else {
                return Response.errorResponse("Either locationId or searchQuery must be provided");
            }
            return (Response)this.jsonParseTool.jsonToObject(responseData, (TypeReference)new TypeReference<Response>(){});
        }
        catch (Exception ex) {
            logger.error("TripAdvisor API error: {}", (Object)ex.getMessage(), (Object)ex);
            return Response.errorResponse(ex.getMessage());
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonClassDescription(value="This is the parameter entity class for TripAdvisorService; values must be strictly populated according to field requirements.")
    public record Request(@JsonProperty(value="api_key", required=true) @JsonPropertyDescription(value="The API key for TripAdvisor Content API authentication.") String apiKey, @JsonProperty(value="location_id") @JsonPropertyDescription(value="The unique TripAdvisor location ID to get details for. Use this for location details requests.") String locationId, @JsonProperty(value="search_query") @JsonPropertyDescription(value="The search query string to find locations. Use this for search requests.") String searchQuery, @JsonProperty(value="category") @JsonPropertyDescription(value="The category to filter search results. Options: hotels, attractions, restaurants, geos") String category, @JsonProperty(value="phone") @JsonPropertyDescription(value="The phone number to search for.") String phone, @JsonProperty(value="address") @JsonPropertyDescription(value="The address to search for.") String address, @JsonProperty(value="lat_long") @JsonPropertyDescription(value="The latitude and longitude coordinates in format 'lat,long' to search around.") String latLong, @JsonProperty(value="radius") @JsonPropertyDescription(value="The search radius when using latLong. Default is 25.") String radius, @JsonProperty(value="radius_unit") @JsonPropertyDescription(value="The unit for the search radius. Options: km, mi. Default is km.") String radiusUnit, @JsonProperty(value="language") @JsonPropertyDescription(value="The language code for localized content. Examples: en, zh, fr, de, es, it, ja") String language, @JsonProperty(value="currency") @JsonPropertyDescription(value="The currency code for price information. Examples: USD, EUR, GBP, CNY") String currency) implements Serializable,
    SearchService.Request
    {
        public static Request locationDetails(String apiKey, String locationId) {
            return new Request(apiKey, locationId, null, null, null, null, null, null, null, "en", "USD");
        }

        public static Request searchLocations(String apiKey, String searchQuery) {
            return new Request(apiKey, null, searchQuery, null, null, null, null, null, null, "en", "USD");
        }

        public String getQuery() {
            return this.searchQuery();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Response(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="name") String name, @JsonProperty(value="web_url") String webUrl, @JsonProperty(value="address_obj") AddressInfo addressObj, @JsonProperty(value="ancestors") List<AncestorInfo> ancestors, @JsonProperty(value="latitude") String latitude, @JsonProperty(value="longitude") String longitude, @JsonProperty(value="rating") String rating, @JsonProperty(value="rating_image_url") String ratingImageUrl, @JsonProperty(value="num_reviews") String numReviews, @JsonProperty(value="photo_count") String photoCount, @JsonProperty(value="write_review") String writeReview, @JsonProperty(value="location_string") String locationString, @JsonProperty(value="price_level") String priceLevel, @JsonProperty(value="category") CategoryInfo category, @JsonProperty(value="subcategory") List<CategoryInfo> subcategory, @JsonProperty(value="awards") List<AwardInfo> awards, @JsonProperty(value="ranking_data") RankingInfo rankingData, @JsonProperty(value="see_all_photos") String seeAllPhotos, @JsonProperty(value="data") List<LocationSearchResult> data, @JsonProperty(value="error") String error) implements SearchService.Response
    {
        public static Response errorResponse(String errorMsg) {
            return new Response(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, errorMsg);
        }

        public SearchService.SearchResult getSearchResult() {
            if (this.data() != null && !this.data().isEmpty()) {
                return new SearchService.SearchResult(this.data().stream().map(item -> new SearchService.SearchContent(item.name(), "Rating: " + item.rating() + ", Reviews: " + item.numReviews(), item.locationId(), null)).toList());
            }
            return new SearchService.SearchResult(List.of());
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public record AddressInfo(@JsonProperty(value="street1") String street1, @JsonProperty(value="street2") String street2, @JsonProperty(value="city") String city, @JsonProperty(value="state") String state, @JsonProperty(value="country") String country, @JsonProperty(value="postalcode") String postalcode, @JsonProperty(value="address_string") String addressString) {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public record CategoryInfo(@JsonProperty(value="name") String name, @JsonProperty(value="localized_name") String localizedName) {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public record RankingInfo(@JsonProperty(value="ranking") String ranking, @JsonProperty(value="ranking_out_of") String rankingOutOf, @JsonProperty(value="ranking_string") String rankingString, @JsonProperty(value="geo_location_name") String geoLocationName) {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public record LocationSearchResult(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="name") String name, @JsonProperty(value="address_obj") AddressInfo addressObj, @JsonProperty(value="rating") String rating, @JsonProperty(value="num_reviews") String numReviews) {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public record AwardInfo(@JsonProperty(value="award_type") String awardType, @JsonProperty(value="year") String year, @JsonProperty(value="display_name") String displayName) {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public record AncestorInfo(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="name") String name, @JsonProperty(value="level") String level, @JsonProperty(value="abbrv") String abbrv) {
        }
    }
}

