/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.wikipedia;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.wikipedia.WikipediaProperties;
import com.alibaba.cloud.ai.toolcalling.wikipedia.WikipediaService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;

@Configuration
@ConditionalOnClass(value={WikipediaService.class})
@EnableConfigurationProperties(value={WikipediaProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.toolcalling.wikipedia", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class WikipediaAutoConfiguration {
    @Bean(name={"searchWikipedia"})
    @ConditionalOnMissingBean
    @Description(value="Search Wikipedia for information using keywords.")
    public WikipediaService searchWikipedia(WikipediaProperties properties, JsonParseTool jsonParseTool) {
        return new WikipediaService(WebClientTool.builder((JsonParseTool)jsonParseTool, (CommonToolCallProperties)properties).httpHeadersConsumer(headers -> headers.add("User-Agent", "Spring AI Alibaba Wikipedia Tool/1.0")).build(), jsonParseTool, properties);
    }
}

