/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.wikipedia;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallUtils;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.common.interfaces.SearchService;
import com.alibaba.cloud.ai.toolcalling.wikipedia.WikipediaProperties;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class WikipediaService
implements SearchService,
Function<Request, Response> {
    private static final Logger logger = LoggerFactory.getLogger(WikipediaService.class);
    private final WebClientTool webClientTool;
    private final JsonParseTool jsonParseTool;
    private final WikipediaProperties properties;

    public WikipediaService(WebClientTool webClientTool, JsonParseTool jsonParseTool, WikipediaProperties properties) {
        this.webClientTool = webClientTool;
        this.jsonParseTool = jsonParseTool;
        this.properties = properties;
    }

    public SearchService.Response query(String query) {
        return this.apply(new Request(query, this.properties.getLimit(), false));
    }

    @Override
    public Response apply(Request request) {
        if (request == null || !StringUtils.hasText((String)request.query())) {
            logger.error("Invalid request: query is required.");
            return new Response("\u9519\u8bef\uff1a\u641c\u7d22\u67e5\u8be2\u4e0d\u80fd\u4e3a\u7a7a", new ArrayList<WikiPage>(), this.properties.getLanguage());
        }
        try {
            logger.info("Searching Wikipedia for: {}", (Object)request.query());
            String path = "w/api.php";
            MultiValueMap searchParams = CommonToolCallUtils.multiValueMapBuilder().add((Object)"action", (Object)"query").add((Object)"format", (Object)"json").add((Object)"list", (Object)"search").add((Object)"srsearch", (Object)request.query()).add((Object)"srlimit", (Object)String.valueOf(request.limit() > 0 ? request.limit() : this.properties.getLimit())).add((Object)"srprop", (Object)"snippet|titlesnippet|size|timestamp").build();
            String searchJsonResponse = (String)this.webClientTool.get(path, searchParams).block();
            Map searchResult = (Map)this.jsonParseTool.jsonToObject(searchJsonResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
            List<WikiPage> pages = this.parseSearchResults(searchResult);
            if (pages.isEmpty()) {
                return new Response("\u672a\u627e\u5230\u76f8\u5173\u7684Wikipedia\u9875\u9762", new ArrayList<WikiPage>(), this.properties.getLanguage());
            }
            if (request.includeContent()) {
                this.enrichPagesWithContent(pages.subList(0, Math.min(3, pages.size())));
            }
            String summary = String.format("\u627e\u5230 %d \u4e2a\u76f8\u5173\u9875\u9762", pages.size());
            return new Response(summary, pages, this.properties.getLanguage());
        }
        catch (Exception e) {
            logger.error("Failed to search Wikipedia: {}", (Object)e.getMessage(), (Object)e);
            return new Response("\u641c\u7d22Wikipedia\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage(), new ArrayList<WikiPage>(), this.properties.getLanguage());
        }
    }

    private List<WikiPage> parseSearchResults(Map<String, Object> searchResult) {
        ArrayList<WikiPage> pages = new ArrayList<WikiPage>();
        try {
            List searchResults;
            Map query = (Map)searchResult.get("query");
            if (query != null && (searchResults = (List)query.get("search")) != null) {
                for (Map result : searchResults) {
                    String title = (String)result.get("title");
                    String snippet = (String)result.get("snippet");
                    Integer pageId = (Integer)result.get("pageid");
                    Integer size = (Integer)result.get("size");
                    String timestamp = (String)result.get("timestamp");
                    if (snippet != null) {
                        snippet = snippet.replaceAll("<[^>]*>", "");
                    }
                    pages.add(new WikiPage(title, snippet, null, pageId, size, timestamp));
                }
            }
        }
        catch (Exception e) {
            logger.error("Error parsing search results: {}", (Object)e.getMessage());
        }
        return pages;
    }

    private void enrichPagesWithContent(List<WikiPage> pages) {
        for (WikiPage page : pages) {
            try {
                String path = "w/api.php";
                MultiValueMap contentParams = CommonToolCallUtils.multiValueMapBuilder().add((Object)"action", (Object)"query").add((Object)"format", (Object)"json").add((Object)"prop", (Object)"extracts").add((Object)"pageids", (Object)String.valueOf(page.pageId())).add((Object)"exintro", (Object)"true").add((Object)"explaintext", (Object)"true").add((Object)"exchars", (Object)String.valueOf(this.properties.getExcerptLength())).build();
                String contentJsonResponse = (String)this.webClientTool.get(path, contentParams).block();
                Map contentResult = (Map)this.jsonParseTool.jsonToObject(contentJsonResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
                String content = this.extractPageContent(contentResult, page.pageId());
                if (content == null) continue;
                pages.set(pages.indexOf(page), new WikiPage(page.title(), page.snippet(), content, page.pageId(), page.size(), page.timestamp()));
            }
            catch (Exception e) {
                logger.warn("Failed to get content for page {}: {}", (Object)page.title(), (Object)e.getMessage());
            }
        }
    }

    private String extractPageContent(Map<String, Object> contentResult, Integer pageId) {
        try {
            Map pageData;
            Map pages;
            Map query = (Map)contentResult.get("query");
            if (query != null && (pages = (Map)query.get("pages")) != null && (pageData = (Map)pages.get(String.valueOf(pageId))) != null) {
                return (String)pageData.get("extract");
            }
        }
        catch (Exception e) {
            logger.error("Error extracting page content: {}", (Object)e.getMessage());
        }
        return null;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonClassDescription(value="Wikipedia\u641c\u7d22\u8bf7\u6c42")
    public record Request(@JsonProperty(required=true) @JsonPropertyDescription(value="\u641c\u7d22\u67e5\u8be2\u5173\u952e\u8bcd") String query, @JsonProperty(defaultValue="5") @JsonPropertyDescription(value="\u8fd4\u56de\u7ed3\u679c\u6570\u91cf\u9650\u5236\uff0c\u9ed8\u8ba45") int limit, @JsonProperty(defaultValue="false") @JsonPropertyDescription(value="\u662f\u5426\u5305\u542b\u9875\u9762\u8be6\u7ec6\u5185\u5bb9\uff0c\u9ed8\u8ba4false") boolean includeContent) implements SearchService.Request
    {
        public String getQuery() {
            return this.query();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonClassDescription(value="Wikipedia\u641c\u7d22\u54cd\u5e94")
    public record Response(@JsonProperty @JsonPropertyDescription(value="\u641c\u7d22\u7ed3\u679c\u6458\u8981") String summary, @JsonProperty @JsonPropertyDescription(value="\u641c\u7d22\u5230\u7684\u9875\u9762\u5217\u8868") List<WikiPage> pages, String language) implements SearchService.Response
    {
        public SearchService.SearchResult getSearchResult() {
            return new SearchService.SearchResult(this.pages().stream().map(page -> new SearchService.SearchContent(page.title(), page.content() != null ? page.content() : page.snippet(), this.buildWikipediaUrl(page.title()), null)).toList());
        }

        private String buildWikipediaUrl(String title) {
            if (title == null) {
                return "https://" + (this.language != null ? this.language : "zh") + ".wikipedia.org/";
            }
            String encodedTitle = title.replace(" ", "_").replace("(", "%28").replace(")", "%29");
            return "https://" + (this.language != null ? this.language : "zh") + ".wikipedia.org/wiki/" + encodedTitle;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonClassDescription(value="Wikipedia\u9875\u9762\u4fe1\u606f")
    public record WikiPage(@JsonProperty @JsonPropertyDescription(value="\u9875\u9762\u6807\u9898") String title, @JsonProperty @JsonPropertyDescription(value="\u9875\u9762\u6458\u8981\u7247\u6bb5") String snippet, @JsonProperty @JsonPropertyDescription(value="\u9875\u9762\u8be6\u7ec6\u5185\u5bb9\uff08\u5982\u679c\u8bf7\u6c42\uff09") String content, @JsonProperty @JsonPropertyDescription(value="\u9875\u9762ID") Integer pageId, @JsonProperty @JsonPropertyDescription(value="\u9875\u9762\u5927\u5c0f\uff08\u5b57\u8282\uff09") Integer size, @JsonProperty @JsonPropertyDescription(value="\u6700\u540e\u4fee\u6539\u65f6\u95f4") String timestamp) {
    }
}

