/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.gateway.scg;

import com.alibaba.cloud.sentinel.gateway.FallbackProperties;
import com.alibaba.cloud.sentinel.gateway.scg.SentinelGatewayProperties;
import com.alibaba.csp.sentinel.adapter.gateway.sc.SentinelGatewayFilter;
import com.alibaba.csp.sentinel.adapter.gateway.sc.callback.BlockRequestHandler;
import com.alibaba.csp.sentinel.adapter.gateway.sc.callback.GatewayCallbackManager;
import com.alibaba.csp.sentinel.adapter.gateway.sc.callback.RedirectBlockRequestHandler;
import com.alibaba.csp.sentinel.adapter.gateway.sc.exception.SentinelGatewayBlockExceptionHandler;
import com.alibaba.csp.sentinel.util.StringUtil;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.result.view.ViewResolver;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={GlobalFilter.class})
@ConditionalOnProperty(prefix="spring.cloud.sentinel.scg", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SentinelGatewayProperties.class})
public class SentinelSCGAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SentinelSCGAutoConfiguration.class);
    private final List<ViewResolver> viewResolvers;
    private final ServerCodecConfigurer serverCodecConfigurer;
    @Autowired
    private Optional<BlockRequestHandler> blockRequestHandlerOptional;
    @Autowired
    private SentinelGatewayProperties gatewayProperties;

    @PostConstruct
    public void init() {
        this.blockRequestHandlerOptional.ifPresent(GatewayCallbackManager::setBlockHandler);
        this.initAppType();
        this.initFallback();
    }

    public SentinelSCGAutoConfiguration(ObjectProvider<List<ViewResolver>> viewResolversProvider, ServerCodecConfigurer serverCodecConfigurer) {
        this.viewResolvers = (List)viewResolversProvider.getIfAvailable(Collections::emptyList);
        this.serverCodecConfigurer = serverCodecConfigurer;
    }

    private void initAppType() {
        System.setProperty("csp.sentinel.app.type", "11");
    }

    private void initFallback() {
        FallbackProperties fallbackProperties = this.gatewayProperties.getFallback();
        if (fallbackProperties == null || StringUtil.isBlank((String)fallbackProperties.getMode())) {
            return;
        }
        if ("response".equals(fallbackProperties.getMode()) && StringUtil.isNotBlank((String)fallbackProperties.getResponseBody())) {
            GatewayCallbackManager.setBlockHandler((exchange, t) -> ServerResponse.status((int)fallbackProperties.getResponseStatus()).contentType(MediaType.valueOf((String)fallbackProperties.getContentType())).body(BodyInserters.fromValue((Object)fallbackProperties.getResponseBody())));
            logger.info("[Sentinel SpringCloudGateway] using AnonymousBlockRequestHandler, responseStatus: " + fallbackProperties.getResponseStatus() + ", responseBody: " + fallbackProperties.getResponseBody());
        }
        String redirectUrl = fallbackProperties.getRedirect();
        if ("redirect".equals(fallbackProperties.getMode()) && StringUtil.isNotBlank((String)redirectUrl)) {
            GatewayCallbackManager.setBlockHandler((BlockRequestHandler)new RedirectBlockRequestHandler(redirectUrl));
            logger.info("[Sentinel SpringCloudGateway] using RedirectBlockRequestHandler, redirectUrl: " + redirectUrl);
        }
    }

    @Bean
    @Order(value=-2147483648)
    @ConditionalOnMissingBean
    public SentinelGatewayBlockExceptionHandler sentinelGatewayBlockExceptionHandler() {
        logger.info("[Sentinel SpringCloudGateway] register SentinelGatewayBlockExceptionHandler");
        return new SentinelGatewayBlockExceptionHandler(this.viewResolvers, this.serverCodecConfigurer);
    }

    @Bean
    @Order(value=-1)
    @ConditionalOnMissingBean
    public SentinelGatewayFilter sentinelGatewayFilter() {
        logger.info("[Sentinel SpringCloudGateway] register SentinelGatewayFilter with order: {}", (Object)this.gatewayProperties.getOrder());
        return new SentinelGatewayFilter(this.gatewayProperties.getOrder().intValue());
    }
}

