/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.configdata;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.configdata.NacosConfigDataLoadProperties;
import com.alibaba.cloud.nacos.configdata.NacosConfigDataResource;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.Ordered;

public class NacosConfigDataLocationResolver
implements ConfigDataLocationResolver<NacosConfigDataResource>,
Ordered {
    public static final String PREFIX = "nacos:";
    private static final String GROUP = "group";
    private static final String REFRESH_ENABLED = "refreshEnabled";
    private static final String PREFERENCE = "preference";
    private final Log log;

    public NacosConfigDataLocationResolver(DeferredLogFactory logFactory) {
        this.log = logFactory.getLog(this.getClass());
    }

    public int getOrder() {
        return -1;
    }

    protected NacosConfigProperties loadProperties(ConfigDataLocationResolverContext context) {
        Binder binder = context.getBinder();
        BindHandler bindHandler = this.getBindHandler(context);
        NacosConfigProperties nacosConfigProperties = context.getBootstrapContext().isRegistered(NacosConfigDataLoadProperties.class) ? (NacosConfigProperties)context.getBootstrapContext().get(NacosConfigDataLoadProperties.class) : (NacosConfigProperties)binder.bind("spring.cloud.nacos", Bindable.of(NacosConfigDataLoadProperties.class), bindHandler).map(properties -> (NacosConfigDataLoadProperties)binder.bind("spring.cloud.nacos.config", Bindable.ofInstance((Object)properties), bindHandler).orElse(properties)).orElseGet(() -> (NacosConfigDataLoadProperties)binder.bind("spring.cloud.nacos.config", Bindable.of(NacosConfigDataLoadProperties.class), bindHandler).orElseGet(NacosConfigDataLoadProperties::new));
        return nacosConfigProperties;
    }

    private BindHandler getBindHandler(ConfigDataLocationResolverContext context) {
        return (BindHandler)context.getBootstrapContext().getOrElse(BindHandler.class, null);
    }

    protected Log getLog() {
        return this.log;
    }

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        if (!location.hasPrefix(this.getPrefix())) {
            return false;
        }
        return (Boolean)context.getBinder().bind("spring.cloud.nacos.config.enabled", Boolean.class).orElse((Object)true);
    }

    protected String getPrefix() {
        return PREFIX;
    }

    public List<NacosConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        return Collections.emptyList();
    }

    public List<NacosConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        NacosConfigProperties properties = this.loadProperties(resolverContext);
        ConfigurableBootstrapContext bootstrapContext = resolverContext.getBootstrapContext();
        bootstrapContext.registerIfAbsent(NacosConfigProperties.class, BootstrapRegistry.InstanceSupplier.of((Object)properties));
        this.registerConfigManager(properties, bootstrapContext);
        return this.loadConfigDataResources(location, profiles, properties);
    }

    private List<NacosConfigDataResource> loadConfigDataResources(ConfigDataLocation location, Profiles profiles, NacosConfigProperties properties) {
        ArrayList<NacosConfigDataResource> result = new ArrayList<NacosConfigDataResource>();
        URI uri = this.getUri(location, properties);
        if (StringUtils.isBlank((CharSequence)this.dataIdFor(uri))) {
            throw new IllegalArgumentException("dataId must be specified");
        }
        NacosConfigDataResource resource = new NacosConfigDataResource(properties, location.isOptional(), profiles, this.log, new NacosConfigDataResource.NacosItemConfig().setGroup(this.groupFor(uri, properties)).setDataId(this.dataIdFor(uri)).setSuffix(this.suffixFor(uri, properties)).setRefreshEnabled(this.refreshEnabledFor(uri, properties)).setPreference(this.preferenceFor(uri)));
        result.add(resource);
        return result;
    }

    private String preferenceFor(URI uri) {
        return this.getQueryMap(uri).get(PREFERENCE);
    }

    private URI getUri(ConfigDataLocation location, NacosConfigProperties properties) {
        Object path = location.getNonPrefixedValue(this.getPrefix());
        if (StringUtils.isBlank((CharSequence)path)) {
            path = "/";
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        String uri = properties.getServerAddr() + (String)path;
        return this.getUri(uri);
    }

    private void registerConfigManager(NacosConfigProperties properties, ConfigurableBootstrapContext bootstrapContext) {
        if (!bootstrapContext.isRegistered(NacosConfigManager.class)) {
            bootstrapContext.register(NacosConfigManager.class, BootstrapRegistry.InstanceSupplier.of((Object)new NacosConfigManager(properties)));
        }
    }

    private URI getUri(String uris) {
        URI uri;
        if (!((String)uris).startsWith("http://") && !((String)uris).startsWith("https://")) {
            uris = "http://" + (String)uris;
        }
        try {
            uri = new URI((String)uris);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("illegal URI: " + (String)uris);
        }
        return uri;
    }

    private String groupFor(URI uri, NacosConfigProperties properties) {
        Map<String, String> queryMap = this.getQueryMap(uri);
        return queryMap.containsKey(GROUP) ? queryMap.get(GROUP) : properties.getGroup();
    }

    private Map<String, String> getQueryMap(URI uri) {
        String query = uri.getQuery();
        if (StringUtils.isBlank((CharSequence)query)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>(4);
        for (String entry : query.split("&")) {
            String[] kv = entry.split("=");
            if (kv.length != 2) continue;
            result.put(kv[0], kv[1]);
        }
        return result;
    }

    private String suffixFor(URI uri, NacosConfigProperties properties) {
        String dataId = this.dataIdFor(uri);
        if (dataId != null && dataId.contains(".")) {
            return dataId.substring(dataId.lastIndexOf(46) + 1);
        }
        return properties.getFileExtension();
    }

    private boolean refreshEnabledFor(URI uri, NacosConfigProperties properties) {
        Map<String, String> queryMap = this.getQueryMap(uri);
        return queryMap.containsKey(REFRESH_ENABLED) ? Boolean.parseBoolean(queryMap.get(REFRESH_ENABLED)) : properties.isRefreshEnabled();
    }

    private String dataIdFor(URI uri) {
        String path = uri.getPath();
        if (path == null || path.length() <= 1) {
            return "";
        }
        String[] parts = path.substring(1).split("/");
        if (parts.length != 1) {
            throw new IllegalArgumentException("illegal dataId");
        }
        return parts[0];
    }
}

