/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.common.param;

import com.alibaba.csp.sentinel.adapter.gateway.common.param.RequestItemParser;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ConfigurableRequestItemParser<T>
implements RequestItemParser<T> {
    private final List<Function<T, String>> pathExtractors = new ArrayList<Function<T, String>>(2);
    private final List<Function<T, String>> remoteAddressExtractors = new ArrayList<Function<T, String>>(2);
    private final List<BiFunction<T, String, String>> headerExtractors = new ArrayList<BiFunction<T, String, String>>(2);
    private final List<BiFunction<T, String, String>> urlParamExtractors = new ArrayList<BiFunction<T, String, String>>(2);
    private final List<BiFunction<T, String, String>> cookieValueExtractors = new ArrayList<BiFunction<T, String, String>>(2);
    private final RequestItemParser<T> delegate;

    public ConfigurableRequestItemParser(RequestItemParser<T> delegate) {
        AssertUtil.notNull(delegate, (String)"delegate can not be null");
        this.delegate = delegate;
    }

    @Override
    public String getPath(T request) {
        for (Function<T, String> extractor : this.pathExtractors) {
            String pathValue = extractor.apply(request);
            if (!StringUtil.isNotBlank((String)pathValue)) continue;
            return pathValue;
        }
        return this.delegate.getPath(request);
    }

    @Override
    public String getRemoteAddress(T request) {
        for (Function<T, String> extractor : this.remoteAddressExtractors) {
            String remoteAddress = extractor.apply(request);
            if (!StringUtil.isNotBlank((String)remoteAddress)) continue;
            return remoteAddress;
        }
        return this.delegate.getRemoteAddress(request);
    }

    @Override
    public String getHeader(T request, String key) {
        for (BiFunction<T, String, String> extractor : this.headerExtractors) {
            String headerValue = extractor.apply(request, key);
            if (!StringUtil.isNotBlank((String)headerValue)) continue;
            return headerValue;
        }
        return this.delegate.getHeader(request, key);
    }

    @Override
    public String getUrlParam(T request, String paramName) {
        for (BiFunction<T, String, String> extractor : this.urlParamExtractors) {
            String urlParam = extractor.apply(request, paramName);
            if (!StringUtil.isNotBlank((String)urlParam)) continue;
            return urlParam;
        }
        return this.delegate.getUrlParam(request, paramName);
    }

    @Override
    public String getCookieValue(T request, String cookieName) {
        for (BiFunction<T, String, String> extractor : this.cookieValueExtractors) {
            String cookie = extractor.apply(request, cookieName);
            if (!StringUtil.isNotBlank((String)cookie)) continue;
            return cookie;
        }
        return this.delegate.getCookieValue(request, cookieName);
    }

    public ConfigurableRequestItemParser<T> addPathExtractor(Function<T, String> extractor) {
        if (extractor == null) {
            return this;
        }
        this.pathExtractors.add(extractor);
        return this;
    }

    public ConfigurableRequestItemParser<T> addRemoteAddressExtractor(Function<T, String> extractor) {
        if (extractor == null) {
            return this;
        }
        this.remoteAddressExtractors.add(extractor);
        return this;
    }

    public ConfigurableRequestItemParser<T> addHeaderExtractor(BiFunction<T, String, String> extractor) {
        if (extractor == null) {
            return this;
        }
        this.headerExtractors.add(extractor);
        return this;
    }

    public ConfigurableRequestItemParser<T> addUrlParamExtractor(BiFunction<T, String, String> extractor) {
        if (extractor == null) {
            return this;
        }
        this.urlParamExtractors.add(extractor);
        return this;
    }

    public ConfigurableRequestItemParser<T> addCookieValueExtractor(BiFunction<T, String, String> extractor) {
        if (extractor == null) {
            return this;
        }
        this.cookieValueExtractors.add(extractor);
        return this;
    }
}

