/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.grid.processor;

import com.alibaba.dts.client.executor.grid.processor.GridJobContext;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.context.JobContextImpl;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.service.ServerService;
import com.alibaba.dts.common.util.BytesUtil;
import com.alibaba.dts.common.util.BytesUtil4Client;
import com.alibaba.dts.common.util.StringUtil;
import java.util.List;

public class GridJobContextImpl
extends JobContextImpl
implements Constants,
GridJobContext {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(GridJobContextImpl.class);
    private TaskSnapshot taskSnapshot;
    private Object task;
    private String taskName;
    private int availableMachineAmount;
    private int currentMachineNumber;
    private ServerService serverService;
    private ClientContextImpl clientContext;

    public GridJobContextImpl(ClientContextImpl clientContext, Job job, JobInstanceSnapshot jobInstanceSnapshot, int retryCount) {
        super(job, jobInstanceSnapshot, retryCount);
        this.clientContext = clientContext;
        this.serverService = this.clientContext.getClientRemoting().proxyInterface(ServerService.class);
    }

    @Override
    public Object getTask() {
        return this.task;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public void setTask(TaskSnapshot taskSnapshot) {
        this.taskSnapshot = taskSnapshot;
        this.taskName = taskSnapshot.getTaskName();
        if ("defaultTaskName4DtsServerSelf".equals(taskSnapshot.getTaskName())) {
            if (BytesUtil.isEmpty(taskSnapshot.getBody())) {
                logger.error("[GridJobContext]: BytesUtil setTask bytesToObject error, body is empty, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId());
                return;
            }
            try {
                this.task = BytesUtil.bytesToObject(taskSnapshot.getBody());
            }
            catch (Throwable e) {
                logger.error("[GridJobContext]: BytesUtil setTask bytesToObject error, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId(), e);
            }
        } else {
            if (BytesUtil4Client.isEmpty(taskSnapshot.getBody())) {
                logger.error("[GridJobContext]: BytesUtil4Client setTask bytesToObject error, body is empty, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId());
                return;
            }
            try {
                this.task = BytesUtil4Client.bytesToObject(taskSnapshot.getBody());
            }
            catch (Throwable e) {
                logger.error("[GridJobContext]: BytesUtil4Client setTask bytesToObject error, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId(), e);
            }
        }
    }

    @Override
    public void initRetryCount(int retryCount) {
        super.setRetryCount(retryCount);
    }

    @Override
    public Result<Boolean> dispatchTaskList(List<? extends Object> taskList, String taskName) {
        if (StringUtil.isEmpty(taskName)) {
            logger.error(ResultCode.TASK_NAME_EMPTY.getInformation());
            return new Result<Boolean>(false, ResultCode.TASK_NAME_EMPTY);
        }
        if (taskName.length() > 200) {
            logger.error(ResultCode.TASK_NAME_TOO_LONG.getInformation());
            return new Result<Boolean>(false, ResultCode.TASK_NAME_TOO_LONG);
        }
        if (taskList == null || taskList.isEmpty()) {
            logger.error("taskList is null or empty");
            return new Result<Boolean>(false, ResultCode.DISPATCH_TASK_LIST_IS_EMPTY);
        }
        logger.info("[GridJobContext]: dispatchTaskList taskList, size=" + taskList.size() + ", taskName=" + taskName);
        Result<Boolean> result = this.clientContext.getGridTaskSender().dispatchTaskList(taskList, taskName, this);
        return result;
    }

    @Override
    public TaskSnapshot getTaskSnapshot() {
        return this.taskSnapshot;
    }
}

