/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.longtime.processor;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.processor.LongTimeJobProcessor;
import com.alibaba.dts.client.executor.longtime.processor.LongTimeJobContext;
import com.alibaba.dts.client.executor.longtime.processor.LongTimeJobContextImpl;
import com.alibaba.dts.client.executor.longtime.unit.ExecutorUnit;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.result.ProcessResult;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.util.concurrent.atomic.AtomicInteger;

public class LongTimeTaskProcessor
extends Thread
implements Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(LongTimeTaskProcessor.class);
    private static final Logger executeLogger = SchedulerXLoggerFactory.getExecuteLogger();
    private ExecutorUnit executorUnit;
    private volatile boolean stop = false;
    private int status = 0;
    private AtomicInteger threadCounter;
    private LongTimeJobContext context;
    private final ClientContextImpl clientContext;

    public LongTimeTaskProcessor(ClientContextImpl clientContext, ExecutorUnit executorUnit, int index, AtomicInteger threadCounter) {
        this.clientContext = clientContext;
        this.executorUnit = executorUnit;
        super.setName("DtsTaskProcessor-" + executorUnit.getExecutableTask().getJob().getId() + "-" + executorUnit.getExecutableTask().getJob().getJobProcessor() + "-" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getId() + "-" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getFireTime() + "-" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getRetryCount() + "-" + index);
        this.threadCounter = threadCounter;
        this.context = new LongTimeJobContextImpl(clientContext, this.executorUnit.getExecutableTask().getJob(), this.executorUnit.getExecutableTask().getJobInstanceSnapshot(), executorUnit.getExecutableTask().getJobInstanceSnapshot().getRetryCount());
        String[] jobProcessorProperties = executorUnit.getExecutableTask().getJob().getJobProcessor().split(":");
        String jobProcessor = jobProcessorProperties[0].trim();
        if (this.clientContext.getClientConfig().getFailureJobProcessorMap() == null || this.clientContext.getClientConfig().getFailureJobProcessorMap().get(jobProcessor) != null) {
            // empty if block
        }
        this.context.setAvailableMachineAmount(this.executorUnit.getExecutableTask().getAvailableMachineAmount());
        this.context.setCurrentMachineNumber(this.executorUnit.getExecutableTask().getCurrentMachineNumber());
    }

    public void refresh(ExecutorUnit executorUnit, int index) {
        this.executorUnit = executorUnit;
        super.setName("DtsTaskProcessor-" + executorUnit.getExecutableTask().getJob().getId() + "-" + executorUnit.getExecutableTask().getJob().getJobProcessor() + "-" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getId() + "-" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getFireTime() + "-" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getRetryCount() + "-" + index);
        this.context = new LongTimeJobContextImpl(this.clientContext, this.executorUnit.getExecutableTask().getJob(), this.executorUnit.getExecutableTask().getJobInstanceSnapshot(), executorUnit.getExecutableTask().getJobInstanceSnapshot().getRetryCount());
        String[] jobProcessorProperties = executorUnit.getExecutableTask().getJob().getJobProcessor().split(":");
        String jobProcessor = jobProcessorProperties[0].trim();
        if (this.clientContext.getClientConfig().getFailureJobProcessorMap() == null || this.clientContext.getClientConfig().getFailureJobProcessorMap().get(jobProcessor) != null) {
            // empty if block
        }
    }

    private boolean isJobInstanceStop() {
        int count = this.clientContext.getExecutor().getLongTimePool().runInstanceCount(this.executorUnit.getExecutableTask().getJob().getId(), this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());
        return count == 0;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTask(TaskSnapshot taskSnapshot, LongTimeJobProcessor longTimeJobProcessor) {
        if (null == longTimeJobProcessor) {
            logger.error("[LongTimeTaskProcessor]: jobProcessor is null, please check " + this.executorUnit.getExecutableTask().getJob().getJobProcessor());
            this.clientContext.getExecutor().acknowledge(taskSnapshot, 4, 0);
            return;
        }
        long startTime = 0L;
        long runtime = 0L;
        this.status = 1;
        this.threadCounter.incrementAndGet();
        ProcessResult processResult = null;
        try {
            this.context.setTask(taskSnapshot);
            try {
                this.handleTaskBefore(taskSnapshot);
                startTime = System.currentTimeMillis();
                executeLogger.info("longTimeJobProcessor start...,instanceId:" + taskSnapshot.getJobInstanceId() + ",taskId:" + taskSnapshot.getId());
                processResult = longTimeJobProcessor.process(this.context);
                runtime = System.currentTimeMillis() - startTime;
                executeLogger.info("longTimeJobProcessor end...,instanceId:" + taskSnapshot.getJobInstanceId() + ",taskId:" + taskSnapshot.getId() + ",runtime:" + runtime + ",processResult:" + processResult.toString());
            }
            catch (Throwable e) {
                logger.error("[LongTimeTaskProcessor]: process error, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId(), e);
            }
            if (null == processResult) {
                logger.error("[LongTimeTaskProcessor]: process error, processResult is null, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId());
                processResult = new ProcessResult(false);
            }
            this.handleTaskPost(taskSnapshot, processResult, runtime);
            this.threadCounter.decrementAndGet();
        }
        catch (Throwable e) {
            try {
                logger.error("[LongTimeTaskProcessor]: executeTask error, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId(), e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.handleTaskPost(taskSnapshot, processResult, runtime);
                this.threadCounter.decrementAndGet();
                this.status = 0;
            }
        }
        this.status = 0;
    }

    private void handleTaskBefore(TaskSnapshot taskSnapshot) {
        try {
            if (!this.executorUnit.isExistsInTaskRunStatisticMap(taskSnapshot.getId())) {
                this.executorUnit.addTaskRunStatisticMap(taskSnapshot.getId(), 2);
            }
        }
        catch (Throwable e) {
            logger.error("[LongTimeTaskProcessor]:  handleTaskBefore process error, thread:" + Thread.currentThread().getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTaskPost(TaskSnapshot taskSnapshot, ProcessResult processResult, long runtime) {
        Long sleeptime = 50L;
        if (processResult != null && processResult.getSleepTime() >= 0L) {
            sleeptime = processResult.getSleepTime();
            try {
                Thread.sleep(sleeptime);
            }
            catch (Throwable e) {
                logger.error("[LongTimeTaskProcessor]:  post process error, thread:" + Thread.currentThread().getName(), e);
            }
            finally {
                if (!taskSnapshot.getTaskName().equals("defaultTaskName4DtsServerSelf")) {
                    this.executorUnit.taskPostProcess(taskSnapshot);
                }
            }
        } else {
            try {
                Thread.sleep(sleeptime);
            }
            catch (Throwable e) {
                logger.error("[LongTimeTaskProcessor]:  post process error, thread:" + Thread.currentThread().getName(), e);
            }
            finally {
                if (!taskSnapshot.getTaskName().equals("defaultTaskName4DtsServerSelf")) {
                    this.executorUnit.taskPostProcess(taskSnapshot);
                }
            }
        }
        try {
            Result<Boolean> ackResult = null;
            if (this.executorUnit.isExistsInTaskRunStatisticMap(taskSnapshot.getId())) {
                if (this.executorUnit.getTaskRunStatisticMap().get(taskSnapshot.getId()).getProcessResult() == 2) {
                    ackResult = taskSnapshot.getTaskName().equals("defaultTaskName4DtsServerSelf") ? this.clientContext.getExecutor().acknowledgeRes(taskSnapshot, 3, 0) : this.clientContext.getExecutor().acknowledgeRes(taskSnapshot, 6, 0);
                    if (processResult.isSuccess()) {
                        if (null == ackResult || !ackResult.getData().booleanValue()) {
                            this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime, 8);
                        } else {
                            this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime, 3);
                        }
                    } else if (null == ackResult || !ackResult.getData().booleanValue()) {
                        this.executorUnit.addTaskRunStatisticMap(taskSnapshot.getId(), 8);
                    } else {
                        this.executorUnit.addTaskRunStatisticMap(taskSnapshot.getId(), 4);
                    }
                } else if (processResult.isSuccess()) {
                    if (this.executorUnit.getTaskRunStatisticMap().get(taskSnapshot.getId()).getProcessResult() != 6) {
                        ackResult = this.clientContext.getExecutor().acknowledgeRes(taskSnapshot, 6, 0);
                        if (null == ackResult || !ackResult.getData().booleanValue()) {
                            this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime, 8);
                        } else {
                            this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime, 6);
                        }
                    } else {
                        this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime);
                    }
                } else if (this.executorUnit.getTaskRunStatisticMap().get(taskSnapshot.getId()).getProcessResult() != 4) {
                    ackResult = this.clientContext.getExecutor().acknowledgeRes(taskSnapshot, 4, 0);
                    if (null == ackResult || !ackResult.getData().booleanValue()) {
                        this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime, 8);
                    } else {
                        this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime, 4);
                    }
                } else {
                    this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime);
                }
            } else {
                logger.error("[LongTimeTaskProcessor]:  updateTaskRunStatisticMap error, task not exist,taskid:" + taskSnapshot.getId());
            }
        }
        catch (Throwable e) {
            logger.error("[LongTimeTaskProcessor]:  acknowledge process error, thread:" + Thread.currentThread().getName(), e);
        }
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
        this.context.setStop(stop);
    }

    public int getStatus() {
        return this.status;
    }
}

