/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.parallel;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.parallel.unit.ExecutorUnit;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.CollectionUtils;

public class ParallelPool
implements Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ParallelPool.class);
    private ConcurrentHashMap<Long, ConcurrentHashMap<Long, ExecutorUnit>> executorUnitTable = new ConcurrentHashMap();
    private final ClientContextImpl clientContext;

    public ParallelPool(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public void stopService() {
        Iterator<Map.Entry<Long, ConcurrentHashMap<Long, ExecutorUnit>>> iterator = this.executorUnitTable.entrySet().iterator();
        long jobCount = 0L;
        long processorCount = 0L;
        while (iterator.hasNext()) {
            long jobid = 0L;
            ++jobCount;
            try {
                Map.Entry<Long, ConcurrentHashMap<Long, ExecutorUnit>> entry = iterator.next();
                jobid = entry.getKey();
                ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = entry.getValue();
                if (CollectionUtils.isEmpty(executorUnitMap)) continue;
                Iterator<Map.Entry<Long, ExecutorUnit>> executorUnitIterator = executorUnitMap.entrySet().iterator();
                while (executorUnitIterator.hasNext()) {
                    ++processorCount;
                    Map.Entry<Long, ExecutorUnit> processorEntity = executorUnitIterator.next();
                    ExecutorUnit processor = processorEntity.getValue();
                    processor.stopTask();
                }
            }
            catch (Throwable e) {
                logger.error("[SimplePool]: stopService error, jobid:" + jobid, e);
            }
            logger.info("[SimplePool]: stopService, jobCount:" + jobCount + ", processorCount:" + processorCount);
        }
        this.executorUnitTable.clear();
    }

    public boolean executeTask(ExecutableTask executableTask) {
        ExecutorUnit executorUnit;
        ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = this.executorUnitTable.get(executableTask.getJob().getId());
        if (null == executorUnitMap) {
            executorUnitMap = new ConcurrentHashMap();
            ConcurrentHashMap<Long, ExecutorUnit> existExecutorUnitMap = this.executorUnitTable.putIfAbsent(executableTask.getJob().getId(), executorUnitMap);
            if (existExecutorUnitMap != null) {
                executorUnitMap = existExecutorUnitMap;
            }
        }
        if (null == (executorUnit = executorUnitMap.get(executableTask.getJobInstanceSnapshot().getId()))) {
            executorUnit = new ExecutorUnit(this.clientContext, this, executableTask);
            ExecutorUnit existExecutorUnit = executorUnitMap.putIfAbsent(executableTask.getJobInstanceSnapshot().getId(), executorUnit);
            if (existExecutorUnit != null) {
                executorUnit = null;
            } else {
                try {
                    executorUnit.init();
                    logger.warn("[ParallelPool]: executeTask init, executableTask:" + executableTask);
                }
                catch (Throwable e) {
                    logger.error("[ParallelPool]: executeTask init error, instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean stopTask(long jobId, long jobInstanceId) {
        ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = this.executorUnitTable.get(jobId);
        if (null == executorUnitMap || executorUnitMap.isEmpty()) {
            return true;
        }
        ExecutorUnit executorUnit = executorUnitMap.get(jobInstanceId);
        if (null == executorUnit) {
            return true;
        }
        executorUnit.stopTask();
        if (!executorUnit.isExistsProcessors()) {
            try {
                executorUnitMap.remove(jobInstanceId);
                logger.info("removed jobInstanceId=" + jobInstanceId + " from executorUnitMap");
            }
            catch (Throwable e) {
                logger.error("[ParallelPool]: stopTask remove error, jobId:" + jobId + ", jobInstanceId:" + jobInstanceId, e);
                return false;
            }
        }
        return true;
    }

    public boolean forceStopTask(long jobId, long jobInstanceId) {
        ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = this.executorUnitTable.get(jobId);
        if (null == executorUnitMap || executorUnitMap.isEmpty()) {
            return true;
        }
        ExecutorUnit executorUnit = executorUnitMap.get(jobInstanceId);
        if (null == executorUnit) {
            return true;
        }
        executorUnit.forceStopTask();
        try {
            executorUnitMap.remove(jobInstanceId);
        }
        catch (Throwable e) {
            logger.error("[ParallelPool]: forceStopTask remove error, jobId:" + jobId + ", jobInstanceId:" + jobInstanceId, e);
            return false;
        }
        return true;
    }

    public Result<String> heartBeatCheckJobInstance(long jobId, long jobInstanceId) {
        Result<String> result = new Result<String>();
        ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = this.executorUnitTable.get(jobId);
        if (null == executorUnitMap || executorUnitMap.isEmpty()) {
            result.setResultCode(ResultCode.HEART_BEAT_CHECK_EXIT);
            return result;
        }
        ExecutorUnit executorUnit = executorUnitMap.get(jobInstanceId);
        if (null == executorUnit) {
            result.setResultCode(ResultCode.HEART_BEAT_CHECK_EXIT);
            return result;
        }
        if (executorUnit.isExecutorStop()) {
            result.setResultCode(ResultCode.HEART_BEAT_CHECK_FAILURE);
            return result;
        }
        result.setResultCode(ResultCode.HEART_BEAT_CHECK_SUCCESS);
        return result;
    }

    public Result<Boolean> push(long jobId, long jobInstanceId, TaskSnapshot taskSnapshot) {
        ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = this.executorUnitTable.get(jobId);
        if (null == executorUnitMap || executorUnitMap.isEmpty()) {
            return new Result<Boolean>(false, ResultCode.PUSH_UNIT_MAP_IS_EMPTY_ERROR);
        }
        ExecutorUnit executorUnit = executorUnitMap.get(jobInstanceId);
        if (null == executorUnit) {
            return new Result<Boolean>(false, ResultCode.PUSH_UNIT_IS_NULL_ERROR);
        }
        boolean result = executorUnit.offer(taskSnapshot);
        return new Result<Boolean>(result, result ? ResultCode.SUCCESS : ResultCode.FAILURE);
    }
}

