/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.remoting.processor;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.remoting.protocol.InvokeMethod;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.helper.RemotingHelper;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.proxy.ProxyService;
import com.alibaba.dts.common.remoting.netty.NettyRequestProcessor;
import com.alibaba.dts.common.remoting.protocol.RemotingCommand;
import com.alibaba.dts.common.remoting.protocol.RemotingSerializable;
import com.alibaba.dts.common.util.BytesUtil;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.dts.shade.io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.LinkedBlockingQueue;

public class NodeServerRequestProcessor
implements NettyRequestProcessor,
Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(NodeServerRequestProcessor.class);
    private LinkedBlockingQueue<Runnable> requestQueue = null;
    private ClientContextImpl clientContext;

    public NodeServerRequestProcessor(LinkedBlockingQueue<Runnable> requestQueue, ClientContextImpl clientContext) {
        this.requestQueue = requestQueue;
        this.clientContext = clientContext;
    }

    public void init() throws InitException {
    }

    @Override
    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        long startTime = System.currentTimeMillis();
        byte[] requestBody = request.getBody();
        if (null == requestBody) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[NodeServerRequestProcessor]: requestBody is null, remoteAddress:" + remoteAddress);
            return new RemotingCommand();
        }
        String json = null;
        try {
            json = (String)BytesUtil.bytesToObject(requestBody);
        }
        catch (Throwable e) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[NodeServerRequestProcessor]: bytesToObject error, remoteAddress:" + remoteAddress, e);
            return new RemotingCommand();
        }
        if (StringUtil.isBlank(json)) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[NodeServerRequestProcessor]: json is null, remoteAddress:" + remoteAddress);
            return new RemotingCommand();
        }
        InvokeMethod invokeMethod = InvokeMethod.newInstance(json);
        invokeMethod.getRemoteMachine().setChannel(ctx.channel());
        InvocationContext.setRemoteMachine(invokeMethod.getRemoteMachine());
        Object result = this.clientContext.getProxyService().invokeMethod(this.clientContext.getNodeServerServiceLocal(), invokeMethod.getMethodName(), invokeMethod.getClassArray(), invokeMethod.getObjectArray());
        InvocationContext.clean();
        Class<?> returnClass = ProxyService.getClass(invokeMethod.getReturnType());
        if (Void.TYPE == returnClass) {
            return new RemotingCommand();
        }
        if (null == result) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[NodeServerRequestProcessor]: result is null, remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod);
            return new RemotingCommand();
        }
        byte[] responseBody = null;
        try {
            responseBody = BytesUtil.objectToBytes(RemotingSerializable.toJson(result, false));
        }
        catch (Throwable e) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[NodeServerRequestProcessor]: objectToBytes error, remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod, e);
            return new RemotingCommand();
        }
        RemotingCommand response = new RemotingCommand();
        response.setBody(responseBody);
        return response;
    }

    public LinkedBlockingQueue<Runnable> getRequestQueue() {
        return this.requestQueue;
    }
}

