/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.remoting.timer;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.util.List;
import java.util.TimerTask;
import org.springframework.util.CollectionUtils;

public class DtsClientHeartBeatTimer
extends TimerTask {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(DtsClientHeartBeatTimer.class);
    private final ClientContextImpl clientContext;

    public DtsClientHeartBeatTimer(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    @Override
    public void run() {
        try {
            List<String> serverList = this.clientContext.getZookeeper().getServerList();
            if (CollectionUtils.isEmpty(serverList)) {
                logger.error("[DtsClientHeartBeatTimer]: serverList is empty, clientConfig:" + this.clientContext.getClientConfig().toString());
                serverList = this.clientContext.getClientRemoting().getServerList();
            } else {
                this.clientContext.getClientRemoting().setServerListCache(serverList);
            }
            for (String server : serverList) {
                try {
                    this.clientContext.getClientRemoting().connectServer(server);
                }
                catch (Throwable e) {
                    logger.error("[DtsClientHeartBeatTimer]: connectServer error, server:" + server + ", clientConfig:" + this.clientContext.getClientConfig().toString(), e);
                }
            }
        }
        catch (Throwable e) {
            logger.error("[DtsClientHeartBeatTimer]: run error, clientConfig:" + this.clientContext.getClientConfig().toString(), e);
        }
    }
}

