/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.alarm;

import com.alibaba.dts.common.alarm.MessageSenderException;
import com.alibaba.dts.common.alarm.MessageSenderTypeEnum;
import com.alibaba.dts.common.httpclient.HttpClient;
import com.alibaba.dts.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MessageSenderUtil {
    private static final Logger log = LoggerFactory.getLogger(MessageSenderUtil.class);

    public static boolean sendMessage(MessageSenderTypeEnum sendType, String message, List<String> receivers) throws MessageSenderException {
        boolean result = false;
        if (CollectionUtils.isEmpty(receivers)) {
            throw new MessageSenderException("receivers is empty");
        }
        if (sendType == null) {
            throw new MessageSenderException("sendType is null");
        }
        if (StringUtils.isEmpty(message)) {
            throw new MessageSenderException("message is empty");
        }
        long currentTime = System.currentTimeMillis() / 1000L;
        JSONObject baseInfo = MessageSenderUtil.buildBaseInfo(message, currentTime);
        baseInfo.put("receivers", (Object)MessageSenderUtil.bulidReceiver(sendType.key, receivers));
        HttpClient httpClient = new HttpClient();
        String url = "http://roar.alibaba-inc.com/send-by-criteria.do?edition=2&timestamp=" + currentTime;
        try {
            String response = httpClient.invokePost(url, baseInfo.toJSONString());
            result = MessageSenderUtil.parseResponse(response);
        }
        catch (Throwable e) {
            log.error("[MessageSenderUtil] sendMessage error.", e);
            throw new MessageSenderException("sendMessage error", e);
        }
        return result;
    }

    private static boolean parseResponse(String response) {
        boolean result = false;
        try {
            JSONObject jsonObject;
            if (StringUtils.isNotBlank(response) && (jsonObject = JSON.parseObject((String)response)) != null && jsonObject.getBooleanValue("success")) {
                result = true;
            }
        }
        catch (Exception e) {
            log.error("[MessageSenderUtil] parseResponse error, response:" + response, (Throwable)e);
        }
        return result;
    }

    private static JSONArray bulidReceiver(String sendType, List<String> receivers) {
        JSONArray userObjects = new JSONArray();
        for (String receiver : receivers) {
            JSONObject userObj = new JSONObject();
            userObj.put("empId", (Object)receiver);
            userObj.put("method", (Object)sendType);
            userObj.put("callbackUrl", (Object)"");
            userObjects.add((Object)userObj);
        }
        return userObjects;
    }

    private static JSONObject buildBaseInfo(String message, long currentTime) {
        JSONObject baseInfo = new JSONObject();
        baseInfo.put("message", (Object)message);
        baseInfo.put("username", (Object)"dts");
        baseInfo.put("password", (Object)MessageSenderUtil.getMD5String("3y2#x.KkptY" + currentTime, "UTF-8"));
        baseInfo.put("charset", (Object)"UTF-8");
        return baseInfo;
    }

    static String getMD5String(String str, String charset) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(str.getBytes(charset));
            byte[] byteArray = messageDigest.digest();
            StringBuffer md5StrBuff = new StringBuffer();
            for (int i = 0; i < byteArray.length; ++i) {
                if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                    md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
                    continue;
                }
                md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
            }
            return md5StrBuff.toString().toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            return str;
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static void main(String[] args) {
        ArrayList<String> users = new ArrayList<String>();
        users.add("134778");
        System.out.println(MessageSenderUtil.sendMessage(MessageSenderTypeEnum.PHONE, "\u6d4b\u8bd5", users));
    }
}

