/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.httpclient;

import com.alibaba.dts.common.httpclient.HttpClientException;
import com.alibaba.dts.shade.org.apache.commons.lang.StringUtils;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    private static PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    private final CloseableHttpClient client;

    public HttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(30000).build();
        this.client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
    }

    public String invokePost(String url, String jsonInput) throws HttpClientException {
        if (StringUtils.isEmpty(url)) {
            throw new HttpClientException("url is blank");
        }
        String response = null;
        HttpPost post = new HttpPost(url);
        try {
            StringEntity entity = new StringEntity(jsonInput, "UTF8");
            entity.setContentEncoding("UTF8");
            entity.setContentType("application/json");
            post.setEntity((HttpEntity)entity);
            CloseableHttpResponse result = this.client.execute((HttpUriRequest)post);
            StatusLine status = result.getStatusLine();
            response = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF8");
        }
        catch (ClientProtocolException e) {
            post.abort();
            throw new HttpClientException(500, "failure", "Unsupported client protocol: " + url);
        }
        catch (IOException e) {
            post.abort();
            throw new HttpClientException(500, "failure", "Server URL is not reachable: " + url);
        }
        catch (Throwable t) {
            throw new HttpClientException(500, "failure", "Http client exception: " + t.getMessage());
        }
        return response;
    }

    static {
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(100);
    }
}

