/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.metrics;

import com.alibaba.dts.common.util.RemotingUtil;
import com.alibaba.fastjson.JSON;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArmsReporter
extends ScheduledReporter {
    private static final Map<String, Log> LOGGER_CACHE = new ConcurrentHashMap<String, Log>();

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private ArmsReporter(MetricRegistry registry, Configuration conf, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        super(registry, "Arms-reporter", filter, rateUnit, durationUnit);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.reportGauge(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.reportCounter(entry.getKey(), (Counter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            this.reportHistogram(entry.getKey(), (Histogram)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.reportMeter(entry.getKey(), (Meter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.reportTimer(entry.getKey(), (Timer)entry.getValue());
        }
    }

    private void reportGauge(String key, Gauge gauge) {
        String[] tokens = key.split("#");
        String metricsName = tokens[0];
        List list = (List)gauge.getValue();
        for (Map map : list) {
            map.put("metric", metricsName);
            map.put("ip", RemotingUtil.getLocalAddress());
            this.printLog(metricsName, map);
        }
    }

    private void printLog(String metric, Map<String, Object> data) {
        String json = JSON.toJSONString(data);
        Log log = LOGGER_CACHE.get(metric);
        if (log == null) {
            log = LogFactory.getLog((String)("metrics_" + metric));
            LOGGER_CACHE.put(metric, log);
        }
        log.info((Object)json);
    }

    private void reportCounter(String key, Counter counter) {
    }

    private void reportHistogram(String key, Histogram histograms) {
    }

    private void reportMeter(String key, Meter meter) {
    }

    private void reportTimer(String key, Timer timer) {
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Configuration conf;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder setConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public ArmsReporter build() {
            return new ArmsReporter(this.registry, this.conf, this.rateUnit, this.durationUnit, this.filter);
        }
    }
}

