/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.metrics;

import com.alibaba.dts.common.domain.DtsConfiguration;
import com.alibaba.dts.common.metrics.ArmsReporter;
import com.alibaba.dts.shade.com.google.common.base.Throwables;
import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reporter;
import com.codahale.metrics.ganglia.GangliaReporter;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.File;
import java.io.IOException;

public class MetricsReporterFactory {
    public static Reporter createReporter(MetricRegistry registry, DtsConfiguration conf) {
        String metricsType = conf.getString("metrics.report.type", "jmx").toLowerCase();
        if (metricsType.equalsIgnoreCase("csv")) {
            return CsvReporter.forRegistry((MetricRegistry)registry).build(new File(conf.getString("metrics.report.csv.dir")));
        }
        if (metricsType.equalsIgnoreCase("ganglia")) {
            String group = conf.getString("metrics.report.ganglia.group");
            int port = conf.getInt("metrics.report.ganglia.port", 8649);
            GMetric.UDPAddressingMode mode = GMetric.UDPAddressingMode.valueOf((String)conf.getString("metrics.report.ganglia.mode", "MULTICAST").toUpperCase());
            int ttl = conf.getInt("metrics.report.ganglia.ttl", 1);
            try {
                GMetric gmetric = new GMetric(group, port, mode, ttl);
                return GangliaReporter.forRegistry((MetricRegistry)registry).build(gmetric);
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
        if (metricsType.equalsIgnoreCase("jmx")) {
            return JmxReporter.forRegistry((MetricRegistry)registry).build();
        }
        if (metricsType.equalsIgnoreCase("arms")) {
            return ArmsReporter.forRegistry(registry).build();
        }
        return ConsoleReporter.forRegistry((MetricRegistry)registry).build();
    }
}

