/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.remoting.netty;

import com.alibaba.dts.common.helper.RemotingHelper;
import com.alibaba.dts.common.remoting.protocol.RemotingCommand;
import com.alibaba.dts.common.util.RemotingUtil;
import com.alibaba.dts.shade.io.netty.buffer.ByteBuf;
import com.alibaba.dts.shade.io.netty.channel.ChannelHandlerContext;
import com.alibaba.dts.shade.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NettyDecoder
extends LengthFieldBasedFrameDecoder {
    private static final Log log = LogFactory.getLog(NettyDecoder.class);
    private static final int FRAME_MAX_LENGTH = Integer.MAX_VALUE;

    public NettyDecoder() {
        super(Integer.MAX_VALUE, 0, 4, 0, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf frame = null;
        try {
            frame = (ByteBuf)super.decode(ctx, in);
            if (null == frame) {
                Object var4_4 = null;
                return var4_4;
            }
            ByteBuffer byteBuffer = frame.nioBuffer();
            RemotingCommand remotingCommand = RemotingCommand.decode(byteBuffer);
            return remotingCommand;
        }
        catch (Throwable e) {
            log.error((Object)("decode exception, " + RemotingHelper.parseChannelRemoteAddr(ctx.channel())), e);
            RemotingUtil.closeChannel(ctx.channel());
        }
        finally {
            if (null != frame) {
                frame.release();
            }
        }
        return null;
    }
}

