/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.service;

import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.KeyValuePair;
import com.alibaba.dts.common.domain.ServerList;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.service.MySSLProtocolSocketFactory;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.dts.shade.org.apache.commons.HttpClient;
import com.alibaba.dts.shade.org.apache.commons.SimpleHttpConnectionManager;
import com.alibaba.dts.shade.org.apache.commons.methods.PostMethod;
import com.alibaba.dts.shade.org.apache.commons.protocol.Protocol;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpService
implements Constants {
    public static final String DOMAIN_NAME_DATA_ID = "com.alibaba.dts.common.domainName";
    private static final Log logger = LogFactory.getLog(HttpService.class);
    private static final int timeout = 10000;
    private static final int httpConnectionFactoryTimeout = 10000;
    private static final int connectionTimeout = 10000;
    public static final String DEFAULT_CHARSET = "UTF-8";
    private boolean isUseHttps = false;
    private String httpHead = "http://";

    public boolean isUseHttps() {
        return this.isUseHttps;
    }

    public void setUseHttps(boolean isUseHttps) {
        this.isUseHttps = isUseHttps;
        this.httpHead = isUseHttps ? "https://" : "http://";
    }

    public String acquireZkHosts(String domainName) {
        String url = this.httpHead + domainName + "/dts-console/apiManager.do?action=ApiAction&event_submit_do_acquire_zkHosts=1";
        String result = null;
        try {
            result = this.go(url);
        }
        catch (Throwable e) {
            logger.warn((Object)("[HttpService]: acquireZkHosts error, url:" + url), e);
        }
        return StringUtil.trim(result);
    }

    public List<String> acquireServers(String domainName, long serverClusterId, long serverGroupId) {
        String url = this.httpHead + domainName + "/dts-console/apiManager.do?action=ApiAction&event_submit_do_acquire_servers=1&clusterId=" + serverClusterId + "&serverGroupId=" + serverGroupId;
        String result = null;
        try {
            result = this.go(url);
        }
        catch (Throwable e) {
            logger.warn((Object)("[HttpService]: acquireServers error, url:" + url), e);
        }
        ServerList serverList = null;
        try {
            serverList = ServerList.newInstance(result);
        }
        catch (Throwable e) {
            logger.warn((Object)("[HttpService]: ServerList.newInstance error, url:" + url + ", result:" + result), e);
        }
        if (null == serverList) {
            logger.warn((Object)("[HttpService]: ServerList.newInstance failed, url:" + url + ", result:" + result));
            return null;
        }
        return serverList.getServers();
    }

    public List<String> acquireServersByGroupId(String domainName, long serverClusterId, long serverGroupId, long groupid) {
        String url = this.httpHead + domainName + "/dts-console/apiManager.do?action=ApiAction&event_submit_do_acquire_servers=1&clusterId=" + serverClusterId + "&serverGroupId=" + serverGroupId + "&groupId=" + groupid;
        String result = null;
        try {
            result = this.go(url);
        }
        catch (Throwable e) {
            logger.warn((Object)("[HttpService]: acquireServers error, url:" + url), e);
        }
        ServerList serverList = null;
        try {
            serverList = ServerList.newInstance(result);
        }
        catch (Throwable e) {
            logger.warn((Object)("[HttpService]: ServerList.newInstance error, url:" + url + ", result:" + result), e);
        }
        if (null == serverList) {
            logger.warn((Object)("[HttpService]: ServerList.newInstance failed, url:" + url + ", result:" + result));
            return null;
        }
        return serverList.getServers();
    }

    public Result<String> securityCheck(String domainName, String accessKey, String groupid, String signdata, String sign) {
        String url = this.httpHead + domainName + "/dts-console/apiManager.do?action=ApiAction&event_submit_do_security_check=1&accessKey=" + accessKey + "&groupid=" + groupid + "&signdata=" + signdata + "&sign=" + sign;
        Result<String> result = new Result<String>();
        String goresult = null;
        try {
            goresult = this.go(url);
        }
        catch (Throwable e) {
            logger.warn((Object)("[HttpService]: acquireServers error, url:" + url), e);
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)goresult);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData((String)jsonResult.get((Object)"userGroupId"));
            }
        }
        catch (Throwable e) {
            logger.warn((Object)("[HttpService]: securityCheck error, accessKey:" + accessKey + ", signname:" + groupid), e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    public Result<String> acquireGroupID(String domainName, String serviceGroup, String regionName) {
        String url = this.httpHead + domainName + "/dts-console/apiManager.do?action=JobAction&event_submit_do_get_dtsGroupId=1&edasGroupId=" + serviceGroup + "&clusterCode=" + regionName;
        Result<String> result = new Result<String>();
        String goresult = null;
        try {
            goresult = this.go(url);
        }
        catch (Throwable e) {
            logger.warn((Object)("[HttpService]: acquireServers error, url:" + url), e);
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)goresult);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation("domainName:" + domainName + ",serviceGroup:" + serviceGroup + ",regionName:" + regionName + ",error:" + (String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData((String)jsonResult.get((Object)"groupId"));
            }
        }
        catch (Throwable e) {
            logger.warn((Object)("[HttpService]: acquireGroupID error, serviceGroup:" + serviceGroup + ", regionName:" + regionName), e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
            result.getResultCode().setInformation("domainName:" + domainName + ",serviceGroup:" + serviceGroup + ",regionName:" + regionName);
        }
        return result;
    }

    private String go(String url) {
        KeyValuePair<Integer, String> pair = this.isUseHttps() ? this.requestHttps(url) : this.request(url);
        try {
            return pair.getValue();
        }
        catch (Throwable e) {
            logger.warn((Object)("[HttpService]: go getResponseBodyAsString error, url:" + url), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValuePair<Integer, String> request(String url) {
        HttpClient client = new HttpClient(new SimpleHttpConnectionManager(true));
        client.setTimeout(10000);
        client.setConnectionTimeout(10000);
        client.setHttpConnectionFactoryTimeout(10000L);
        PostMethod post = new PostMethod(url);
        post.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        int resultCode = 0;
        String response = null;
        try {
            resultCode = client.executeMethod(post);
            response = post.getResponseBodyAsString();
        }
        catch (Throwable e) {
            logger.warn((Object)("[HttpService]: executeMethod error, post:" + post), e);
        }
        finally {
            post.releaseConnection();
        }
        return new KeyValuePair<Integer, String>(resultCode, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValuePair<Integer, String> requestHttps(String url) {
        HttpClient client = new HttpClient(new SimpleHttpConnectionManager(true));
        Protocol myhttps = new Protocol("https", new MySSLProtocolSocketFactory(), 443);
        Protocol.registerProtocol("https", myhttps);
        client.setTimeout(10000);
        client.setConnectionTimeout(10000);
        client.setHttpConnectionFactoryTimeout(10000L);
        PostMethod post = new PostMethod(url);
        post.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        int resultCode = 0;
        String response = null;
        try {
            resultCode = client.executeMethod(post);
            response = post.getResponseBodyAsString();
        }
        catch (Throwable e) {
            logger.warn((Object)("[HttpService]: executeMethod error, post:" + post), e);
        }
        finally {
            post.releaseConnection();
        }
        return new KeyValuePair<Integer, String>(resultCode, response);
    }

    public List<String> acquireSystemServers(String domainName, long serverClusterId, long serverGroupId) {
        String url = this.httpHead + domainName + "/dts-console/apiManager.do?action=ApiAction&event_submit_do_acquire_system_servers=1&clusterId=" + serverClusterId + "&serverGroupId=" + serverGroupId;
        String result = null;
        try {
            result = this.go(url);
        }
        catch (Throwable e) {
            logger.warn((Object)("[HttpService]: acquireServers error, url:" + url), e);
        }
        ServerList serverList = null;
        try {
            serverList = ServerList.newInstance(result);
        }
        catch (Throwable e) {
            logger.warn((Object)("[HttpService]: ServerList.newInstance error, url:" + url + ", result:" + result), e);
        }
        if (null == serverList) {
            logger.warn((Object)("[HttpService]: ServerList.newInstance failed, url:" + url + ", result:" + result));
            return null;
        }
        return serverList.getServers();
    }
}

