/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util;

import com.alibaba.dts.common.domain.store.ServerJobInstanceMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class LoggerUtil {
    public static String displayJobInstanceId(Set<ServerJobInstanceMapping.JobInstanceKey> keySet) {
        if (null == keySet || keySet.size() <= 0) {
            return null;
        }
        StringBuilder keys = new StringBuilder();
        ArrayList<ServerJobInstanceMapping.JobInstanceKey> keyList = new ArrayList<ServerJobInstanceMapping.JobInstanceKey>(keySet);
        for (ServerJobInstanceMapping.JobInstanceKey key : keyList) {
            keys.append("," + key.getJobInstanceId());
        }
        return keys.toString();
    }

    public static String displayTable(String key, List<String> header, Map<String, List<String>> body) {
        StringBuilder table = new StringBuilder();
        List<AtomicInteger> maxLengthList = LoggerUtil.getMaxLengthList(key, header, body);
        ArrayList<String> head = new ArrayList<String>();
        for (int i = 0; i < header.size(); ++i) {
            head.add("-");
        }
        table.append(LoggerUtil.displayLine(false, "-", head, maxLengthList));
        table.append(LoggerUtil.displayLine(true, key, header, maxLengthList));
        ArrayList<String> interlaced = new ArrayList<String>();
        for (int i = 0; i < header.size(); ++i) {
            interlaced.add("-");
        }
        table.append(LoggerUtil.displayLine(false, "-", interlaced, maxLengthList));
        for (Map.Entry<String, List<String>> entry : body.entrySet()) {
            String topic = entry.getKey();
            List<String> itemList = entry.getValue();
            table.append(LoggerUtil.displayLine(true, topic, itemList, maxLengthList));
        }
        ArrayList<String> tail = new ArrayList<String>();
        for (int i = 0; i < header.size(); ++i) {
            tail.add("-");
        }
        table.append(LoggerUtil.displayLine(false, "-", tail, maxLengthList));
        return table.toString();
    }

    private static String displayLine(boolean isLine, String key, List<String> itemList, List<AtomicInteger> maxLengthList) {
        StringBuilder line = new StringBuilder();
        line.append((isLine ? " | " : " + ") + key + LoggerUtil.displayBlank(isLine, maxLengthList.get(0), key));
        for (int i = 0; i < itemList.size(); ++i) {
            line.append((isLine ? " | " : " + ") + itemList.get(i) + LoggerUtil.displayBlank(isLine, maxLengthList.get(i + 1), itemList.get(i)));
        }
        line.append((isLine ? " | " : " + ") + "\n");
        return line.toString();
    }

    private static String displayBlank(boolean isLine, AtomicInteger length, String item) {
        StringBuilder blank = new StringBuilder(isLine ? " " : "-");
        for (int i = 0; i < length.get() - item.length(); ++i) {
            blank.append(isLine ? " " : "-");
        }
        return blank.toString();
    }

    private static List<AtomicInteger> getMaxLengthList(String key, List<String> header, Map<String, List<String>> body) {
        ArrayList<AtomicInteger> maxLengthList = new ArrayList<AtomicInteger>();
        for (int i = 0; i < 1 + header.size(); ++i) {
            maxLengthList.add(new AtomicInteger(0));
        }
        LoggerUtil.refreshMaxLengthList(maxLengthList, key, header);
        for (Map.Entry<String, List<String>> entry : body.entrySet()) {
            String topic = entry.getKey();
            List<String> itemList = entry.getValue();
            LoggerUtil.refreshMaxLengthList(maxLengthList, topic, itemList);
        }
        return maxLengthList;
    }

    private static void refreshMaxLengthList(List<AtomicInteger> maxLengthList, String key, List<String> itemList) {
        for (int i = 0; i < maxLengthList.size(); ++i) {
            AtomicInteger length = maxLengthList.get(i);
            if (length.intValue() >= (0 == i ? key.length() : itemList.get(i - 1).length())) continue;
            length.set(0 == i ? key.length() : itemList.get(i - 1).length());
        }
    }
}

