/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util;

import com.alibaba.dts.common.constants.Constants;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeUtil
implements Constants {
    private static final Log logger = LogFactory.getLog(TimeUtil.class);
    private static final int START_WORK_TIME = 9;
    private static final int END_WORK_TIME = 18;

    public static boolean nowIsWorkDayTime(long timeInMillis) {
        return TimeUtil.nowIsWorkDay(timeInMillis) && TimeUtil.nowIsWorkTime(timeInMillis);
    }

    public static boolean nowIsWorkDay(long timeInMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        int dayOfWeek = calendar.get(7);
        return dayOfWeek != 7 && dayOfWeek != 1;
    }

    public static boolean nowIsWorkTime(long timeInMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        int hourOfDay = calendar.get(11);
        return hourOfDay >= 9 && hourOfDay < 18;
    }

    public static String date2SecondsString(Date date) {
        return TimeUtil.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(Date date, String format) {
        SimpleDateFormat formater = new SimpleDateFormat(format);
        return formater.format(date);
    }

    public static Date increaseDate(Date date, long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, (int)(time / 1000L));
        return calendar.getTime();
    }

    public static Date string2Date(String date, String format) {
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            return formater.parse(date);
        }
        catch (Throwable e) {
            logger.error((Object)("[TimeUtil]: string2Date error, date:" + date + ", format:" + format), e);
            return null;
        }
    }

    public static Date increaseDate(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }
}

