/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.common.fulllinkstresstesting;

import com.alibaba.dts.shade.com.taobao.common.fulllinkstresstesting.RatioMember;
import com.alibaba.dts.shade.com.taobao.diamond.client.Diamond;
import com.alibaba.dts.shade.com.taobao.diamond.manager.ManagerListener;
import com.alibaba.dts.shade.com.taobao.diamond.manager.ManagerListenerAdapter;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.org.apache.commons.lang.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RationControl {
    private static ManagerListener listener = new ManagerListenerAdapter(){

        @Override
        public void receiveConfigInfo(String conf) {
            if (conf == null || StringUtils.isBlank(conf)) {
                EagleEye.selfLog("[StressTest] ratio control is blank!");
                return;
            }
            try {
                String[] keyValues;
                HashMap<String, RatioMember> map = new HashMap<String, RatioMember>();
                for (String keyValue : keyValues = conf.trim().split(";")) {
                    String[] pair = keyValue.split(":");
                    if (pair.length != 2) continue;
                    try {
                        String key = pair[0].trim();
                        int value = Integer.parseInt(pair[1].trim());
                        map.put(key, new RatioMember(key, value));
                    }
                    catch (Exception e) {
                        EagleEye.selfLog("[StressTest] ratio control error:" + keyValue, e);
                    }
                }
                EagleEye.selfLog("[StressTest] ratio control parse:" + map);
                RATIO_CONTROL = map;
            }
            catch (Exception e) {
                EagleEye.selfLog("[StressTest] ratio control error!", e);
            }
        }
    };
    public static volatile Map<String, RatioMember> RATIO_CONTROL = RationControl.initValue();
    public static final String DATA_ID = "ratio-control";
    public static final String GROUP = "fulllinkstresstesting";

    private static Map<String, RatioMember> initValue() {
        String conf = null;
        try {
            conf = Diamond.getConfig(DATA_ID, GROUP, 5000L);
            Diamond.addListener(DATA_ID, GROUP, listener);
        }
        catch (IOException e) {
            EagleEye.selfLog("[StressTest] ratio control error!", e);
            return new HashMap<String, RatioMember>();
        }
        if (conf == null || StringUtils.isBlank(conf)) {
            EagleEye.selfLog("[StressTest] ratio control is blank!");
            return new HashMap<String, RatioMember>();
        }
        try {
            String[] keyValues;
            HashMap<String, RatioMember> map = new HashMap<String, RatioMember>();
            for (String keyValue : keyValues = conf.trim().split(";")) {
                String[] pair = keyValue.split(":");
                if (pair.length != 2) continue;
                try {
                    String key = pair[0].trim();
                    int value = Integer.parseInt(pair[1].trim());
                    map.put(key, new RatioMember(key, value));
                }
                catch (Exception e) {
                    EagleEye.selfLog("[StressTest] ratio control error:" + keyValue, e);
                }
            }
            EagleEye.selfLog("[StressTest] ratio control parse:" + map);
            return map;
        }
        catch (Exception e) {
            EagleEye.selfLog("[StressTest] ratio control error!", e);
            return new HashMap<String, RatioMember>();
        }
    }

    public static boolean missRation(String key) {
        if (RATIO_CONTROL == null) {
            return false;
        }
        RatioMember value = RATIO_CONTROL.get(key);
        if (value == null) {
            return false;
        }
        int random = value.nextValue();
        return random >= value.getRatio();
    }
}

