/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.diamond.mockserver;

import com.alibaba.dts.shade.com.taobao.diamond.client.BatchHttpResult;
import com.alibaba.dts.shade.com.taobao.diamond.client.Diamond;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.DiamondEnv;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.DiamondEnvRepo;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.DiamondUnitSite;
import com.alibaba.dts.shade.com.taobao.diamond.common.GroupKey;
import com.alibaba.dts.shade.com.taobao.diamond.domain.ConfigInfoEx;
import com.alibaba.dts.shade.com.taobao.diamond.manager.ManagerListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class MockServer {
    public static ConcurrentHashMap<String, Map<String, String>> serverCacheMap = new ConcurrentHashMap();
    private static volatile boolean testMode = false;

    public static void setUpMockServer() {
        testMode = true;
    }

    public static void tearDownMockServer() {
        testMode = false;
    }

    public static boolean isTestMode() {
        return testMode;
    }

    public static String getConfigInfo(String dataId, String group) {
        return MockServer.getConfigInfo(dataId, group, null);
    }

    public static List<ConfigInfoEx> batchQuery(List<String> dataIds, String group) {
        return MockServer.batchQuery(dataIds, group, null);
    }

    public static void setConfigInfos(Map<String, String> configInfos) {
        MockServer.setConfigInfos(configInfos, null);
    }

    public static void setConfigInfo(String dataId, String group, String configInfo) {
        MockServer.setConfigInfo(dataId, group, configInfo, null);
    }

    public static void setConfigInfo(String dataId, String configInfo) {
        MockServer.setConfigInfo(dataId, null, configInfo, null);
    }

    public static void removeConfigInfo(String dataId, String group) {
        MockServer.removeConfigInfo(dataId, group, null);
    }

    public static String getConfigInfo(String dataId, String group, DiamondEnv env) {
        Map<String, String> serverCache;
        if (null == group) {
            group = "DEFAULT_GROUP";
        }
        if (env == null) {
            env = DiamondEnvRepo.defaultEnv;
        }
        return null != (serverCache = serverCacheMap.get(env.getServerMgr().toString())) ? serverCache.get(GroupKey.getKey(dataId, group)) : null;
    }

    public static List<ConfigInfoEx> batchQuery(List<String> dataIds, String group, DiamondEnv env) {
        if (null == group) {
            group = "DEFAULT_GROUP";
        }
        if (env == null) {
            env = DiamondEnvRepo.defaultEnv;
        }
        ArrayList<ConfigInfoEx> configInfoExList = new ArrayList<ConfigInfoEx>();
        for (String dataId : dataIds) {
            ConfigInfoEx configInfoEx = new ConfigInfoEx();
            configInfoEx.setDataId(dataId);
            configInfoEx.setGroup(group);
            String config = MockServer.getConfigInfo(dataId, group, env);
            if (config == null) {
                configInfoEx.setStatus(2);
                configInfoEx.setMessage("query data does not exist");
            } else {
                configInfoEx.setContent(config);
                configInfoEx.setStatus(1);
                configInfoEx.setMessage("query success");
            }
            configInfoExList.add(configInfoEx);
        }
        return configInfoExList;
    }

    public static void setConfigInfos(Map<String, String> configInfos, DiamondEnv env) {
        if (env == null) {
            env = DiamondEnvRepo.defaultEnv;
        }
        if (null != configInfos) {
            for (Map.Entry<String, String> entry : configInfos.entrySet()) {
                MockServer.setConfigInfo(entry.getKey(), entry.getValue(), env);
            }
        }
    }

    public static void setConfigInfo(String dataId, String configInfo, DiamondEnv env) {
        MockServer.setConfigInfo(dataId, null, configInfo, env);
    }

    public static void setConfigInfo(String dataId, String group, String configInfo, DiamondEnv env) {
        if (null == group) {
            group = "DEFAULT_GROUP";
        }
        if (env == null) {
            env = DiamondEnvRepo.defaultEnv;
        }
        ConcurrentHashMap tmp = new ConcurrentHashMap();
        Map<String, String> serverCache = serverCacheMap.putIfAbsent(env.getServerMgr().toString(), tmp);
        serverCache = serverCache == null ? tmp : serverCache;
        serverCache.put(GroupKey.getKey(dataId, group), configInfo);
    }

    public static void removeConfigInfo(String dataId, String group, DiamondEnv env) {
        Map<String, String> serverCache;
        if (null == group) {
            group = "DEFAULT_GROUP";
        }
        if (env == null) {
            env = DiamondEnvRepo.defaultEnv;
        }
        if ((serverCache = serverCacheMap.get(env.getServerMgr().toString())) == null) {
            return;
        }
        serverCache.remove(GroupKey.getKey(dataId, group));
    }

    public static void main(String[] args) throws Exception {
        MockServer.setUpMockServer();
        String dataId = "testmockserver";
        String group = "group";
        String newConfig = new Date().toString();
        MockServer.setConfigInfo(dataId, group, newConfig, null);
        String mockConfig = Diamond.getConfig(dataId, group, 10L);
        System.out.println("test-mock-getconfig : " + mockConfig.equals(newConfig));
        MockserverListener listener = new MockserverListener();
        Diamond.addListener(dataId, group, listener);
        while (!newConfig.equals(listener.config)) {
            System.out.println("no receive new config");
            Thread.sleep(1000L);
        }
        System.out.println("test-mock-listener : " + newConfig.equals(listener.config));
        Diamond.remove(dataId, group);
        mockConfig = Diamond.getConfig(dataId, group, 10L);
        System.out.println(mockConfig == null);
        String dataIdbase = "mockserver.dataid";
        ArrayList<String> dataIds = new ArrayList<String>();
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < 50; ++i) {
            DiamondEnv env = DiamondUnitSite.getDiamondUnitEnv("center");
            env.publishSingle(dataIdbase + i, null, "mockserver.content" + i);
            dataIds.add(dataIdbase + i);
        }
        MockServer.setConfigInfos(params);
        DiamondEnv env = DiamondUnitSite.getDiamondUnitEnv("center");
        BatchHttpResult<ConfigInfoEx> response = env.batchQuery(dataIds, null, 10L);
        System.out.println(response.isSuccess());
        System.out.println(response.getResult().size());
        for (ConfigInfoEx configInfoEx : response.getResult()) {
            System.out.println(configInfoEx);
        }
    }

    static class MockserverListener
    implements ManagerListener {
        String config;

        MockserverListener() {
        }

        @Override
        public Executor getExecutor() {
            return null;
        }

        @Override
        public void receiveConfigInfo(String configInfo) {
            this.config = configInfo;
        }
    }
}

