/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.BaseContext;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeCoreUtils;
import com.alibaba.dts.shade.com.taobao.eagleeye.TraceLogger;
import java.util.Collection;
import java.util.Iterator;

public final class TraceEntry {
    private final TraceLogger traceLogger;
    private final BaseContext bizContext;
    private StringBuilder bizAppender = null;

    TraceEntry(TraceLogger traceLogger, String traceId, String rpcId, int logType, String bizKey, String queryKey) {
        this.traceLogger = traceLogger;
        BaseContext biz = new BaseContext(traceId, rpcId);
        biz.logType = logType;
        biz.serviceName = EagleEyeCoreUtils.checkNotNullEmpty(bizKey, "bizKey");
        biz.methodName = EagleEyeCoreUtils.checkNotNullEmpty(queryKey, "queryKey");
        biz.logTime = -1L;
        this.bizContext = biz;
    }

    BaseContext getBizContext() {
        return this.bizContext;
    }

    public TraceEntry timestamp(long timestamp) {
        this.bizContext.logTime = timestamp;
        return this;
    }

    public TraceEntry traceBiz(int bizType, String bizValue) {
        if (bizValue == null || bizValue.length() == 0) {
            return this;
        }
        StringBuilder bizAppender = this.bizAppender;
        if (bizAppender == null) {
            this.bizAppender = bizAppender = new StringBuilder(32);
        } else {
            bizAppender.append('&');
        }
        bizAppender.append(bizType).append('=').append(bizValue);
        return this;
    }

    public TraceEntry traceBiz(int bizType, Collection<String> bizValues) {
        if (bizValues == null || bizValues.size() == 0) {
            return this;
        }
        StringBuilder bizAppender = this.bizAppender;
        if (bizAppender == null) {
            this.bizAppender = bizAppender = new StringBuilder(128);
        } else {
            bizAppender.append('&');
        }
        Iterator<String> it = bizValues.iterator();
        bizAppender.append(bizType).append('=').append(it.next());
        while (it.hasNext()) {
            bizAppender.append('&').append(bizType).append('=').append(it.next());
        }
        return this;
    }

    public void logLine(String content) {
        this.bizContext.callBackMsg = content;
        if (this.bizAppender != null) {
            this.bizContext.traceName = this.bizAppender.toString();
        }
        this.traceLogger.logLine(this.bizContext);
    }

    public void escapeAndLogLine(String content) {
        this.bizContext.rpcType = 1;
        this.logLine(content);
    }
}

