/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.AsyncAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.BaseContext;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeCoreUtils;
import com.alibaba.dts.shade.com.taobao.eagleeye.RpcContext_inner;
import com.alibaba.dts.shade.com.taobao.eagleeye.TraceEntry;

public final class TraceLogger {
    private final String loggerName;
    private final AsyncAppender appender;

    TraceLogger(String loggerName, AsyncAppender appender) {
        this.loggerName = loggerName;
        this.appender = appender;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    AsyncAppender getAppender() {
        return this.appender;
    }

    public TraceEntry trace(String bizKey, String queryKey) {
        return this.traceWithContext(EagleEye.createContextIfNotExists(false), bizKey, queryKey);
    }

    public TraceEntry traceWithContext(RpcContext_inner ctx, String bizKey, String queryKey) {
        int logType;
        String rpcId;
        String traceId;
        if (ctx != null) {
            traceId = ctx.getTraceId();
            rpcId = ctx.getRpcId();
            logType = EagleEyeCoreUtils.isClusterTestEnabled(ctx) ? 1 : 0;
        } else {
            traceId = "";
            rpcId = "";
            logType = 0;
        }
        return this.traceWithContext(traceId, rpcId, logType, bizKey, queryKey);
    }

    public TraceEntry traceWithContext(String traceId, String rpcId, int logType, String bizKey, String queryKey) {
        return new TraceEntry(this, traceId, rpcId, logType, bizKey, queryKey);
    }

    public void logLine(String bizKey, String queryKey, String logContent) {
        this.logLineWithContext(EagleEye.createContextIfNotExists(false), bizKey, queryKey, logContent);
    }

    void logLineWithContext(RpcContext_inner ctx, String bizKey, String queryKey, String logContent) {
        BaseContext biz = new BaseContext(ctx.getTraceId(), ctx.getRpcId());
        biz.logType = EagleEyeCoreUtils.isClusterTestEnabled(ctx) ? 1 : 0;
        biz.serviceName = EagleEyeCoreUtils.checkNotNullEmpty(bizKey, "bizKey");
        biz.methodName = EagleEyeCoreUtils.checkNotNullEmpty(queryKey, "queryKey");
        biz.callBackMsg = logContent;
        this.logLine(biz);
    }

    void logLine(BaseContext biz) {
        if (!EagleEye.isBizOff()) {
            String bizKey = biz.serviceName;
            String queryKey = biz.methodName;
            if (bizKey == null || bizKey.length() >= 4096 || queryKey == null || queryKey.length() >= 4096) {
                EagleEye.selfLog("[WARN] TraceLogger[" + this.loggerName + "] not logged " + "for bizKey or query key is invalid");
                return;
            }
            String logContent = biz.callBackMsg;
            if (logContent == null) {
                EagleEye.selfLog("[WARN] TraceLogger[" + this.loggerName + "] not logged " + "for logContent is null, bizKey=" + bizKey + ", queryKey=" + queryKey);
                return;
            }
            if (biz.logTime <= 0L) {
                biz.logTime = System.currentTimeMillis();
            }
            if (logContent.length() > 4096) {
                EagleEye.selfLog("[WARN] TraceLogger[" + this.loggerName + "] logContent is too long, len=" + logContent.length() + ", bizKey=" + bizKey + ", queryKey=" + queryKey);
                this.appender.append(biz);
                this.appender.flushAndWait();
                return;
            }
            this.appender.append(biz);
        }
    }
}

