/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye.json;

import com.alibaba.dts.shade.com.taobao.eagleeye.json.DefaultJSONParser;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.Feature;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSON;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONException;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONLexer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONScanner;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.ObjectDeserializer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.TypeUtils;
import java.lang.reflect.Type;

abstract class AbstractDateDeserializer
implements ObjectDeserializer {
    AbstractDateDeserializer() {
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Object val;
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 2) {
            val = lexer.longValue();
            lexer.nextToken(16);
        } else if (lexer.token() == 4) {
            String strVal = lexer.stringVal();
            val = strVal;
            lexer.nextToken(16);
            if (lexer.isEnabled(Feature.AllowISO8601DateFormat)) {
                JSONScanner iso8601Lexer = new JSONScanner(strVal);
                if (iso8601Lexer.scanISO8601DateIfMatch()) {
                    val = iso8601Lexer.getCalendar().getTime();
                }
                iso8601Lexer.close();
            }
        } else if (lexer.token() == 8) {
            lexer.nextToken();
            val = null;
        } else if (lexer.token() == 12) {
            lexer.nextToken();
            if (lexer.token() == 4) {
                String key = lexer.stringVal();
                if (JSON.DEFAULT_TYPE_KEY.equals(key)) {
                    lexer.nextToken();
                    parser.accept(17);
                    String typeName = lexer.stringVal();
                    Class<?> type = TypeUtils.loadClass(typeName);
                    if (type != null) {
                        clazz = type;
                    }
                    parser.accept(4);
                    parser.accept(16);
                }
            } else {
                throw new JSONException("syntax error");
            }
            lexer.nextTokenWithColon(2);
            if (lexer.token() != 2) {
                throw new JSONException("syntax error : " + lexer.tokenName());
            }
            long timeMillis = lexer.longValue();
            lexer.nextToken();
            val = timeMillis;
            parser.accept(13);
        } else if (parser.getResolveStatus() == 2) {
            parser.setResolveStatus(0);
            parser.accept(16);
            if (lexer.token() == 4) {
                if (!"val".equals(lexer.stringVal())) {
                    throw new JSONException("syntax error");
                }
            } else {
                throw new JSONException("syntax error");
            }
            lexer.nextToken();
            parser.accept(17);
            val = parser.parse();
            parser.accept(13);
        } else {
            val = parser.parse();
        }
        return this.cast(parser, clazz, fieldName, val);
    }

    protected abstract <T> T cast(DefaultJSONParser var1, Type var2, Object var3, Object var4);
}

