/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye.json;

import com.alibaba.dts.shade.com.taobao.eagleeye.json.DefaultJSONParser;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONException;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONSerializer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.ObjectDeserializer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.ObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;

class InetAddressCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static InetAddressCodec instance = new InetAddressCodec();

    InetAddressCodec() {
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        if (object == null) {
            serializer.writeNull();
            return;
        }
        InetAddress address = (InetAddress)object;
        serializer.write(address.getHostAddress());
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        String host = (String)parser.parse();
        if (host == null) {
            return null;
        }
        if (host.length() == 0) {
            return null;
        }
        try {
            return (T)InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new JSONException("deserialize error", e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

