/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye.json;

import com.alibaba.dts.shade.com.taobao.eagleeye.json.DefaultJSONParser;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSON;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONException;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONLexer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONSerializer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.ObjectDeserializer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.ObjectSerializer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.SerializeWriter;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.SerializerFeature;
import java.awt.Rectangle;
import java.io.IOException;
import java.lang.reflect.Type;

class RectangleCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final RectangleCodec instance = new RectangleCodec();

    RectangleCodec() {
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        Rectangle rectangle = (Rectangle)object;
        if (rectangle == null) {
            out.writeNull();
            return;
        }
        int sep = 123;
        if (out.isEnabled(SerializerFeature.WriteClassName)) {
            out.write('{');
            out.writeFieldName(JSON.DEFAULT_TYPE_KEY);
            out.writeString(Rectangle.class.getName());
            sep = 44;
        }
        out.writeFieldValue((char)sep, "x", rectangle.getX());
        out.writeFieldValue(',', "y", rectangle.getY());
        out.writeFieldValue(',', "width", rectangle.getWidth());
        out.writeFieldValue(',', "height", rectangle.getHeight());
        out.write('}');
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 8) {
            lexer.nextToken();
            return null;
        }
        if (lexer.token() != 12 && lexer.token() != 16) {
            throw new JSONException("syntax error");
        }
        lexer.nextToken();
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        while (true) {
            if (lexer.token() == 13) break;
            if (lexer.token() != 4) {
                throw new JSONException("syntax error");
            }
            String key = lexer.stringVal();
            lexer.nextTokenWithColon(2);
            if (lexer.token() != 2) {
                throw new JSONException("syntax error");
            }
            int val = lexer.intValue();
            lexer.nextToken();
            if (key.equalsIgnoreCase("x")) {
                x = val;
            } else if (key.equalsIgnoreCase("y")) {
                y = val;
            } else if (key.equalsIgnoreCase("width")) {
                width = val;
            } else if (key.equalsIgnoreCase("height")) {
                height = val;
            } else {
                throw new JSONException("syntax error, " + key);
            }
            if (lexer.token() != 16) continue;
            lexer.nextToken(4);
        }
        lexer.nextToken();
        return (T)new Rectangle(x, y, width, height);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

