/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command;

import com.alibaba.dts.shade.org.h2.command.CommandInterface;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.expression.ParameterInterface;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.message.Trace;
import com.alibaba.dts.shade.org.h2.result.ResultInterface;
import com.alibaba.dts.shade.org.h2.util.MathUtils;
import java.util.ArrayList;

public abstract class Command
implements CommandInterface {
    protected final Session session;
    protected long startTime;
    private final Trace trace;
    private volatile boolean cancel;
    private final String sql;
    private boolean canReuse;

    Command(Session session, String sql) {
        this.session = session;
        this.sql = sql;
        this.trace = session.getDatabase().getTrace(0);
    }

    public abstract boolean isTransactional();

    @Override
    public abstract boolean isQuery();

    @Override
    public abstract ArrayList<? extends ParameterInterface> getParameters();

    public abstract boolean isReadOnly();

    public abstract ResultInterface queryMeta();

    public int update() {
        throw DbException.get(90001);
    }

    public ResultInterface query(int maxrows) {
        throw DbException.get(90002);
    }

    @Override
    public final ResultInterface getMetaData() {
        return this.queryMeta();
    }

    void start() {
        if (this.trace.isInfoEnabled() || this.session.getDatabase().getQueryStatistics()) {
            this.startTime = System.currentTimeMillis();
        }
    }

    void setProgress(int state) {
        this.session.getDatabase().setProgress(state, this.sql, 0, 0);
    }

    protected void checkCanceled() {
        if (this.cancel) {
            this.cancel = false;
            throw DbException.get(57014);
        }
    }

    private void stop() {
        long time;
        Database db;
        this.session.endStatement();
        this.session.setCurrentCommand(null);
        if (!this.isTransactional()) {
            this.session.commit(true);
        } else if (this.session.getAutoCommit()) {
            this.session.commit(false);
        } else if (this.session.getDatabase().isMultiThreaded() && (db = this.session.getDatabase()) != null && db.getLockMode() == 3) {
            this.session.unlockReadLocks();
        }
        if (this.trace.isInfoEnabled() && this.startTime > 0L && (time = System.currentTimeMillis() - this.startTime) > 100L) {
            this.trace.info("slow query: {0} ms", time);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultInterface executeQuery(int maxrows, boolean scrollable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int executeUpdate() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long filterConcurrentUpdate(DbException e, long start) {
        long slept;
        int errorCode = e.getErrorCode();
        if (errorCode != 90131 && errorCode != 90112) {
            throw e;
        }
        long now = System.nanoTime() / 1000000L;
        if (start != 0L && now - start > (long)this.session.getLockTimeout()) {
            throw DbException.get(50200, e.getCause(), "");
        }
        Database database = this.session.getDatabase();
        int sleep = 1 + MathUtils.randomInt(10);
        do {
            try {
                if (database.isMultiThreaded()) {
                    Thread.sleep(sleep);
                    continue;
                }
                database.wait(sleep);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
        } while ((slept = System.nanoTime() / 1000000L - now) < (long)sleep);
        return start == 0L ? now : start;
    }

    @Override
    public void close() {
        this.canReuse = true;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    public String toString() {
        return this.sql + Trace.formatParams(this.getParameters());
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean canReuse() {
        return this.canReuse;
    }

    public void reuse() {
        this.canReuse = false;
        ArrayList<? extends ParameterInterface> parameters = this.getParameters();
        int size = parameters.size();
        for (int i = 0; i < size; ++i) {
            ParameterInterface param = parameters.get(i);
            param.setValue(null, true);
        }
    }
}

