/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command.ddl;

import com.alibaba.dts.shade.org.h2.command.ddl.SchemaCommand;
import com.alibaba.dts.shade.org.h2.constraint.Constraint;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.schema.Schema;

public class AlterTableDropConstraint
extends SchemaCommand {
    private String tableName;
    private String constraintName;
    private final boolean ifExists;

    public AlterTableDropConstraint(Session session, Schema schema, boolean ifExists) {
        super(session, schema);
        this.ifExists = ifExists;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Constraint constraint = this.getSchema().findConstraint(this.session, this.tableName, this.constraintName);
        if (constraint == null) {
            if (!this.ifExists) {
                throw DbException.get(90057, this.constraintName);
            }
        } else {
            this.session.getUser().checkRight(constraint.getTable(), 15);
            this.session.getUser().checkRight(constraint.getRefTable(), 15);
            this.session.getDatabase().removeSchemaObject(this.session, constraint);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 14;
    }
}

