/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command.ddl;

import com.alibaba.dts.shade.org.h2.command.ddl.DefineCommand;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.engine.UserDataType;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.value.DataType;

public class CreateUserDataType
extends DefineCommand {
    private String typeName;
    private Column column;
    private boolean ifNotExists;

    public CreateUserDataType(Session session) {
        super(session);
    }

    public void setTypeName(String name) {
        this.typeName = name;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        if (db.findUserDataType(this.typeName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90119, this.typeName);
        }
        DataType builtIn = DataType.getTypeByName(this.typeName);
        if (builtIn != null) {
            if (!builtIn.hidden) {
                throw DbException.get(90119, this.typeName);
            }
            Table table = this.session.getDatabase().getFirstUserTable();
            if (table != null) {
                throw DbException.get(90119, this.typeName + " (" + table.getSQL() + ")");
            }
        }
        int id = this.getObjectId();
        UserDataType type = new UserDataType(db, id, this.typeName);
        type.setColumn(this.column);
        db.addDatabaseObject(this.session, type);
        return 0;
    }

    @Override
    public int getType() {
        return 33;
    }
}

