/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command.dml;

import com.alibaba.dts.shade.org.h2.command.Prepared;
import com.alibaba.dts.shade.org.h2.command.dml.SelectOrderBy;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.expression.Alias;
import com.alibaba.dts.shade.org.h2.expression.Expression;
import com.alibaba.dts.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.dts.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.dts.shade.org.h2.expression.Parameter;
import com.alibaba.dts.shade.org.h2.expression.ValueExpression;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.result.LocalResult;
import com.alibaba.dts.shade.org.h2.result.ResultTarget;
import com.alibaba.dts.shade.org.h2.result.SortOrder;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.ColumnResolver;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.util.New;
import com.alibaba.dts.shade.org.h2.util.ThreadBuffer;
import com.alibaba.dts.shade.org.h2.value.CompareMode;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueInt;
import com.alibaba.dts.shade.org.h2.value.ValueNull;
import java.util.ArrayList;
import java.util.HashSet;

public abstract class Query
extends Prepared {
    protected Expression limitExpr;
    protected Expression offsetExpr;
    protected Expression sampleSizeExpr;
    protected boolean distinct;
    protected boolean randomAccessResult;
    private boolean noCache;
    private int lastLimit;
    private long lastEvaluated;
    private LocalResult lastResult;
    private Value[] lastParameters;
    private boolean cacheableChecked;

    Query(Session session) {
        super(session);
    }

    protected abstract LocalResult queryWithoutCache(int var1, ResultTarget var2);

    public abstract void init();

    public abstract ArrayList<Expression> getExpressions();

    public abstract double getCost();

    public int getCostAsExpression() {
        return (int)Math.min(1000000.0, 10.0 + 10.0 * this.getCost());
    }

    public abstract HashSet<Table> getTables();

    public abstract void setOrder(ArrayList<SelectOrderBy> var1);

    public abstract void setForUpdate(boolean var1);

    public abstract int getColumnCount();

    public abstract void mapColumns(ColumnResolver var1, int var2);

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract void addGlobalCondition(Parameter var1, int var2, int var3);

    public abstract boolean allowGlobalConditions();

    public abstract boolean isEverything(ExpressionVisitor var1);

    public abstract void updateAggregate(Session var1);

    public abstract void fireBeforeSelectTriggers();

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setRandomAccessResult(boolean b) {
        this.randomAccessResult = b;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void disableCache() {
        this.noCache = true;
    }

    private boolean sameResultAsLast(Session s, Value[] params, Value[] lastParams, long lastEval) {
        if (!this.cacheableChecked) {
            long max = this.getMaxDataModificationId();
            this.noCache = max == Long.MAX_VALUE;
            this.cacheableChecked = true;
        }
        if (this.noCache) {
            return false;
        }
        Database db = s.getDatabase();
        for (int i = 0; i < params.length; ++i) {
            Value a = lastParams[i];
            Value b = params[i];
            if (a.getType() == b.getType() && db.areEqual(a, b)) continue;
            return false;
        }
        if (!this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) || !this.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
            return false;
        }
        return db.getModificationDataId() <= lastEval || this.getMaxDataModificationId() <= lastEval;
    }

    public final Value[] getParameterValues() {
        ArrayList<Parameter> list = this.getParameters();
        if (list == null) {
            list = New.arrayList();
        }
        int size = list.size();
        Value[] params = new Value[size];
        for (int i = 0; i < size; ++i) {
            Value v;
            params[i] = v = list.get(i).getParamValue();
        }
        return params;
    }

    @Override
    public LocalResult query(int maxrows) {
        return this.query(maxrows, null);
    }

    LocalResult query(int limit, ResultTarget target) {
        this.fireBeforeSelectTriggers();
        if (this.noCache || !this.session.getDatabase().getOptimizeReuseResults()) {
            return this.queryWithoutCache(limit, target);
        }
        Value[] params = this.getParameterValues();
        long now = this.session.getDatabase().getModificationDataId();
        if (this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) && this.lastResult != null && !this.lastResult.isClosed() && limit == this.lastLimit && this.sameResultAsLast(this.session, params, this.lastParameters, this.lastEvaluated)) {
            this.lastResult = this.lastResult.createShallowCopy(this.session);
            if (this.lastResult != null) {
                this.lastResult.reset();
                return this.lastResult;
            }
        }
        this.lastParameters = params;
        this.closeLastResult();
        boolean vQuery = null != ThreadBuffer.get("queryVersion");
        LocalResult r = this.queryWithoutCache(limit, target);
        this.lastResult = vQuery ? null : r;
        this.lastEvaluated = now;
        this.lastLimit = limit;
        return r;
    }

    private void closeLastResult() {
        if (this.lastResult != null) {
            this.lastResult.close();
        }
    }

    static void initOrder(Session session, ArrayList<Expression> expressions, ArrayList<String> expressionSQL, ArrayList<SelectOrderBy> orderList, int visible, boolean mustBeInResult, ArrayList<TableFilter> filters) {
        Database db = session.getDatabase();
        for (SelectOrderBy o : orderList) {
            Expression expr;
            Expression e = o.expression;
            if (e == null) continue;
            boolean isAlias = false;
            int idx = expressions.size();
            if (e instanceof ExpressionColumn) {
                ExpressionColumn exprCol = (ExpressionColumn)e;
                String tableAlias = exprCol.getOriginalTableAliasName();
                String col = exprCol.getOriginalColumnName();
                for (int j = 0; j < visible; ++j) {
                    boolean found = false;
                    Expression ec = expressions.get(j);
                    if (ec instanceof ExpressionColumn) {
                        ExpressionColumn c = (ExpressionColumn)ec;
                        found = db.equalsIdentifiers(col, c.getColumnName());
                        if (found && tableAlias != null) {
                            String ca = c.getOriginalTableAliasName();
                            if (ca == null) {
                                found = false;
                                if (filters != null) {
                                    int size = filters.size();
                                    for (int i = 0; i < size; ++i) {
                                        TableFilter f = filters.get(i);
                                        if (!db.equalsIdentifiers(f.getTableAlias(), tableAlias)) continue;
                                        found = true;
                                        break;
                                    }
                                }
                            } else {
                                found = db.equalsIdentifiers(ca, tableAlias);
                            }
                        }
                    } else {
                        if (!(ec instanceof Alias)) continue;
                        if (tableAlias == null && db.equalsIdentifiers(col, ec.getAlias())) {
                            found = true;
                        } else {
                            Expression ec2 = ec.getNonAliasExpression();
                            if (ec2 instanceof ExpressionColumn) {
                                ExpressionColumn c2 = (ExpressionColumn)ec2;
                                String ta = exprCol.getSQL();
                                String tb = c2.getSQL();
                                String s2 = c2.getColumnName();
                                found = db.equalsIdentifiers(col, s2);
                                if (!db.equalsIdentifiers(ta, tb)) {
                                    found = false;
                                }
                            }
                        }
                    }
                    if (!found) continue;
                    idx = j;
                    isAlias = true;
                    break;
                }
            } else {
                String s = e.getSQL();
                if (expressionSQL != null) {
                    int size = expressionSQL.size();
                    for (int j = 0; j < size; ++j) {
                        String s2 = expressionSQL.get(j);
                        if (!db.equalsIdentifiers(s2, s)) continue;
                        idx = j;
                        isAlias = true;
                        break;
                    }
                }
            }
            if (!isAlias) {
                if (mustBeInResult) {
                    throw DbException.get(90068, e.getSQL());
                }
                expressions.add(e);
                String sql = e.getSQL();
                expressionSQL.add(sql);
            }
            o.columnIndexExpr = ValueExpression.get(ValueInt.get(idx + 1));
            o.expression = expr = expressions.get(idx).getNonAliasExpression();
        }
    }

    public SortOrder prepareOrder(ArrayList<SelectOrderBy> orderList, int expressionCount) {
        int size = orderList.size();
        int[] index = new int[size];
        int[] sortType = new int[size];
        CompareMode[] compareModes = new CompareMode[size];
        for (int i = 0; i < size; ++i) {
            Column col;
            int type;
            int idx;
            SelectOrderBy o = orderList.get(i);
            boolean reverse = false;
            Expression expr = o.columnIndexExpr;
            Value v = expr.getValue(null);
            if (v == ValueNull.INSTANCE) {
                idx = 0;
            } else {
                idx = v.getInt();
                if (idx < 0) {
                    reverse = true;
                    idx = -idx;
                }
                if (--idx < 0 || idx >= expressionCount) {
                    throw DbException.get(90068, "" + (idx + 1));
                }
            }
            index[i] = idx;
            boolean desc = o.descending;
            if (reverse) {
                desc = !desc;
            }
            int n = type = desc ? 1 : 0;
            if (o.nullsFirst) {
                type += 2;
            } else if (o.nullsLast) {
                type += 4;
            }
            sortType[i] = type;
            compareModes[i] = null;
            if (!(o.expression instanceof ExpressionColumn) || (col = ((ExpressionColumn)o.expression).getColumn()) == null) continue;
            compareModes[i] = col.getCompareMode() != null ? col.getCompareMode() : col.getTable().getCompareMode();
        }
        return new SortOrder(this.session.getDatabase(), index, sortType, orderList, compareModes);
    }

    public void setOffset(Expression offset) {
        this.offsetExpr = offset;
    }

    public Expression getOffset() {
        return this.offsetExpr;
    }

    public void setLimit(Expression limit) {
        this.limitExpr = limit;
    }

    public Expression getLimit() {
        return this.limitExpr;
    }

    void addParameter(Parameter param) {
        if (this.parameters == null) {
            this.parameters = New.arrayList();
        }
        this.parameters.add(param);
    }

    public void setSampleSize(Expression sampleSize) {
        this.sampleSizeExpr = sampleSize;
    }

    int getSampleSizeValue(Session session) {
        if (this.sampleSizeExpr == null) {
            return 0;
        }
        Value v = this.sampleSizeExpr.optimize(session).getValue(session);
        if (v == ValueNull.INSTANCE) {
            return 0;
        }
        return v.getInt();
    }

    public final long getMaxDataModificationId() {
        ExpressionVisitor visitor = ExpressionVisitor.getMaxModificationIdVisitor();
        this.isEverything(visitor);
        return visitor.getMaxDataModificationId();
    }
}

