/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command.dml;

import com.alibaba.dts.shade.org.h2.api.JavaObjectSerializer;
import com.alibaba.dts.shade.org.h2.command.Prepared;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.engine.SysProperties;
import com.alibaba.dts.shade.org.h2.expression.Expression;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.security.SHA256;
import com.alibaba.dts.shade.org.h2.store.DataHandler;
import com.alibaba.dts.shade.org.h2.store.FileStore;
import com.alibaba.dts.shade.org.h2.store.FileStoreInputStream;
import com.alibaba.dts.shade.org.h2.store.FileStoreOutputStream;
import com.alibaba.dts.shade.org.h2.store.LobStorageBackend;
import com.alibaba.dts.shade.org.h2.store.fs.FileUtils;
import com.alibaba.dts.shade.org.h2.tools.CompressTool;
import com.alibaba.dts.shade.org.h2.util.IOUtils;
import com.alibaba.dts.shade.org.h2.util.SmallLRUCache;
import com.alibaba.dts.shade.org.h2.util.TempFileDeleter;
import com.alibaba.dts.shade.org.h2.value.CompareMode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class ScriptBase
extends Prepared
implements DataHandler {
    private static final String SCRIPT_SQL = "script.sql";
    protected OutputStream out;
    protected InputStream in;
    private Expression fileNameExpr;
    private Expression password;
    private String fileName;
    private String cipher;
    private FileStore store;
    private String compressionAlgorithm;

    ScriptBase(Session session) {
        super(session);
    }

    public void setCipher(String c) {
        this.cipher = c;
    }

    private boolean isEncrypted() {
        return this.cipher != null;
    }

    public void setPassword(Expression password) {
        this.password = password;
    }

    public void setFileNameExpr(Expression file) {
        this.fileNameExpr = file;
    }

    protected String getFileName() {
        if (this.fileNameExpr != null && this.fileName == null) {
            this.fileName = this.fileNameExpr.optimize(this.session).getValue(this.session).getString();
            if (this.fileName == null || this.fileName.trim().length() == 0) {
                this.fileName = SCRIPT_SQL;
            }
            this.fileName = SysProperties.getScriptDirectory() + this.fileName;
        }
        return this.fileName;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    void deleteStore() {
        String file = this.getFileName();
        if (file != null) {
            FileUtils.delete(file);
        }
    }

    private void initStore() {
        Database db = this.session.getDatabase();
        byte[] key = null;
        if (this.cipher != null && this.password != null) {
            char[] pass = this.password.optimize(this.session).getValue(this.session).getString().toCharArray();
            key = SHA256.getKeyPasswordHash("script", pass);
        }
        String file = this.getFileName();
        this.store = FileStore.open(db, file, "rw", this.cipher, key);
        this.store.setCheckedWriting(false);
        this.store.init();
    }

    void openOutput() {
        String file = this.getFileName();
        if (file == null) {
            return;
        }
        if (this.isEncrypted()) {
            this.initStore();
            this.out = new FileStoreOutputStream(this.store, this, this.compressionAlgorithm);
            this.out = new BufferedOutputStream(this.out, 131072);
        } else {
            OutputStream o;
            try {
                o = FileUtils.newOutputStream(file, false);
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, null);
            }
            this.out = new BufferedOutputStream(o, 4096);
            this.out = CompressTool.wrapOutputStream(this.out, this.compressionAlgorithm, SCRIPT_SQL);
        }
    }

    void openInput() {
        String file = this.getFileName();
        if (file == null) {
            return;
        }
        if (this.isEncrypted()) {
            this.initStore();
            this.in = new FileStoreInputStream(this.store, this, this.compressionAlgorithm != null, false);
        } else {
            InputStream inStream;
            try {
                inStream = FileUtils.newInputStream(file);
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, file);
            }
            this.in = new BufferedInputStream(inStream, 4096);
            this.in = CompressTool.wrapInputStream(this.in, this.compressionAlgorithm, SCRIPT_SQL);
            if (this.in == null) {
                throw DbException.get(90124, "script.sql in " + file);
            }
        }
    }

    void closeIO() {
        IOUtils.closeSilently(this.out);
        this.out = null;
        IOUtils.closeSilently(this.in);
        this.in = null;
        if (this.store != null) {
            this.store.closeSilently();
            this.store = null;
        }
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public String getDatabasePath() {
        return null;
    }

    @Override
    public FileStore openFile(String name, String mode, boolean mustExist) {
        return null;
    }

    @Override
    public void checkPowerOff() {
        this.session.getDatabase().checkPowerOff();
    }

    @Override
    public void checkWritingAllowed() {
        this.session.getDatabase().checkWritingAllowed();
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return this.session.getDatabase().getMaxLengthInplaceLob();
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return this.session.getDatabase().getTempFileDeleter();
    }

    @Override
    public String getLobCompressionAlgorithm(int type) {
        return this.session.getDatabase().getLobCompressionAlgorithm(type);
    }

    public void setCompressionAlgorithm(String algorithm) {
        this.compressionAlgorithm = algorithm;
    }

    @Override
    public Object getLobSyncObject() {
        return this;
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return null;
    }

    @Override
    public LobStorageBackend getLobStorage() {
        return null;
    }

    @Override
    public int readLob(long lobId, byte[] hmac, long offset, byte[] buff, int off, int length) {
        throw DbException.throwInternalError();
    }

    @Override
    public JavaObjectSerializer getJavaObjectSerializer() {
        return this.session.getDataHandler().getJavaObjectSerializer();
    }

    @Override
    public CompareMode getCompareMode() {
        return this.session.getDataHandler().getCompareMode();
    }
}

