/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.engine;

import com.alibaba.dts.shade.org.h2.Driver;
import com.alibaba.dts.shade.org.h2.command.Parser;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.engine.SysProperties;
import com.alibaba.dts.shade.org.h2.expression.Expression;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.schema.Schema;
import com.alibaba.dts.shade.org.h2.schema.SchemaObjectBase;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.util.JdbcUtils;
import com.alibaba.dts.shade.org.h2.util.New;
import com.alibaba.dts.shade.org.h2.util.SourceCompiler;
import com.alibaba.dts.shade.org.h2.util.StatementBuilder;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import com.alibaba.dts.shade.org.h2.value.DataType;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueArray;
import com.alibaba.dts.shade.org.h2.value.ValueNull;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;

public class FunctionAlias
extends SchemaObjectBase {
    private String className;
    private String methodName;
    private String source;
    private JavaMethod[] javaMethods;
    private boolean deterministic;
    private boolean bufferResultSetToLocalTemp = true;

    private FunctionAlias(Schema schema, int id, String name) {
        this.initSchemaObjectBase(schema, id, name, 3);
    }

    public static FunctionAlias newInstance(Schema schema, int id, String name, String javaClassMethod, boolean force, boolean bufferResultSetToLocalTemp) {
        FunctionAlias alias = new FunctionAlias(schema, id, name);
        int paren = javaClassMethod.indexOf(40);
        int lastDot = javaClassMethod.lastIndexOf(46, paren < 0 ? javaClassMethod.length() : paren);
        if (lastDot < 0) {
            throw DbException.get(42000, javaClassMethod);
        }
        alias.className = javaClassMethod.substring(0, lastDot);
        alias.methodName = javaClassMethod.substring(lastDot + 1);
        alias.bufferResultSetToLocalTemp = bufferResultSetToLocalTemp;
        alias.init(force);
        return alias;
    }

    public static FunctionAlias newInstanceFromSource(Schema schema, int id, String name, String source, boolean force, boolean bufferResultSetToLocalTemp) {
        FunctionAlias alias = new FunctionAlias(schema, id, name);
        alias.source = source;
        alias.bufferResultSetToLocalTemp = bufferResultSetToLocalTemp;
        alias.init(force);
        return alias;
    }

    private void init(boolean force) {
        block2: {
            try {
                this.load();
            }
            catch (DbException e) {
                if (force) break block2;
                throw e;
            }
        }
    }

    private synchronized void load() {
        if (this.javaMethods != null) {
            return;
        }
        if (this.source != null) {
            this.loadFromSource();
        } else {
            this.loadClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromSource() {
        SourceCompiler compiler;
        SourceCompiler sourceCompiler = compiler = this.database.getCompiler();
        synchronized (sourceCompiler) {
            String fullClassName = "com.alibaba.dts.shade.org.h2.dynamic." + this.getName();
            compiler.setSource(fullClassName, this.source);
            try {
                Method m = compiler.getMethod(fullClassName);
                JavaMethod method = new JavaMethod(m, 0);
                this.javaMethods = new JavaMethod[]{method};
            }
            catch (DbException e) {
                throw e;
            }
            catch (Exception e) {
                throw DbException.get(42000, e, this.source);
            }
        }
    }

    private void loadClass() {
        Class<?> javaClass = JdbcUtils.loadUserClass(this.className);
        Method[] methods = javaClass.getMethods();
        ArrayList<JavaMethod> list = New.arrayList();
        int len = methods.length;
        for (int i = 0; i < len; ++i) {
            Method m = methods[i];
            if (!Modifier.isStatic(m.getModifiers()) || !m.getName().equals(this.methodName) && !FunctionAlias.getMethodSignature(m).equals(this.methodName)) continue;
            JavaMethod javaMethod = new JavaMethod(m, i);
            for (JavaMethod old : list) {
                if (old.getParameterCount() != javaMethod.getParameterCount()) continue;
                throw DbException.get(90073, old.toString(), javaMethod.toString());
            }
            list.add(javaMethod);
        }
        if (list.size() == 0) {
            throw DbException.get(90139, this.methodName + " (" + this.className + ")");
        }
        this.javaMethods = new JavaMethod[list.size()];
        list.toArray(this.javaMethods);
        Arrays.sort(this.javaMethods);
    }

    private static String getMethodSignature(Method m) {
        StatementBuilder buff = new StatementBuilder(m.getName());
        buff.append('(');
        for (Class<?> p : m.getParameterTypes()) {
            buff.appendExceptFirst(",");
            if (p.isArray()) {
                buff.append(p.getComponentType().getName()).append("[]");
                continue;
            }
            buff.append(p.getName());
        }
        return buff.append(')').toString();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw DbException.throwInternalError();
    }

    @Override
    public String getDropSQL() {
        return "DROP ALIAS IF EXISTS " + this.getSQL();
    }

    @Override
    public String getSQL() {
        if (this.database.getSettings().functionsInSchema || !this.getSchema().getName().equals("PUBLIC")) {
            return super.getSQL();
        }
        return Parser.quoteIdentifier(this.getName());
    }

    @Override
    public String getCreateSQL() {
        StringBuilder buff = new StringBuilder("CREATE FORCE ALIAS ");
        buff.append(this.getSQL());
        if (this.deterministic) {
            buff.append(" DETERMINISTIC");
        }
        if (!this.bufferResultSetToLocalTemp) {
            buff.append(" NOBUFFER");
        }
        if (this.source != null) {
            buff.append(" AS ").append(StringUtils.quoteStringSQL(this.source));
        } else {
            buff.append(" FOR ").append(Parser.quoteIdentifier(this.className + "." + this.methodName));
        }
        return buff.toString();
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public synchronized void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.className = null;
        this.methodName = null;
        this.javaMethods = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("RENAME");
    }

    public JavaMethod findJavaMethod(Expression[] args) {
        this.load();
        int parameterCount = args.length;
        for (JavaMethod m : this.javaMethods) {
            int count = m.getParameterCount();
            if (count != parameterCount && (!m.isVarArgs() || count > parameterCount + 1)) continue;
            return m;
        }
        throw DbException.get(90087, this.getName() + " (" + this.className + ", parameter count: " + parameterCount + ")");
    }

    public String getJavaClassName() {
        return this.className;
    }

    public String getJavaMethodName() {
        return this.methodName;
    }

    public JavaMethod[] getJavaMethods() {
        this.load();
        return this.javaMethods;
    }

    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public String getSource() {
        return this.source;
    }

    static boolean isVarArgs(Method m) {
        if ("1.5".compareTo(SysProperties.JAVA_SPECIFICATION_VERSION) > 0) {
            return false;
        }
        try {
            Method isVarArgs = m.getClass().getMethod("isVarArgs", new Class[0]);
            Boolean result = (Boolean)isVarArgs.invoke((Object)m, new Object[0]);
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isBufferResultSetToLocalTemp() {
        return this.bufferResultSetToLocalTemp;
    }

    public static class JavaMethod
    implements Comparable<JavaMethod> {
        private final int id;
        private final Method method;
        private final int dataType;
        private boolean hasConnectionParam;
        private boolean varArgs;
        private Class<?> varArgClass;
        private int paramCount;

        JavaMethod(Method method, int id) {
            Class<?> lastArg;
            Class<?> paramClass;
            this.method = method;
            this.id = id;
            Class<?>[] paramClasses = method.getParameterTypes();
            this.paramCount = paramClasses.length;
            if (this.paramCount > 0 && Connection.class.isAssignableFrom(paramClass = paramClasses[0])) {
                this.hasConnectionParam = true;
                --this.paramCount;
            }
            if (this.paramCount > 0 && (lastArg = paramClasses[paramClasses.length - 1]).isArray() && FunctionAlias.isVarArgs(method)) {
                this.varArgs = true;
                this.varArgClass = lastArg.getComponentType();
            }
            Class<?> returnClass = method.getReturnType();
            this.dataType = DataType.getTypeFromClass(returnClass);
        }

        public String toString() {
            return this.method.toString();
        }

        public boolean hasConnectionParam() {
            return this.hasConnectionParam;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Value getValue(Session session, Expression[] args, boolean columnList) {
            Class<?>[] paramClasses = this.method.getParameterTypes();
            Object[] params = new Object[paramClasses.length];
            int p = 0;
            if (this.hasConnectionParam && params.length > 0) {
                params[p++] = session.createConnection(columnList);
            }
            Object varArg = null;
            if (this.varArgs) {
                int len = args.length - params.length + 1 + (this.hasConnectionParam ? 1 : 0);
                params[params.length - 1] = varArg = Array.newInstance(this.varArgClass, len);
            }
            int a = 0;
            int len = args.length;
            while (a < len) {
                Object[] o;
                boolean currentIsVarArg = this.varArgs && p >= paramClasses.length - 1;
                Class<?> paramClass = currentIsVarArg ? this.varArgClass : paramClasses[p];
                int type = DataType.getTypeFromClass(paramClass);
                Value v = args[a].getValue(session);
                if (Value.class.isAssignableFrom(paramClass)) {
                    o = v;
                } else if (v.getType() == 17 && paramClass.isArray() && paramClass.getComponentType() != Object.class) {
                    Value[] array = ((ValueArray)v).getList();
                    Object[] objArray = (Object[])Array.newInstance(paramClass.getComponentType(), array.length);
                    int componentType = DataType.getTypeFromClass(paramClass.getComponentType());
                    for (int i = 0; i < objArray.length; ++i) {
                        objArray[i] = array[i].convertTo(componentType).getObject();
                    }
                    o = objArray;
                } else {
                    v = v.convertTo(type);
                    o = v.getObject();
                }
                if (o == null) {
                    if (paramClass.isPrimitive()) {
                        if (!columnList) return ValueNull.INSTANCE;
                        o = DataType.getDefaultForPrimitiveType(paramClass);
                    }
                } else if (!paramClass.isAssignableFrom(o.getClass()) && !paramClass.isPrimitive()) {
                    o = DataType.convertTo(session.createConnection(false), v, paramClass);
                }
                if (currentIsVarArg) {
                    Array.set(varArg, p - params.length + 1, o);
                } else {
                    params[p] = o;
                }
                ++a;
                ++p;
            }
            boolean old = session.getAutoCommit();
            Value identity = session.getLastScopeIdentity();
            boolean defaultConnection = session.getDatabase().getSettings().defaultConnection;
            try {
                Object returnValue;
                session.setAutoCommit(false);
                try {
                    if (defaultConnection) {
                        Driver.setDefaultConnection(session.createConnection(columnList));
                    }
                    if ((returnValue = this.method.invoke(null, params)) == null) {
                        ValueNull type = ValueNull.INSTANCE;
                        return type;
                    }
                }
                catch (InvocationTargetException e) {
                    StatementBuilder buff = new StatementBuilder(this.method.getName());
                    buff.append('(');
                    for (Object o : params) {
                        buff.appendExceptFirst(", ");
                        buff.append(o == null ? "null" : o.toString());
                    }
                    buff.append(')');
                    throw DbException.convertInvocation(e, buff.toString());
                }
                catch (Exception e) {
                    throw DbException.convert(e);
                }
                if (Value.class.isAssignableFrom(this.method.getReturnType())) {
                    Value e = (Value)returnValue;
                    return e;
                }
                Value ret = DataType.convertToValue(session, returnValue, this.dataType);
                Value value = ret.convertTo(this.dataType);
                return value;
            }
            finally {
                session.setLastScopeIdentity(identity);
                session.setAutoCommit(old);
                if (defaultConnection) {
                    Driver.setDefaultConnection(null);
                }
            }
        }

        public Class<?>[] getColumnClasses() {
            return this.method.getParameterTypes();
        }

        public int getDataType() {
            return this.dataType;
        }

        public int getParameterCount() {
            return this.paramCount;
        }

        public boolean isVarArgs() {
            return this.varArgs;
        }

        @Override
        public int compareTo(JavaMethod m) {
            if (this.varArgs != m.varArgs) {
                return this.varArgs ? 1 : -1;
            }
            if (this.paramCount != m.paramCount) {
                return this.paramCount - m.paramCount;
            }
            if (this.hasConnectionParam != m.hasConnectionParam) {
                return this.hasConnectionParam ? 1 : -1;
            }
            return this.id - m.id;
        }
    }
}

