/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.expression;

import com.alibaba.dts.shade.org.h2.command.Command;
import com.alibaba.dts.shade.org.h2.command.Parser;
import com.alibaba.dts.shade.org.h2.engine.Constants;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.expression.Expression;
import com.alibaba.dts.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.dts.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.dts.shade.org.h2.expression.FunctionCall;
import com.alibaba.dts.shade.org.h2.expression.FunctionInfo;
import com.alibaba.dts.shade.org.h2.expression.SequenceValue;
import com.alibaba.dts.shade.org.h2.expression.TableFunction;
import com.alibaba.dts.shade.org.h2.expression.ValueExpression;
import com.alibaba.dts.shade.org.h2.expression.Variable;
import com.alibaba.dts.shade.org.h2.jdbc.JdbcConnection;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.mvstore.DataUtils;
import com.alibaba.dts.shade.org.h2.schema.Schema;
import com.alibaba.dts.shade.org.h2.schema.Sequence;
import com.alibaba.dts.shade.org.h2.security.BlockCipher;
import com.alibaba.dts.shade.org.h2.security.CipherFactory;
import com.alibaba.dts.shade.org.h2.security.SHA256;
import com.alibaba.dts.shade.org.h2.store.fs.FileUtils;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.ColumnResolver;
import com.alibaba.dts.shade.org.h2.table.LinkSchema;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.tools.CompressTool;
import com.alibaba.dts.shade.org.h2.tools.Csv;
import com.alibaba.dts.shade.org.h2.util.AutoCloseInputStream;
import com.alibaba.dts.shade.org.h2.util.DateTimeUtils;
import com.alibaba.dts.shade.org.h2.util.IOUtils;
import com.alibaba.dts.shade.org.h2.util.JdbcUtils;
import com.alibaba.dts.shade.org.h2.util.MathUtils;
import com.alibaba.dts.shade.org.h2.util.New;
import com.alibaba.dts.shade.org.h2.util.StatementBuilder;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import com.alibaba.dts.shade.org.h2.util.ToChar;
import com.alibaba.dts.shade.org.h2.util.Utils;
import com.alibaba.dts.shade.org.h2.value.DataType;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueArray;
import com.alibaba.dts.shade.org.h2.value.ValueBoolean;
import com.alibaba.dts.shade.org.h2.value.ValueBytes;
import com.alibaba.dts.shade.org.h2.value.ValueDate;
import com.alibaba.dts.shade.org.h2.value.ValueDouble;
import com.alibaba.dts.shade.org.h2.value.ValueInt;
import com.alibaba.dts.shade.org.h2.value.ValueLong;
import com.alibaba.dts.shade.org.h2.value.ValueNull;
import com.alibaba.dts.shade.org.h2.value.ValueResultSet;
import com.alibaba.dts.shade.org.h2.value.ValueString;
import com.alibaba.dts.shade.org.h2.value.ValueTime;
import com.alibaba.dts.shade.org.h2.value.ValueTimestamp;
import com.alibaba.dts.shade.org.h2.value.ValueUuid;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.PatternSyntaxException;
import java.util.zip.CRC32;

public class Function
extends Expression
implements FunctionCall {
    public static final int ABS = 0;
    public static final int ACOS = 1;
    public static final int ASIN = 2;
    public static final int ATAN = 3;
    public static final int ATAN2 = 4;
    public static final int BITAND = 5;
    public static final int BITOR = 6;
    public static final int BITXOR = 7;
    public static final int CEILING = 8;
    public static final int COS = 9;
    public static final int COT = 10;
    public static final int DEGREES = 11;
    public static final int EXP = 12;
    public static final int FLOOR = 13;
    public static final int LOG = 14;
    public static final int LOG10 = 15;
    public static final int MOD = 16;
    public static final int PI = 17;
    public static final int POWER = 18;
    public static final int RADIANS = 19;
    public static final int RAND = 20;
    public static final int ROUND = 21;
    public static final int ROUNDMAGIC = 22;
    public static final int SIGN = 23;
    public static final int SIN = 24;
    public static final int SQRT = 25;
    public static final int TAN = 26;
    public static final int TRUNCATE = 27;
    public static final int SECURE_RAND = 28;
    public static final int HASH = 29;
    public static final int ENCRYPT = 30;
    public static final int DECRYPT = 31;
    public static final int COMPRESS = 32;
    public static final int EXPAND = 33;
    public static final int ZERO = 34;
    public static final int RANDOM_UUID = 35;
    public static final int COSH = 36;
    public static final int SINH = 37;
    public static final int TANH = 38;
    public static final int LN = 39;
    public static final int CONV = 40;
    public static final int ASCII = 50;
    public static final int BIT_LENGTH = 51;
    public static final int CHAR = 52;
    public static final int CHAR_LENGTH = 53;
    public static final int CONCAT = 54;
    public static final int DIFFERENCE = 55;
    public static final int HEXTORAW = 56;
    public static final int INSERT = 57;
    public static final int INSTR = 58;
    public static final int LCASE = 59;
    public static final int LEFT = 60;
    public static final int LENGTH = 61;
    public static final int LOCATE = 62;
    public static final int LTRIM = 63;
    public static final int OCTET_LENGTH = 64;
    public static final int RAWTOHEX = 65;
    public static final int REPEAT = 66;
    public static final int REPLACE = 67;
    public static final int RIGHT = 68;
    public static final int RTRIM = 69;
    public static final int SOUNDEX = 70;
    public static final int SPACE = 71;
    public static final int SUBSTR = 72;
    public static final int SUBSTRING = 73;
    public static final int UCASE = 74;
    public static final int LOWER = 75;
    public static final int UPPER = 76;
    public static final int POSITION = 77;
    public static final int TRIM = 78;
    public static final int STRINGENCODE = 79;
    public static final int STRINGDECODE = 80;
    public static final int STRINGTOUTF8 = 81;
    public static final int UTF8TOSTRING = 82;
    public static final int XMLATTR = 83;
    public static final int XMLNODE = 84;
    public static final int XMLCOMMENT = 85;
    public static final int XMLCDATA = 86;
    public static final int XMLSTARTDOC = 87;
    public static final int XMLTEXT = 88;
    public static final int REGEXP_REPLACE = 89;
    public static final int RPAD = 90;
    public static final int LPAD = 91;
    public static final int CONCAT_WS = 92;
    public static final int TO_CHAR = 93;
    public static final int TRANSLATE = 94;
    public static final int ORA_HASH = 95;
    public static final int BIN = 96;
    public static final int HEX = 97;
    public static final int UNHEX = 98;
    public static final int CURDATE = 100;
    public static final int CURTIME = 101;
    public static final int DATEADD = 102;
    public static final int DATE_DIFF = 103;
    public static final int DAY_NAME = 104;
    public static final int DAY_OF_MONTH = 105;
    public static final int DAY_OF_WEEK = 106;
    public static final int DAY_OF_YEAR = 107;
    public static final int HOUR = 108;
    public static final int MINUTE = 109;
    public static final int MONTH = 110;
    public static final int MONTH_NAME = 111;
    public static final int NOW = 112;
    public static final int QUARTER = 113;
    public static final int SECOND = 114;
    public static final int WEEK = 115;
    public static final int YEAR = 116;
    public static final int CURRENT_DATE = 117;
    public static final int CURRENT_TIME = 118;
    public static final int CURRENT_TIMESTAMP = 119;
    public static final int EXTRACT = 120;
    public static final int FORMATDATETIME = 121;
    public static final int PARSEDATETIME = 122;
    public static final int ISO_YEAR = 123;
    public static final int ISO_WEEK = 124;
    public static final int ISO_DAY_OF_WEEK = 125;
    public static final int DATE_FORMAT = 126;
    public static final int DATABASE = 150;
    public static final int USER = 151;
    public static final int CURRENT_USER = 152;
    public static final int IDENTITY = 153;
    public static final int SCOPE_IDENTITY = 154;
    public static final int AUTOCOMMIT = 155;
    public static final int READONLY = 156;
    public static final int DATABASE_PATH = 157;
    public static final int LOCK_TIMEOUT = 158;
    public static final int DISK_SPACE_USED = 159;
    public static final int IFNULL = 200;
    public static final int CASEWHEN = 201;
    public static final int CONVERT = 202;
    public static final int CAST = 203;
    public static final int COALESCE = 204;
    public static final int NULLIF = 205;
    public static final int CASE = 206;
    public static final int NEXTVAL = 207;
    public static final int CURRVAL = 208;
    public static final int ARRAY_GET = 209;
    public static final int CSVREAD = 210;
    public static final int CSVWRITE = 211;
    public static final int MEMORY_FREE = 212;
    public static final int MEMORY_USED = 213;
    public static final int LOCK_MODE = 214;
    public static final int SCHEMA = 215;
    public static final int SESSION_ID = 216;
    public static final int ARRAY_LENGTH = 217;
    public static final int LINK_SCHEMA = 218;
    public static final int GREATEST = 219;
    public static final int LEAST = 220;
    public static final int CANCEL_SESSION = 221;
    public static final int SET = 222;
    public static final int TABLE = 223;
    public static final int TABLE_DISTINCT = 224;
    public static final int FILE_READ = 225;
    public static final int TRANSACTION_ID = 226;
    public static final int TRUNCATE_VALUE = 227;
    public static final int NVL2 = 228;
    public static final int DECODE = 229;
    public static final int ARRAY_CONTAINS = 230;
    public static final int FILE_WRITE = 232;
    public static final int VALUES = 250;
    public static final int H2VERSION = 231;
    public static final int ROW_NUMBER = 300;
    public static final int ELT = 400;
    public static final int FIELD = 401;
    public static final int EXPORT_SET = 402;
    public static final int FIND_IN_SET = 403;
    public static final int FORMAT = 404;
    public static final int MAKE_SET = 405;
    public static final int OCT = 406;
    public static final int ORD = 407;
    public static final int QUOTE = 408;
    public static final int REVERSE = 409;
    public static final int STRCMP = 410;
    public static final int SUBSTRING_INDEX = 411;
    public static final int UUID = 412;
    public static final int CRC32 = 413;
    public static final int LOG2 = 414;
    public static final int ADDDATE = 415;
    public static final int DATE_ADD = 416;
    public static final int SUBDATE = 417;
    public static final int DATE_SUB = 418;
    public static final int ADDTIME = 419;
    public static final int SUBTIME = 420;
    public static final int DATE = 421;
    public static final int FROM_DAYS = 422;
    public static final int FROM_UNIXTIME = 423;
    public static final int GET_FORMAT = 424;
    public static final int LAST_DAY = 425;
    public static final int MAKEDATE = 426;
    public static final int MAKETIME = 427;
    public static final int MICROSECOND = 428;
    public static final int PERIOD_ADD = 429;
    public static final int PERIOD_DIFF = 430;
    public static final int SEC_TO_TIME = 431;
    public static final int STR_TO_DATE = 432;
    public static final int TIME = 433;
    public static final int TIMEDIFF = 434;
    public static final int TIMESTAMP = 435;
    public static final int TIME_FORMAT = 436;
    public static final int TIME_TO_SEC = 437;
    public static final int UNIX_TIMESTAMP = 438;
    public static final int UTC_DATE = 439;
    public static final int UTC_TIME = 440;
    public static final int UTC_TIMESTAMP = 441;
    public static final int WEEKDAY = 442;
    public static final int WEEKOFYEAR = 443;
    private static final int VAR_ARGS = -1;
    private static final long PRECISION_UNKNOWN = -1L;
    private static final HashMap<String, FunctionInfo> FUNCTIONS = New.hashMap();
    private static final HashMap<String, Integer> DATE_PART = New.hashMap();
    private static final HashMap<Integer, Integer> DATE_PART_TRANS = New.hashMap();
    private static final HashMap<String, String> DATE_FORMATS = New.hashMap();
    private static final char[] SOUNDEX_INDEX = new char[128];
    protected Expression[] args;
    private final FunctionInfo info;
    private ArrayList<Expression> varArgs;
    private int dataType;
    private int scale;
    private long precision = -1L;
    private int displaySize;
    private final Database database;

    protected Function(Database database, FunctionInfo info) {
        this.database = database;
        this.info = info;
        if (info.parameterCount == -1) {
            this.varArgs = New.arrayList();
        } else {
            this.args = new Expression[info.parameterCount];
        }
    }

    private static void addFunction(String name, int type, int parameterCount, int dataType, boolean nullIfParameterIsNull, boolean deterministic, boolean bufferResultSetToLocalTemp) {
        FunctionInfo info = new FunctionInfo();
        info.name = name;
        info.type = type;
        info.parameterCount = parameterCount;
        info.dataType = dataType;
        info.nullIfParameterIsNull = nullIfParameterIsNull;
        info.deterministic = deterministic;
        info.bufferResultSetToLocalTemp = bufferResultSetToLocalTemp;
        FUNCTIONS.put(name, info);
    }

    private static void addFunctionNotDeterministic(String name, int type, int parameterCount, int dataType) {
        Function.addFunction(name, type, parameterCount, dataType, true, false, true);
    }

    private static void addFunction(String name, int type, int parameterCount, int dataType) {
        Function.addFunction(name, type, parameterCount, dataType, true, true, true);
    }

    private static void addFunctionWithNull(String name, int type, int parameterCount, int dataType) {
        Function.addFunction(name, type, parameterCount, dataType, false, true, true);
    }

    private static FunctionInfo getFunctionInfo(String name) {
        return FUNCTIONS.get(name);
    }

    public static Function getFunction(Database database, String name) {
        FunctionInfo info;
        if (!database.getSettings().databaseToUpper) {
            name = StringUtils.toUpperEnglish(name);
        }
        if ((info = Function.getFunctionInfo(name)) == null) {
            return null;
        }
        switch (info.type) {
            case 223: 
            case 224: {
                return new TableFunction(database, info, Long.MAX_VALUE);
            }
        }
        return new Function(database, info);
    }

    public void setParameter(int index, Expression param) {
        if (this.varArgs != null) {
            this.varArgs.add(param);
        } else {
            if (index >= this.args.length) {
                throw DbException.get(7001, this.info.name, "" + this.args.length);
            }
            this.args[index] = param;
        }
    }

    private static strictfp double log10(double value) {
        return Function.roundMagic(StrictMath.log(value) / StrictMath.log(10.0));
    }

    @Override
    public Value getValue(Session session) {
        return this.getValueWithArgs(session, this.args);
    }

    /*
     * Unable to fully structure code
     */
    private Value getSimpleValue(Session session, Value v0, Expression[] args, Value[] values) {
        block2 : switch (this.info.type) {
            case 0: {
                result = v0.getSignum() >= 0 ? v0 : v0.negate();
                break;
            }
            case 1: {
                d = v0.getDouble();
                if (d < -1.0 || d > 1.0) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueDouble.get(Math.acos(d));
                break;
            }
            case 2: {
                d = v0.getDouble();
                if (d < -1.0 || d > 1.0) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueDouble.get(Math.asin(d));
                break;
            }
            case 96: {
                b = Function.convertLongToUnsigned(v0.getLong());
                result = ValueString.get(b.toString(2));
                break;
            }
            case 8: {
                result = ValueDouble.get(Math.ceil(v0.getDouble()));
                break;
            }
            case 9: {
                result = ValueDouble.get(Math.cos(v0.getDouble()));
                break;
            }
            case 36: {
                result = ValueDouble.get(Math.cosh(v0.getDouble()));
                break;
            }
            case 10: {
                d = Math.tan(v0.getDouble());
                if (d == 0.0) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueDouble.get(1.0 / d);
                break;
            }
            case 11: {
                result = ValueDouble.get(Math.toDegrees(v0.getDouble()));
                break;
            }
            case 12: {
                result = ValueDouble.get(Math.exp(v0.getDouble()));
                break;
            }
            case 13: {
                result = ValueDouble.get(Math.floor(v0.getDouble()));
                break;
            }
            case 97: {
                if (v0.getType() == 13) {
                    result = ValueString.get(Function.hex(v0.getString().getBytes()));
                    break;
                }
                if (v0.getType() == 12) {
                    result = ValueString.get(Function.hex(v0.getBytes()));
                    break;
                }
                result = ValueString.get(Function.hex(v0.getLong()));
                break;
            }
            case 98: {
                result = ValueString.get(Function.unhex(v0.getBytes()));
                break;
            }
            case 39: {
                d = v0.getDouble();
                if (d <= 0.0) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueDouble.get(Math.log(d));
                break;
            }
            case 14: {
                if (args.length == 1) {
                    x = v0.getDouble();
                    if (x <= 0.0) {
                        result = ValueNull.INSTANCE;
                        break;
                    }
                    if (this.database.getMode().logIsLogBase10) {
                        result = ValueDouble.get(Math.log10(x));
                        break;
                    }
                    result = ValueDouble.get(Math.log(x));
                    break;
                }
                b = v0.getDouble();
                if (b <= 1.0) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                x = Function.getNullOrValue(session, args, values, 1).getDouble();
                if (x <= 0.0) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueDouble.get(Math.log(x) / Math.log(b));
                break;
            }
            case 414: {
                x = v0.getDouble();
                if (x <= 0.0) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueDouble.get(Math.log(x) / Math.log(2.0));
                break;
            }
            case 15: {
                x = v0.getDouble();
                if (x <= 0.0) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueDouble.get(Function.log10(v0.getDouble()));
                break;
            }
            case 17: {
                result = ValueDouble.get(3.141592653589793);
                break;
            }
            case 19: {
                result = ValueDouble.get(Math.toRadians(v0.getDouble()));
                break;
            }
            case 20: {
                if (v0 != null) {
                    session.getRandom().setSeed(v0.getInt());
                }
                result = ValueDouble.get(session.getRandom().nextDouble());
                break;
            }
            case 22: {
                result = ValueDouble.get(Function.roundMagic(v0.getDouble()));
                break;
            }
            case 23: {
                result = ValueInt.get(v0.getSignum());
                break;
            }
            case 24: {
                result = ValueDouble.get(Math.sin(v0.getDouble()));
                break;
            }
            case 37: {
                result = ValueDouble.get(Math.sinh(v0.getDouble()));
                break;
            }
            case 25: {
                d = v0.getDouble();
                if (d < 0.0) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueDouble.get(Math.sqrt(d));
                break;
            }
            case 26: {
                result = ValueDouble.get(Math.tan(v0.getDouble()));
                break;
            }
            case 38: {
                result = ValueDouble.get(Math.tanh(v0.getDouble()));
                break;
            }
            case 28: {
                result = ValueBytes.getNoCopy(MathUtils.secureRandomBytes(v0.getInt()));
                break;
            }
            case 33: {
                result = ValueBytes.getNoCopy(CompressTool.getInstance().expand(v0.getBytesNoCopy()));
                break;
            }
            case 34: {
                result = ValueInt.get(0);
                break;
            }
            case 35: {
                result = ValueUuid.getNewRandom();
                break;
            }
            case 50: {
                s = v0.getString();
                if (s.length() == 0) {
                    result = ValueInt.get(0);
                    break;
                }
                result = ValueInt.get(s.charAt(0));
                break;
            }
            case 51: {
                result = ValueLong.get(8L * Function.length(v0));
                break;
            }
            case 52: {
                vs = new int[args.length];
                size = 0;
                for (i = 0; i < args.length; ++i) {
                    v = Function.getNullOrValue(session, args, values, i);
                    if (v == ValueNull.INSTANCE) continue;
                    vs[size++] = v.getInt();
                }
                result = ValueBytes.get(Function.intToChars(vs, size));
                break;
            }
            case 53: 
            case 61: 
            case 64: {
                result = ValueLong.get(Function.length(v0));
                break;
            }
            case 54: 
            case 92: {
                result = ValueNull.INSTANCE;
                start = 0;
                separator = "";
                if (this.info.type == 92) {
                    start = 1;
                    separator = Function.getNullOrValue(session, args, values, 0).getString();
                }
                for (i = start; i < args.length; ++i) {
                    v = Function.getNullOrValue(session, args, values, i);
                    if (v == ValueNull.INSTANCE) continue;
                    if (result == ValueNull.INSTANCE) {
                        result = v;
                        continue;
                    }
                    tmp = v.getString();
                    if (!StringUtils.isNullOrEmpty(separator)) {
                        tmp = separator.concat(tmp);
                    }
                    result = ValueString.get(result.getString().concat(tmp), this.database.getMode().treatEmptyStringsAsNull);
                }
                if (this.info.type != 92 || separator == null || result != ValueNull.INSTANCE) break;
                result = ValueString.get("", this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 413: {
                bytes = v0.getString().getBytes();
                checksum = new CRC32();
                checksum.update(bytes, 0, bytes.length);
                result = ValueLong.get(checksum.getValue());
                break;
            }
            case 400: {
                index = v0.getInt();
                if (index < 1 || index >= args.length) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                v = Function.getNullOrValue(session, args, values, index);
                if (v == ValueNull.INSTANCE) {
                    result = v;
                    break;
                }
                result = ValueString.get(v.getString());
                break;
            }
            case 401: {
                index = 0;
                if (v0 != ValueNull.INSTANCE) {
                    asStr = true;
                    for (i = 0; i < args.length; ++i) {
                        values[i] = v = Function.getNullOrValue(session, args, values, i);
                        if (v == ValueNull.INSTANCE || v.getType() == 13) continue;
                        asStr = false;
                    }
                    v0s = asStr != false ? v0.getString() : null;
                    v0d = asStr != false ? 0.0 : v0.getDouble();
                    for (i = 1; i < args.length; ++i) {
                        v = Function.getNullOrValue(session, args, values, i);
                        if (v == ValueNull.INSTANCE || (!asStr || !v.getString().equals(v0s)) && (asStr || v.getDouble() != v0d)) continue;
                        index = i;
                        break;
                    }
                }
                result = ValueInt.get(index);
                break;
            }
            case 402: {
                bits = v0.getLong();
                on = Function.getNullOrValue(session, args, values, 1).getString();
                off = Function.getNullOrValue(session, args, values, 2).getString();
                sep = args.length > 3 ? Function.getNullOrValue(session, args, values, 3).getString() : ",";
                v0 = num = args.length > 4 ? Function.getNullOrValue(session, args, values, 4).getInt() : 64;
                if (num < 0 || num > 64) {
                    num = 64;
                }
                sb = new StringBuilder();
                for (i = 0; i < num; ++i) {
                    if (i > 0) {
                        sb.append(sep);
                    }
                    if ((bits >>> i & 1L) != 0L) {
                        sb.append(on);
                        continue;
                    }
                    sb.append(off);
                }
                result = ValueString.get(sb.toString());
                break;
            }
            case 403: {
                str = v0.getString();
                strList = Function.getNullOrValue(session, args, values, 1).getString();
                list = Arrays.asList(strList.split(","));
                result = ValueInt.get(list.indexOf(str) + 1);
                break;
            }
            case 404: {
                if (v0 == ValueNull.INSTANCE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                v1 = Function.getNullOrValue(session, args, values, 1);
                if (v1 == ValueNull.INSTANCE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                X = v0.getBigDecimal();
                D = v1.getInt();
                nf = NumberFormat.getInstance(Locale.US);
                nf.setGroupingUsed(true);
                nf.setMaximumFractionDigits(D);
                nf.setMinimumFractionDigits(D);
                result = ValueString.get(nf.format(X));
                break;
            }
            case 56: {
                result = ValueString.get(Function.hexToRaw(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 59: 
            case 75: {
                result = ValueString.get(v0.getString().toLowerCase(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 405: {
                if (v0 == ValueNull.INSTANCE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                bits = v0.getLong();
                num = args.length - 1 > 64 ? 64 : args.length - 1;
                sb = new StringBuilder();
                for (i = 0; i < num; ++i) {
                    v = Function.getNullOrValue(session, args, values, i + 1);
                    if (v == ValueNull.INSTANCE || (bits >>> i & 1L) == 0L) continue;
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(v.getString());
                }
                result = ValueString.get(sb.toString());
                break;
            }
            case 406: {
                result = ValueString.get(Function.convertLongToUnsigned(v0.getLong()).toString(8));
                break;
            }
            case 407: {
                s = v0.getString();
                if (s.length() == 0) {
                    result = ValueLong.get(0L);
                    break;
                }
                left = Character.valueOf(s.charAt(0));
                bytes = left.toString().getBytes();
                value = 0L;
                for (i = 0; i < bytes.length; ++i) {
                    value += (long)((bytes[i] & 255) << 8 * (bytes.length - 1 - i));
                }
                result = ValueLong.get(value);
                break;
            }
            case 408: {
                if (v0 == ValueNull.INSTANCE) {
                    result = ValueString.get("NULL");
                    break;
                }
                s = v0.getString();
                sb = new StringBuilder();
                sb.append('\'');
                for (i = 0; i < s.length(); ++i) {
                    c = s.charAt(i);
                    switch (c) {
                        case '\u0000': {
                            c = '0';
                        }
                        case '\u001a': 
                        case '\'': 
                        case '\\': {
                            sb.append('\\');
                        }
                    }
                    sb.append(c);
                }
                sb.append('\'');
                result = ValueString.get(sb.toString());
                break;
            }
            case 65: {
                result = ValueString.get(Function.rawToHex(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 409: {
                result = ValueString.get(new StringBuilder(v0.getString()).reverse().toString());
                break;
            }
            case 70: {
                result = ValueString.get(Function.getSoundex(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 71: {
                len = Math.max(0, v0.getInt());
                chars = new char[len];
                for (i = len - 1; i >= 0; --i) {
                    chars[i] = 32;
                }
                result = ValueString.get(new String(chars), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 410: {
                v1 = Function.getNullOrValue(session, args, values, 1);
                result = ValueInt.get(v0.getString().compareTo(v1.getString()));
                break;
            }
            case 411: {
                str = v0.getString();
                delim = Function.getNullOrValue(session, args, values, 1).getString();
                count = Function.getNullOrValue(session, args, values, 2).getInt();
                if (count > 0) {
                    from = 0;
                    while (from >= 0 && count > 0 && (from = str.indexOf(delim, from)) >= 0) {
                        if (--count <= 0) continue;
                        ++from;
                    }
                    if (from < 0) {
                        result = ValueString.get(str);
                        break;
                    }
                    result = ValueString.get(str.substring(0, from));
                    break;
                }
                if (count < 0) {
                    from = str.length() - 1;
                    while (from >= 0 && count < 0 && (from = str.lastIndexOf(delim, from)) >= 0) {
                        if (++count >= 0) continue;
                        --from;
                    }
                    if (from < 0) {
                        result = ValueString.get(str);
                        break;
                    }
                    result = ValueString.get(str.substring(from + 1));
                    break;
                }
                result = ValueString.get("");
                break;
            }
            case 74: 
            case 76: {
                result = ValueString.get(v0.getString().toUpperCase(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 412: {
                result = ValueString.get(java.util.UUID.randomUUID().toString());
                break;
            }
            case 79: {
                result = ValueString.get(StringUtils.javaEncode(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 80: {
                result = ValueString.get(StringUtils.javaDecode(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 81: {
                result = ValueBytes.getNoCopy(v0.getString().getBytes(Constants.UTF8));
                break;
            }
            case 82: {
                result = ValueString.get(new String(v0.getBytesNoCopy(), Constants.UTF8), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 85: {
                result = ValueString.get(StringUtils.xmlComment(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 86: {
                result = ValueString.get(StringUtils.xmlCData(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 87: {
                result = ValueString.get(StringUtils.xmlStartDoc(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 104: {
                dayName = new SimpleDateFormat("EEEE", Locale.ENGLISH);
                result = ValueString.get(dayName.format(v0.getDate()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 105: {
                result = ValueInt.get(DateTimeUtils.getDatePart(v0.getDate(), 5));
                break;
            }
            case 106: {
                result = ValueInt.get(DateTimeUtils.getDatePart(v0.getDate(), 7));
                break;
            }
            case 442: {
                cal = Calendar.getInstance();
                cal.setTime(v0.getDate());
                result = ValueInt.get((cal.get(7) + 5) % 7);
                break;
            }
            case 107: {
                result = ValueInt.get(DateTimeUtils.getDatePart(v0.getDate(), 6));
                break;
            }
            case 108: {
                expr = v0.getString();
                if (expr.contains("-")) {
                    result = ValueInt.get(DateTimeUtils.getDatePart(v0.getTimestamp(), 11));
                    break;
                }
                unit = expr.contains(".") != false ? "DAY_MICROSECOND" : "DAY_SECOND";
                time = Function.convertTimeUnit(unit, expr);
                result = ValueInt.get((int)(time[0] / 3600L));
                break;
            }
            case 109: {
                expr = v0.getString();
                if (expr.contains("-")) {
                    result = ValueInt.get(DateTimeUtils.getDatePart(v0.getTimestamp(), 12));
                    break;
                }
                result = ValueInt.get(DateTimeUtils.getDatePart(v0.getTime(), 12));
                break;
            }
            case 110: {
                expr = v0.getString();
                if (expr.contains("-00-")) {
                    result = ValueInt.get(0);
                    break;
                }
                result = ValueInt.get(DateTimeUtils.getDatePart(v0.getDate(), 2));
                break;
            }
            case 111: {
                monthName = new SimpleDateFormat("MMMM", Locale.ENGLISH);
                result = ValueString.get(monthName.format(v0.getDate()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 113: {
                result = ValueInt.get((DateTimeUtils.getDatePart(v0.getDate(), 2) - 1) / 3 + 1);
                break;
            }
            case 114: {
                expr = v0.getString();
                if (expr.contains("-")) {
                    result = ValueInt.get(DateTimeUtils.getDatePart(v0.getTimestamp(), 13));
                    break;
                }
                result = ValueInt.get(DateTimeUtils.getDatePart(v0.getTime(), 13));
                break;
            }
            case 428: {
                expr = v0.getString();
                if (!expr.contains(".")) {
                    result = ValueInt.get(0);
                    break;
                }
                if (expr.contains("-")) {
                    result = ValueInt.get(v0.getTimestamp().getNanos() / 1000);
                    break;
                }
                time = Function.convertTimeUnit("DAY_MICROSECOND", expr);
                result = ValueInt.get((int)time[1]);
                break;
            }
            case 115: {
                if (args.length == 1) {
                    result = ValueInt.get(Function.week(v0.getDate(), 0));
                    break;
                }
                mode = Function.getNullOrValue(session, args, values, 1).getInt();
                result = ValueInt.get(Function.week(v0.getDate(), mode));
                break;
            }
            case 443: {
                result = ValueInt.get(Function.week(v0.getDate(), 3));
                break;
            }
            case 116: {
                result = ValueInt.get(DateTimeUtils.getDatePart(v0.getDate(), 1));
                break;
            }
            case 123: {
                result = ValueInt.get(DateTimeUtils.getIsoYear(v0.getDate()));
                break;
            }
            case 124: {
                result = ValueInt.get(DateTimeUtils.getIsoWeek(v0.getDate()));
                break;
            }
            case 125: {
                result = ValueInt.get(DateTimeUtils.getIsoDayOfWeek(v0.getDate()));
                break;
            }
            case 100: 
            case 117: {
                now = session.getTransactionStart();
                result = ValueDate.fromMillis(now);
                break;
            }
            case 101: 
            case 118: {
                now = session.getTransactionStart();
                result = ValueTime.fromMillis(now);
                break;
            }
            case 112: 
            case 119: {
                now = session.getTransactionStart();
                vt = ValueTimestamp.fromMillis(now);
                if (v0 != null) {
                    mode = this.database.getMode();
                    vt = (ValueTimestamp)vt.convertScale(mode.convertOnlyToSmallerScale, v0.getInt());
                }
                result = vt;
                break;
            }
            case 421: {
                result = ValueDate.get(v0.getDate());
                break;
            }
            case 433: {
                result = ValueTime.get(new Time(v0.getTimestamp().getTime()));
                break;
            }
            case 422: {
                cal = new GregorianCalendar();
                cal.set(0, 0, 0, 0, 0, 0);
                cal.set(6, v0.getInt() + 1);
                result = ValueDate.get(new java.sql.Date(cal.getTimeInMillis()));
                break;
            }
            case 423: {
                date = new java.sql.Date(v0.getLong() * 1000L);
                fmt = args.length == 1 ? "%Y-%m-%d %H.%i.%s" : Function.getNullOrValue(session, args, values, 1).getString();
                result = ValueString.get(Function.dateFormat(date, fmt));
                break;
            }
            case 424: {
                fmt = Function.DATE_FORMATS.get(v0.getString() + "_" + Function.getNullOrValue(session, args, values, 1).getString());
                if (fmt == null) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueString.get(fmt);
                break;
            }
            case 425: {
                date = null;
                try {
                    date = v0.getDate();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (date == null) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                cal = Calendar.getInstance();
                cal.setTime(date);
                cal.set(2, cal.get(2) + 1);
                cal.set(5, 0);
                result = ValueDate.get(new java.sql.Date(cal.getTimeInMillis()));
                break;
            }
            case 426: {
                year = v0.getInt();
                day = Function.getNullOrValue(session, args, values, 1).getInt();
                if (day <= 0) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, day);
                result = ValueDate.get(new java.sql.Date(cal.getTimeInMillis()));
                break;
            }
            case 427: {
                hour = v0.getInt();
                minute = Function.getNullOrValue(session, args, values, 1).getInt();
                second = Function.getNullOrValue(session, args, values, 2).getFloat();
                cal = Calendar.getInstance();
                cal.set(11, hour);
                cal.set(12, minute);
                cal.set(13, (int)second);
                cal.set(14, (int)((second - (float)((int)second)) * 1000.0f));
                result = ValueTime.get(new Time(cal.getTimeInMillis()));
                break;
            }
            case 429: {
                p = Function.parsePeriod(v0.getInt());
                n = Function.getNullOrValue(session, args, values, 1).getInt();
                p.set(2, p.get(2) + n);
                result = ValueInt.get(p.get(1) * 100 + p.get(2) + 1);
                break;
            }
            case 430: {
                p1 = Function.parsePeriod(v0.getInt());
                p2 = Function.parsePeriod(Function.getNullOrValue(session, args, values, 1).getInt());
                result = ValueInt.get(p1.get(1) * 12 + p1.get(2) - p2.get(1) * 12 - p2.get(2));
                break;
            }
            case 431: {
                cal = Calendar.getInstance();
                cal.set(0, 0, 0, 0, 0, 0);
                cal.set(14, 0);
                cal.set(13, v0.getInt());
                result = ValueTime.get(new Time(cal.getTimeInMillis()));
                break;
            }
            case 437: {
                cal = Calendar.getInstance();
                cal.setTime(v0.getTime());
                seconds = cal.get(11) * 60 * 60 + cal.get(12) * 60 + cal.get(13);
                result = ValueInt.get(seconds);
                break;
            }
            case 438: {
                if (args.length == 0) {
                    result = ValueLong.get(System.currentTimeMillis() / 1000L);
                    break;
                }
                result = ValueLong.get(v0.getTimestamp().getTime() / 1000L);
                break;
            }
            case 439: {
                result = ValueDate.get(new java.sql.Date(System.currentTimeMillis() - (long)TimeZone.getDefault().getRawOffset()));
                break;
            }
            case 440: {
                result = ValueTime.get(new Time(System.currentTimeMillis() - (long)TimeZone.getDefault().getRawOffset()));
                break;
            }
            case 441: {
                result = ValueTimestamp.get(new Timestamp(System.currentTimeMillis() - (long)TimeZone.getDefault().getRawOffset()));
                break;
            }
            case 150: {
                result = ValueString.get(this.database.getShortName(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 151: 
            case 152: {
                result = ValueString.get(session.getUser().getName(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 153: {
                result = session.getLastIdentity();
                break;
            }
            case 154: {
                result = session.getLastScopeIdentity();
                break;
            }
            case 155: {
                result = ValueBoolean.get(session.getAutoCommit());
                break;
            }
            case 156: {
                result = ValueBoolean.get(this.database.isReadOnly());
                break;
            }
            case 157: {
                path = this.database.getDatabasePath();
                result = path == null ? ValueNull.INSTANCE : ValueString.get(path, this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 158: {
                result = ValueInt.get(session.getLockTimeout());
                break;
            }
            case 159: {
                result = ValueLong.get(Function.getDiskSpaceUsed(session, v0));
                break;
            }
            case 202: 
            case 203: {
                if (args.length == 1) {
                    v0 = v0.convertTo(this.dataType);
                    mode = this.database.getMode();
                    v0 = v0.convertScale(mode.convertOnlyToSmallerScale, this.scale);
                    result = v0 = v0.convertPrecision(this.getPrecision(), false);
                    break;
                }
                charset = Function.getNullOrValue(session, args, values, 1).getString();
                try {
                    result = ValueString.get(new String(v0.getBytes(), charset));
                }
                catch (UnsupportedEncodingException e) {
                    result = v0;
                }
                break;
            }
            case 212: {
                session.getUser().checkAdmin();
                result = ValueInt.get(Utils.getMemoryFree());
                break;
            }
            case 213: {
                session.getUser().checkAdmin();
                result = ValueInt.get(Utils.getMemoryUsed());
                break;
            }
            case 214: {
                result = ValueInt.get(this.database.getLockMode());
                break;
            }
            case 215: {
                result = ValueString.get(session.getCurrentSchemaName(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 216: {
                result = ValueInt.get(session.getId());
                break;
            }
            case 200: {
                result = v0;
                if (v0 != ValueNull.INSTANCE) break;
                result = Function.getNullOrValue(session, args, values, 1);
                break;
            }
            case 201: {
                v = v0 == ValueNull.INSTANCE || v0.getBoolean() == false ? Function.getNullOrValue(session, args, values, 2) : Function.getNullOrValue(session, args, values, 1);
                result = v.convertTo(this.dataType);
                break;
            }
            case 229: {
                index = -1;
                len = args.length - 1;
                for (i = 1; i < len; i += 2) {
                    if (!this.database.areEqual(v0, Function.getNullOrValue(session, args, values, i))) continue;
                    index = i + 1;
                    break;
                }
                if (index < 0 && args.length % 2 == 0) {
                    index = args.length - 1;
                }
                v = index < 0 ? ValueNull.INSTANCE : Function.getNullOrValue(session, args, values, index);
                result = v.convertTo(this.dataType);
                break;
            }
            case 228: {
                v = v0 == ValueNull.INSTANCE ? Function.getNullOrValue(session, args, values, 2) : Function.getNullOrValue(session, args, values, 1);
                result = v.convertTo(this.dataType);
                break;
            }
            case 204: {
                result = v0;
                for (i = 0; i < args.length; ++i) {
                    v = Function.getNullOrValue(session, args, values, i);
                    if (v == ValueNull.INSTANCE) continue;
                    result = v.convertTo(this.dataType);
                    break block2;
                }
                break;
            }
            case 219: 
            case 220: {
                result = ValueNull.INSTANCE;
                for (i = 0; i < args.length; ++i) {
                    v = Function.getNullOrValue(session, args, values, i);
                    if (v == ValueNull.INSTANCE) continue;
                    v = v.convertTo(this.dataType);
                    if (result == ValueNull.INSTANCE) {
                        result = v;
                        continue;
                    }
                    comp = this.database.compareTypeSafe(result, v);
                    if (this.info.type == 219 && comp < 0) {
                        result = v;
                        continue;
                    }
                    if (this.info.type != 220 || comp <= 0) continue;
                    result = v;
                }
                break;
            }
            case 206: {
                then = null;
                if (v0 != null) ** GOTO lbl736
                len = args.length - 1;
                for (i = 1; i < len; i += 2) {
                    when = args[i].getValue(session);
                    if (when == ValueNull.INSTANCE || !when.getBoolean().booleanValue()) continue;
                    then = args[i + 1];
                    ** GOTO lbl743
                }
                ** GOTO lbl743
lbl736:
                // 1 sources

                if (v0 != ValueNull.INSTANCE) {
                    len = args.length - 1;
                    for (i = 1; i < len; i += 2) {
                        when = args[i].getValue(session);
                        if (!this.database.areEqual(v0, when)) continue;
                        then = args[i + 1];
                        break;
                    }
                }
lbl743:
                // 6 sources

                if (then == null && args.length % 2 == 0) {
                    then = args[args.length - 1];
                }
                v = then == null ? ValueNull.INSTANCE : then.getValue(session);
                result = v.convertTo(this.dataType);
                break;
            }
            case 209: {
                if (v0.getType() == 17) {
                    v1 = Function.getNullOrValue(session, args, values, 1);
                    element = v1.getInt();
                    list = ((ValueArray)v0).getList();
                    if (element < 1 || element > list.length) {
                        result = ValueNull.INSTANCE;
                        break;
                    }
                    result = list[element - 1];
                    break;
                }
                result = ValueNull.INSTANCE;
                break;
            }
            case 217: {
                if (v0.getType() == 17) {
                    list = ((ValueArray)v0).getList();
                    result = ValueInt.get(list.length);
                    break;
                }
                result = ValueNull.INSTANCE;
                break;
            }
            case 230: {
                result = ValueBoolean.get(false);
                if (v0.getType() != 17) break;
                v1 = Function.getNullOrValue(session, args, values, 1);
                for (Value v : list = ((ValueArray)v0).getList()) {
                    if (!v.equals(v1)) continue;
                    result = ValueBoolean.get(true);
                    break block2;
                }
                break;
            }
            case 221: {
                result = ValueBoolean.get(Function.cancelStatement(session, v0.getInt()));
                break;
            }
            case 226: {
                result = session.getTransactionId();
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private static boolean cancelStatement(Session session, int targetSessionId) {
        Session[] sessions;
        session.getUser().checkAdmin();
        for (Session s : sessions = session.getDatabase().getSessions(false)) {
            if (s.getId() != targetSessionId) continue;
            Command c = s.getCurrentCommand();
            if (c == null) {
                return false;
            }
            c.cancel();
            return true;
        }
        return false;
    }

    private static long getDiskSpaceUsed(Session session, Value v0) {
        Parser p = new Parser(session);
        String sql = v0.getString();
        Table table = p.parseTableName(sql);
        return table.getDiskSpaceUsed();
    }

    private static Value getNullOrValue(Session session, Expression[] args, Value[] values, int i) {
        if (i >= args.length) {
            return null;
        }
        Value v = values[i];
        if (v == null) {
            Expression e = args[i];
            if (e == null) {
                return null;
            }
            v = values[i] = e.getValue(session);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value getValueWithArgs(Session session, Expression[] args) {
        Value result;
        Value v0;
        Value resultSimple;
        Value[] values = new Value[args.length];
        if (this.info.nullIfParameterIsNull) {
            for (int i = 0; i < args.length; ++i) {
                Expression e = args[i];
                Value v = e.getValue(session);
                if (v == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                values[i] = v;
            }
        }
        if ((resultSimple = this.getSimpleValue(session, v0 = Function.getNullOrValue(session, args, values, 0), args, values)) != null) {
            return resultSimple;
        }
        Value v1 = Function.getNullOrValue(session, args, values, 1);
        Value v2 = Function.getNullOrValue(session, args, values, 2);
        Value v3 = Function.getNullOrValue(session, args, values, 3);
        Value v4 = Function.getNullOrValue(session, args, values, 4);
        Value v5 = Function.getNullOrValue(session, args, values, 5);
        block6 : switch (this.info.type) {
            case 3: {
                if (args.length == 1) {
                    result = ValueDouble.get(Math.atan(v0.getDouble()));
                    break;
                }
            }
            case 4: {
                result = ValueDouble.get(Math.atan2(v0.getDouble(), v1.getDouble()));
                break;
            }
            case 5: {
                result = ValueLong.get(v0.getLong() & v1.getLong());
                break;
            }
            case 6: {
                result = ValueLong.get(v0.getLong() | v1.getLong());
                break;
            }
            case 7: {
                result = ValueLong.get(v0.getLong() ^ v1.getLong());
                break;
            }
            case 16: {
                if (v0.getType() == 6 || v1.getType() == 6 || v0.getType() == 7 || v1.getType() == 7 || v0.getType() == 8 || v1.getType() == 8) {
                    double x = v1.getDouble();
                    if (x == 0.0) {
                        result = ValueNull.INSTANCE;
                        break;
                    }
                    result = ValueDouble.get(v0.getDouble() % x);
                    break;
                }
                long x = v1.getLong();
                if (x == 0L) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueLong.get(v0.getLong() % x);
                break;
            }
            case 18: {
                result = ValueDouble.get(Math.pow(v0.getDouble(), v1.getDouble()));
                break;
            }
            case 21: {
                double f = v1 == null ? 1.0 : Math.pow(10.0, v1.getDouble());
                result = ValueDouble.get((double)Math.round(v0.getDouble() * f) / f);
                break;
            }
            case 40: {
                String num = v0.getString();
                int from = v1.getInt();
                int to = v2.getInt();
                result = ValueString.get(Function.convert(num, from, to));
                break;
            }
            case 27: {
                if (v0.getType() == 11) {
                    Timestamp d = v0.getTimestamp();
                    Calendar c = Calendar.getInstance();
                    c.setTime(d);
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    result = ValueTimestamp.fromMillis(c.getTimeInMillis());
                    break;
                }
                if (v0.getType() == 10) {
                    ValueDate vd = (ValueDate)v0;
                    Calendar c = Calendar.getInstance();
                    c.setTime(vd.getDate());
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    result = ValueTimestamp.fromMillis(c.getTimeInMillis());
                    break;
                }
                if (v0.getType() == 13) {
                    ValueString vd = (ValueString)v0;
                    Calendar c = Calendar.getInstance();
                    c.setTime(ValueTimestamp.parse(vd.getString()).getDate());
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    result = ValueTimestamp.fromMillis(c.getTimeInMillis());
                    break;
                }
                double d = v0.getDouble();
                int p = v1 == null ? 0 : v1.getInt();
                double f = Math.pow(10.0, p);
                double g = d * f;
                result = ValueDouble.get((d < 0.0 ? Math.ceil(g) : Math.floor(g)) / f);
                break;
            }
            case 29: {
                result = ValueBytes.getNoCopy(Function.getHash(v0.getString(), v1.getBytesNoCopy(), v2.getInt()));
                break;
            }
            case 30: {
                result = ValueBytes.getNoCopy(Function.encrypt(v0.getString(), v1.getBytesNoCopy(), v2.getBytesNoCopy()));
                break;
            }
            case 31: {
                result = ValueBytes.getNoCopy(Function.decrypt(v0.getString(), v1.getBytesNoCopy(), v2.getBytesNoCopy()));
                break;
            }
            case 32: {
                String algorithm = null;
                if (v1 != null) {
                    algorithm = v1.getString();
                }
                result = ValueBytes.getNoCopy(CompressTool.getInstance().compress(v0.getBytesNoCopy(), algorithm));
                break;
            }
            case 55: {
                result = ValueInt.get(Function.getDifference(v0.getString(), v1.getString()));
                break;
            }
            case 57: {
                result = ValueString.get(Function.insert(v0.getString(), v1.getInt(), v2.getInt(), v3.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 60: {
                result = ValueString.get(Function.left(v0.getString(), v1.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 62: {
                int start = v2 == null ? 0 : v2.getInt();
                result = ValueInt.get(Function.locate(v0.getString(), v1.getString(), start));
                break;
            }
            case 58: {
                int start = v2 == null ? 0 : v2.getInt();
                result = ValueInt.get(Function.locate(v1.getString(), v0.getString(), start));
                break;
            }
            case 66: {
                int count = Math.max(0, v1.getInt());
                result = ValueString.get(Function.repeat(v0.getString(), count), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 67: {
                String s0 = v0.getString();
                String s1 = v1.getString();
                String s2 = v2 == null ? "" : v2.getString();
                result = ValueString.get(Function.replace(s0, s1, s2), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 68: {
                result = ValueString.get(Function.right(v0.getString(), v1.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 63: {
                result = ValueString.get(StringUtils.trim(v0.getString(), true, false, v1 == null ? " " : v1.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 78: {
                result = ValueString.get(StringUtils.trim(v0.getString(), true, true, v1 == null ? " " : v1.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 69: {
                result = ValueString.get(StringUtils.trim(v0.getString(), false, true, v1 == null ? " " : v1.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 72: 
            case 73: {
                String s = v0.getString();
                int offset = v1.getInt();
                if (offset < 0) {
                    offset = s.length() + offset + 1;
                }
                int length = v2 == null ? s.length() : v2.getInt();
                result = ValueString.get(Function.substring(s, offset, length), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 77: {
                result = ValueInt.get(Function.locate(v0.getString(), v1.getString(), 0));
                break;
            }
            case 83: {
                result = ValueString.get(StringUtils.xmlAttr(v0.getString(), v1.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 84: {
                String attr;
                String string = v1 == null ? null : (attr = v1 == ValueNull.INSTANCE ? null : v1.getString());
                String content = v2 == null ? null : (v2 == ValueNull.INSTANCE ? null : v2.getString());
                boolean indent = v3 == null ? true : v3.getBoolean();
                result = ValueString.get(StringUtils.xmlNode(v0.getString(), attr, content, indent), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 89: {
                String regexp = v1.getString();
                String replacement = v2.getString();
                try {
                    result = ValueString.get(v0.getString().replaceAll(regexp, replacement), this.database.getMode().treatEmptyStringsAsNull);
                    break;
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw DbException.get(22025, e, replacement);
                }
                catch (PatternSyntaxException e) {
                    throw DbException.get(22025, e, regexp);
                }
                catch (IllegalArgumentException e) {
                    throw DbException.get(22025, e, replacement);
                }
            }
            case 90: {
                result = ValueString.get(StringUtils.pad(v0.getString(), v1.getInt(), v2 == null ? null : v2.getString(), true), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 91: {
                int len = v1.getInt();
                if (len < 0) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                result = ValueString.get(StringUtils.pad(v0.getString(), v1.getInt(), v2 == null ? null : v2.getString(), false), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 95: {
                result = ValueLong.get(Function.oraHash(v0.getString(), v1 == null ? null : Integer.valueOf(v1.getInt()), v2 == null ? null : Integer.valueOf(v2.getInt())).intValue());
                break;
            }
            case 93: {
                switch (v0.getType()) {
                    case 9: 
                    case 10: 
                    case 11: {
                        result = ValueString.get(ToChar.toChar(v0.getTimestamp(), v1 == null ? null : v1.getString(), v2 == null ? null : v2.getString()), this.database.getMode().treatEmptyStringsAsNull);
                        break block6;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        result = ValueString.get(ToChar.toChar(v0.getBigDecimal(), v1 == null ? null : v1.getString(), v2 == null ? null : v2.getString()), this.database.getMode().treatEmptyStringsAsNull);
                        break block6;
                    }
                }
                result = ValueString.get(v0.getString(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 94: {
                String matching = v1.getString();
                String replacement = v2.getString();
                result = ValueString.get(Function.translate(v0.getString(), matching, replacement), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 231: {
                result = ValueString.get(Constants.getVersion(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 102: {
                result = ValueTimestamp.get(Function.dateadd(v0.getString(), v1.getLong(), v2.getTimestamp()));
                break;
            }
            case 415: 
            case 416: 
            case 417: 
            case 418: {
                boolean sub;
                boolean bl = sub = this.info.type == 418 || this.info.type == 417;
                if (args.length == 2) {
                    result = ValueTimestamp.get(Function.dateadd("DAY", sub ? -v1.getLong() : v1.getLong(), v0.getTimestamp()));
                    if (v0.getString().contains(":")) break;
                    result = result.convertTo(10);
                    break;
                }
                String unit = v2.getString();
                long[] diff = Function.convertTimeUnit(unit, v1.getString());
                if (diff == null) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                if (diff[1] != 0L) {
                    if (sub) {
                        diff[0] = -diff[0];
                        diff[1] = -diff[1];
                    }
                    Timestamp ts = Function.addTimestamp(v0.getTimestamp(), diff);
                    result = ValueTimestamp.get(ts);
                    break;
                }
                result = ValueTimestamp.get(Function.dateadd(unit, sub ? -diff[0] : diff[0], v0.getTimestamp()));
                if (v0.getString().contains(":") || unit.contains("HOUR") || unit.contains("MINUTE") || unit.contains("SECOND")) break;
                result = result.convertTo(10);
                break;
            }
            case 419: 
            case 420: {
                long[] diff = Function.convertTimeUnit("DAY_MICROSECOND", v1.getString());
                if (diff == null) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                if (this.info.type == 420) {
                    diff[0] = -diff[0];
                    diff[1] = -diff[1];
                }
                if (v0.getString().contains("-")) {
                    Timestamp ts = Function.addTimestamp(v0.getTimestamp(), diff);
                    result = ValueTimestamp.get(ts);
                    break;
                }
                long[] base = Function.convertTimeUnit("DAY_MICROSECOND", v0.getString());
                if (base == null) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                boolean neg = Function.timeadd(base, diff);
                String out = String.format("%02d:%02d:%02d.%06d", base[0] / 3600L, base[0] % 3600L / 60L, base[0] % 60L, base[1]);
                result = ValueString.get(neg ? "-" + out : out);
                break;
            }
            case 103: {
                if (args.length == 2) {
                    result = ValueLong.get(Function.datediff("DATE", v1.getTimestamp(), v0.getTimestamp()));
                    break;
                }
                result = ValueLong.get(Function.datediff(v0.getString(), v1.getTimestamp(), v2.getTimestamp()));
                break;
            }
            case 434: {
                long[] base = Function.timestamp2us(v0.getTimestamp());
                long[] diff = Function.timestamp2us(v1.getTimestamp());
                diff[0] = -diff[0];
                diff[1] = -diff[1];
                boolean neg = Function.timeadd(base, diff);
                String out = String.format("%02d:%02d:%02d.%06d", base[0] / 3600L, base[0] % 3600L / 60L, base[0] % 60L, base[1]);
                result = ValueString.get(neg ? "-" + out : out);
                break;
            }
            case 435: {
                if (args.length == 1) {
                    result = ValueTimestamp.get(v0.getTimestamp());
                    break;
                }
                Calendar base = Calendar.getInstance();
                base.setTime(v0.getTimestamp());
                Calendar diff = Calendar.getInstance();
                diff.setTime(v1.getTime());
                base.set(11, base.get(11) + diff.get(11));
                base.set(12, base.get(12) + diff.get(12));
                base.set(13, base.get(13) + diff.get(13));
                result = ValueTimestamp.get(new Timestamp(base.getTimeInMillis()));
                break;
            }
            case 120: {
                int field = Function.getDatePart2(v0.getString());
                result = ValueInt.get(DateTimeUtils.getDatePart(v1.getTimestamp(), field));
                break;
            }
            case 121: {
                String locale;
                if (v0 == ValueNull.INSTANCE || v1 == ValueNull.INSTANCE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                String string = v2 == null ? null : (locale = v2 == ValueNull.INSTANCE ? null : v2.getString());
                String tz = v3 == null ? null : (v3 == ValueNull.INSTANCE ? null : v3.getString());
                result = ValueString.get(DateTimeUtils.formatDateTime(v0.getTimestamp(), v1.getString(), locale, tz), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 122: {
                String locale;
                if (v0 == ValueNull.INSTANCE || v1 == ValueNull.INSTANCE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                String string = v2 == null ? null : (locale = v2 == ValueNull.INSTANCE ? null : v2.getString());
                String tz = v3 == null ? null : (v3 == ValueNull.INSTANCE ? null : v3.getString());
                Date d = DateTimeUtils.parseDateTime(v0.getString(), v1.getString(), locale, tz);
                result = ValueTimestamp.fromMillis(d.getTime());
                break;
            }
            case 126: {
                result = ValueString.get(Function.dateFormat(v0.getTimestamp(), v1.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 436: {
                result = ValueString.get(Function.dateFormat(v0.getTime(), v1.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 432: {
                Date date = Function.strToDate(v0.getString(), v1.getString());
                if (date instanceof Timestamp) {
                    result = ValueTimestamp.get((Timestamp)date);
                    break;
                }
                if (date instanceof java.sql.Date) {
                    result = ValueDate.get((java.sql.Date)date);
                    break;
                }
                if (date instanceof Time) {
                    result = ValueTime.get((Time)date);
                    break;
                }
                result = ValueNull.INSTANCE;
                break;
            }
            case 205: {
                result = this.database.areEqual(v0, v1) ? ValueNull.INSTANCE : v0;
                break;
            }
            case 207: {
                Sequence sequence = this.getSequence(session, v0, v1);
                SequenceValue value = new SequenceValue(sequence);
                result = value.getValue(session);
                break;
            }
            case 208: {
                Sequence sequence = this.getSequence(session, v0, v1);
                result = ValueLong.get(sequence.getCurrentValue());
                break;
            }
            case 210: {
                String fileName = v0.getString();
                String columnList = v1 == null ? null : v1.getString();
                Csv csv = new Csv();
                String options = v2 == null ? null : v2.getString();
                String charset = null;
                if (options != null && options.indexOf(61) >= 0) {
                    charset = csv.setOptions(options);
                } else {
                    charset = options;
                    String fieldSeparatorRead = v3 == null ? null : v3.getString();
                    String fieldDelimiter = v4 == null ? null : v4.getString();
                    String escapeCharacter = v5 == null ? null : v5.getString();
                    Value v6 = Function.getNullOrValue(session, args, values, 6);
                    String nullString = v6 == null ? null : v6.getString();
                    Function.setCsvDelimiterEscape(csv, fieldSeparatorRead, fieldDelimiter, escapeCharacter);
                    csv.setNullString(nullString);
                }
                char fieldSeparator = csv.getFieldSeparatorRead();
                String[] columns = StringUtils.arraySplit(columnList, fieldSeparator, true);
                try {
                    ValueResultSet vr = ValueResultSet.get(csv.read(fileName, columns, charset));
                    result = vr;
                    break;
                }
                catch (SQLException e) {
                    throw DbException.convert(e);
                }
            }
            case 218: {
                session.getUser().checkAdmin();
                JdbcConnection conn = session.createConnection(false);
                ResultSet rs = LinkSchema.linkSchema(conn, v0.getString(), v1.getString(), v2.getString(), v3.getString(), v4.getString(), v5.getString());
                result = ValueResultSet.get(rs);
                break;
            }
            case 211: {
                session.getUser().checkAdmin();
                JdbcConnection conn = session.createConnection(false);
                Csv csv = new Csv();
                String options = v2 == null ? null : v2.getString();
                String charset = null;
                if (options != null && options.indexOf(61) >= 0) {
                    charset = csv.setOptions(options);
                } else {
                    charset = options;
                    String fieldSeparatorWrite = v3 == null ? null : v3.getString();
                    String fieldDelimiter = v4 == null ? null : v4.getString();
                    String escapeCharacter = v5 == null ? null : v5.getString();
                    Value v6 = Function.getNullOrValue(session, args, values, 6);
                    String nullString = v6 == null ? null : v6.getString();
                    Value v7 = Function.getNullOrValue(session, args, values, 7);
                    String lineSeparator = v7 == null ? null : v7.getString();
                    Function.setCsvDelimiterEscape(csv, fieldSeparatorWrite, fieldDelimiter, escapeCharacter);
                    csv.setNullString(nullString);
                    if (lineSeparator != null) {
                        csv.setLineSeparator(lineSeparator);
                    }
                }
                try {
                    int rows = csv.write(conn, v0.getString(), v1.getString(), charset);
                    result = ValueInt.get(rows);
                    break;
                }
                catch (SQLException e) {
                    throw DbException.convert(e);
                }
            }
            case 222: {
                Variable var = (Variable)args[0];
                session.setVariable(var.getName(), v1);
                result = v1;
                break;
            }
            case 225: {
                session.getUser().checkAdmin();
                String fileName = v0.getString();
                boolean blob = args.length == 1;
                try {
                    AutoCloseInputStream in = new AutoCloseInputStream(FileUtils.newInputStream(fileName));
                    if (blob) {
                        result = this.database.getLobStorage().createBlob(in, -1L);
                    } else {
                        InputStreamReader reader = v1 == ValueNull.INSTANCE ? new InputStreamReader(in) : new InputStreamReader((InputStream)in, v1.getString());
                        result = this.database.getLobStorage().createClob(reader, -1L);
                    }
                    session.addTemporaryLob(result);
                    break;
                }
                catch (IOException e) {
                    throw DbException.convertIOException(e, fileName);
                }
            }
            case 232: {
                session.getUser().checkAdmin();
                result = ValueNull.INSTANCE;
                String fileName = v1.getString();
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(fileName);
                    InputStream in = v0.getInputStream();
                    try {
                        result = ValueLong.get(IOUtils.copyAndClose(in, fileOutputStream));
                        break;
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException e) {
                    throw DbException.convertIOException(e, fileName);
                }
            }
            case 227: {
                result = v0.convertPrecision(v1.getLong(), v2.getBoolean());
                break;
            }
            case 88: {
                if (v1 == null) {
                    result = ValueString.get(StringUtils.xmlText(v0.getString()), this.database.getMode().treatEmptyStringsAsNull);
                    break;
                }
                result = ValueString.get(StringUtils.xmlText(v0.getString(), v1.getBoolean()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 250: {
                result = session.getVariable(args[0].getSchemaName() + "." + args[0].getTableName() + "." + args[0].getColumnName());
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.info.type);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Sequence getSequence(Session session, Value v0, Value v1) {
        Sequence seq;
        Schema s;
        String sequenceName;
        String schemaName;
        if (v1 == null) {
            Parser p = new Parser(session);
            String sql = v0.getString();
            Expression expr = p.parseExpression(sql);
            if (!(expr instanceof ExpressionColumn)) throw DbException.getSyntaxError(sql, 1);
            ExpressionColumn seq2 = (ExpressionColumn)expr;
            schemaName = seq2.getOriginalTableAliasName();
            if (schemaName == null) {
                schemaName = session.getCurrentSchemaName();
                sequenceName = sql;
            } else {
                sequenceName = seq2.getColumnName();
            }
        } else {
            schemaName = v0.getString();
            sequenceName = v1.getString();
        }
        if ((s = this.database.findSchema(schemaName)) == null) {
            schemaName = StringUtils.toUpperEnglish(schemaName);
            s = this.database.getSchema(schemaName);
        }
        if ((seq = s.findSequence(sequenceName)) != null) return seq;
        sequenceName = StringUtils.toUpperEnglish(sequenceName);
        return s.getSequence(sequenceName);
    }

    private static long length(Value v) {
        switch (v.getType()) {
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                return v.getPrecision();
            }
        }
        return v.getString().length();
    }

    private static byte[] getPaddedArrayCopy(byte[] data, int blockSize) {
        int size = MathUtils.roundUpInt(data.length, blockSize);
        byte[] newData = DataUtils.newBytes(size);
        System.arraycopy(data, 0, newData, 0, data.length);
        return newData;
    }

    private static byte[] decrypt(String algorithm, byte[] key, byte[] data) {
        BlockCipher cipher = CipherFactory.getBlockCipher(algorithm);
        byte[] newKey = Function.getPaddedArrayCopy(key, cipher.getKeyLength());
        cipher.setKey(newKey);
        byte[] newData = Function.getPaddedArrayCopy(data, 16);
        cipher.decrypt(newData, 0, newData.length);
        return newData;
    }

    private static byte[] encrypt(String algorithm, byte[] key, byte[] data) {
        BlockCipher cipher = CipherFactory.getBlockCipher(algorithm);
        byte[] newKey = Function.getPaddedArrayCopy(key, cipher.getKeyLength());
        cipher.setKey(newKey);
        byte[] newData = Function.getPaddedArrayCopy(data, 16);
        cipher.encrypt(newData, 0, newData.length);
        return newData;
    }

    private static byte[] getHash(String algorithm, byte[] bytes, int iterations) {
        if (!"SHA256".equalsIgnoreCase(algorithm)) {
            throw DbException.getInvalidValueException("algorithm", algorithm);
        }
        for (int i = 0; i < iterations; ++i) {
            bytes = SHA256.getHash(bytes, false);
        }
        return bytes;
    }

    public static boolean isDatePart(String part) {
        Integer p = DATE_PART.get(StringUtils.toUpperEnglish(part));
        return p != null;
    }

    private static int getDatePart(String part) {
        Integer p = DATE_PART.get(StringUtils.toUpperEnglish(part));
        if (p == null) {
            throw DbException.getInvalidValueException("date part", part);
        }
        if (p < 0) {
            p = DATE_PART_TRANS.get(p);
        }
        return p;
    }

    private static int getDatePart2(String part) {
        Integer p = DATE_PART.get(StringUtils.toUpperEnglish(part));
        if (p == null) {
            throw DbException.getInvalidValueException("date part", part);
        }
        return p;
    }

    private static Timestamp dateadd(String part, long count, Timestamp d) {
        int field = Function.getDatePart(part);
        if (field == 14) {
            Timestamp ts = new Timestamp(d.getTime() + count);
            ts.setNanos(ts.getNanos() + d.getNanos() % 1000000);
            return ts;
        }
        if (count > Integer.MAX_VALUE) {
            throw DbException.getInvalidValueException("DATEADD count", count);
        }
        Calendar calendar = Calendar.getInstance();
        int nanos = d.getNanos() % 1000000;
        calendar.setTime(d);
        calendar.add(field, (int)count);
        long t = calendar.getTime().getTime();
        Timestamp ts = new Timestamp(t);
        ts.setNanos(ts.getNanos() + nanos);
        return ts;
    }

    private static Timestamp addTimestamp(Timestamp src, long[] diff) {
        Timestamp ts = new Timestamp(src.getTime() + diff[0] * 1000L + diff[1] / 1000L);
        long nanos = ts.getNanos() + src.getNanos() % 1000000 + (int)(diff[1] % 1000L * 1000L);
        ts.setTime(ts.getTime() + nanos / 1000000000L * 1000L);
        ts.setNanos((int)(nanos % 1000000000L));
        return ts;
    }

    private static long[] convertTimeUnit(String unit, String expr) {
        int sign = expr.charAt(0) == '-' ? -1 : 1;
        String[] arr = expr.replaceAll(":", " ").replaceAll("\\.", " ").replaceAll("-", " ").trim().split(" ");
        long[] value = new long[2];
        value[1] = 0L;
        value[0] = 0L;
        if (unit.equals("SECOND_MICROSECOND")) {
            if (arr.length != 2) {
                return null;
            }
            value[0] = Long.parseLong(arr[0]);
            value[1] = Long.parseLong(arr[1]);
        } else if (unit.equals("MINUTE_MICROSECOND")) {
            if (arr.length < 1 || arr.length > 3) {
                return null;
            }
            long[] tgt = Function.parseTimePart(arr, 3, true);
            value[0] = 60L * tgt[0] + tgt[1];
            value[1] = tgt[2];
        } else if (unit.equals("MINUTE_SECOND")) {
            if (arr.length < 1 || arr.length > 2) {
                return null;
            }
            long[] tgt = Function.parseTimePart(arr, 2, false);
            value[0] = 60L * tgt[0] + tgt[1];
        } else if (unit.equals("HOUR_MICROSECOND")) {
            if (arr.length < 1 || arr.length > 4) {
                return null;
            }
            long[] tgt = Function.parseTimePart(arr, 4, true);
            value[0] = 3600L * tgt[0] + 60L * tgt[1] + tgt[2];
            value[1] = tgt[3];
        } else if (unit.equals("HOUR_SECOND")) {
            if (arr.length < 1 || arr.length > 3) {
                return null;
            }
            long[] tgt = Function.parseTimePart(arr, 3, false);
            value[0] = 3600L * tgt[0] + 60L * tgt[1] + tgt[2];
        } else if (unit.equals("HOUR_MINUTE")) {
            if (arr.length < 1 || arr.length > 2) {
                return null;
            }
            long[] tgt = Function.parseTimePart(arr, 2, false);
            value[0] = 60L * tgt[0] + tgt[1];
        } else if (unit.equals("DAY_MICROSECOND")) {
            if (arr.length < 1 || arr.length > 5) {
                return null;
            }
            long[] tgt = Function.parseTimePart(arr, 5, true);
            value[0] = 86400L * tgt[0] + 3600L * tgt[1] + 60L * tgt[2] + tgt[3];
            value[1] = tgt[4];
        } else if (unit.equals("DAY_SECOND")) {
            if (arr.length < 1 || arr.length > 4) {
                return null;
            }
            long[] tgt = Function.parseTimePart(arr, 4, false);
            value[0] = 86400L * tgt[0] + 3600L * tgt[1] + 60L * tgt[2] + tgt[3];
        } else if (unit.equals("DAY_MINUTE")) {
            if (arr.length < 1 || arr.length > 3) {
                return null;
            }
            long[] tgt = Function.parseTimePart(arr, 3, false);
            value[0] = 1440L * tgt[0] + 60L * tgt[1] + tgt[2];
        } else if (unit.equals("DAY_HOUR")) {
            if (arr.length < 1 || arr.length > 2) {
                return null;
            }
            long[] tgt = Function.parseTimePart(arr, 2, false);
            value[0] = 24L * tgt[0] + tgt[1];
        } else if (unit.equals("YEAR_MONTH")) {
            if (arr.length < 1 || arr.length > 2) {
                return null;
            }
            long[] tgt = Function.parseTimePart(arr, 2, false);
            value[0] = 12L * tgt[0] + tgt[1];
        } else {
            value[0] = unit.equals("QUARTER") ? 3L * Long.parseLong(arr[0]) : Long.parseLong(arr[0]);
        }
        if (sign < 0) {
            value[0] = -value[0];
            value[1] = -value[1];
        }
        return value;
    }

    private static long[] parseTimePart(String[] arr, int size, boolean micro) {
        long[] tgt = new long[size];
        Arrays.fill(tgt, 0L);
        int i = arr.length - 1;
        for (int j = tgt.length - 1; i >= 0 && j >= 0; --i, --j) {
            String src = arr[i];
            if (micro && i == arr.length - 1) {
                if (src.length() < 6) {
                    src = (src + "000000").substring(0, 6);
                } else if (src.length() > 6) {
                    double d;
                    for (d = Double.parseDouble(src); d >= 1000000.0; d /= 10.0) {
                    }
                    tgt[j] = Math.round(d);
                    continue;
                }
            }
            tgt[j] = Long.parseLong(src);
        }
        return tgt;
    }

    private static Calendar parsePeriod(int period) {
        int year = period / 100;
        if (year >= 0 && year < 70) {
            year += 2000;
        } else if (year >= 70 && year < 100) {
            year += 1900;
        }
        int month = period % 100;
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, 0, 0, 0, 0);
        return cal;
    }

    private static boolean timeadd(long[] base, long[] diff) {
        base[0] = base[0] + diff[0];
        base[1] = base[1] + diff[1];
        base[0] = base[0] + base[1] / 1000000L;
        base[1] = base[1] % 1000000L;
        if (base[0] > 0L && base[1] < 0L) {
            base[0] = base[0] - 1L;
            base[1] = base[1] + 1000000L;
        } else if (base[0] < 0L && base[1] > 0L) {
            base[0] = base[0] + 1L;
            base[1] = base[1] - 1000000L;
        }
        boolean neg = base[0] < 0L || base[1] < 0L;
        base[0] = Math.abs(base[0]);
        base[1] = Math.abs(base[1]);
        return neg;
    }

    private static long[] timestamp2us(Timestamp ts) {
        long[] time = new long[]{ts.getTime() / 1000L, ts.getTime() % 1000L * 1000L + (long)(ts.getNanos() % 1000000 / 1000)};
        return time;
    }

    private static long datediff(String part, Timestamp d1, Timestamp d2) {
        int field = Function.getDatePart(part);
        Calendar calendar = Calendar.getInstance();
        long t1 = d1.getTime();
        long t2 = d2.getTime();
        TimeZone zone = calendar.getTimeZone();
        calendar.setTime(d1);
        t1 += (long)zone.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        calendar.setTime(d2);
        t2 += (long)zone.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        switch (field) {
            case 14: {
                return t2 - t1;
            }
            case 11: 
            case 12: 
            case 13: {
                long hour = 3600000L;
                long add = Math.min(t1 / hour * hour, t2 / hour * hour);
                t1 -= add;
                t2 -= add;
                switch (field) {
                    case 13: {
                        return t2 / 1000L - t1 / 1000L;
                    }
                    case 12: {
                        return t2 / 60000L - t1 / 60000L;
                    }
                    case 11: {
                        return t2 / hour - t1 / hour;
                    }
                }
                throw DbException.throwInternalError("field:" + field);
            }
            case 5: {
                return t2 / 86400000L - t1 / 86400000L;
            }
        }
        calendar.setTimeInMillis(t1);
        int year1 = calendar.get(1);
        int month1 = calendar.get(2);
        calendar.setTimeInMillis(t2);
        int year2 = calendar.get(1);
        int month2 = calendar.get(2);
        int result = year2 - year1;
        if (field == 2) {
            result = 12 * result + (month2 - month1);
        }
        return result;
    }

    private static String substring(String s, int start, int length) {
        int len = s.length();
        if (--start < 0) {
            start = 0;
        }
        if (length < 0) {
            length = 0;
        }
        int n = start = start > len ? len : start;
        if (start + length > len) {
            length = len - start;
        }
        return s.substring(start, start + length);
    }

    private static String replace(String s, String replace, String with) {
        int i;
        if (s == null || replace == null || with == null) {
            return null;
        }
        if (replace.length() == 0) {
            return s;
        }
        StringBuilder buff = new StringBuilder(s.length());
        int start = 0;
        int len = replace.length();
        while ((i = s.indexOf(replace, start)) != -1) {
            buff.append(s.substring(start, i)).append(with);
            start = i + len;
        }
        buff.append(s.substring(start));
        return buff.toString();
    }

    private static String repeat(String s, int count) {
        StringBuilder buff = new StringBuilder(s.length() * count);
        while (count-- > 0) {
            buff.append(s);
        }
        return buff.toString();
    }

    private static String rawToHex(String s) {
        int length = s.length();
        StringBuilder buff = new StringBuilder(4 * length);
        for (int i = 0; i < length; ++i) {
            String hex = Integer.toHexString(s.charAt(i) & 0xFFFF);
            for (int j = hex.length(); j < 4; ++j) {
                buff.append('0');
            }
            buff.append(hex);
        }
        return buff.toString();
    }

    private static int locate(String search, String s, int start) {
        if (start < 0) {
            int i = s.length() + start;
            return s.lastIndexOf(search, i) + 1;
        }
        int i = start == 0 ? 0 : start - 1;
        return s.indexOf(search, i) + 1;
    }

    private static String right(String s, int count) {
        if (count < 0) {
            count = 0;
        } else if (count > s.length()) {
            count = s.length();
        }
        return s.substring(s.length() - count);
    }

    private static String left(String s, int count) {
        if (count < 0) {
            count = 0;
        } else if (count > s.length()) {
            count = s.length();
        }
        return s.substring(0, count);
    }

    private static String insert(String s1, int start, int length, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        if (--start < 0 || length <= 0 || len2 == 0 || start > len1) {
            return s1;
        }
        if (start + length > len1) {
            length = len1 - start;
        }
        return s1.substring(0, start) + s2 + s1.substring(start + length);
    }

    private static String hexToRaw(String s) {
        int len = s.length();
        if (len % 4 != 0) {
            throw DbException.get(22018, s);
        }
        StringBuilder buff = new StringBuilder(len / 4);
        for (int i = 0; i < len; i += 4) {
            try {
                char raw = (char)Integer.parseInt(s.substring(i, i + 4), 16);
                buff.append(raw);
                continue;
            }
            catch (NumberFormatException e) {
                throw DbException.get(22018, s);
            }
        }
        return buff.toString();
    }

    private static int getDifference(String s1, String s2) {
        s1 = Function.getSoundex(s1);
        s2 = Function.getSoundex(s2);
        int e = 0;
        for (int i = 0; i < 4; ++i) {
            if (s1.charAt(i) != s2.charAt(i)) continue;
            ++e;
        }
        return e;
    }

    private static String translate(String original, String findChars, String replaceChars) {
        if (StringUtils.isNullOrEmpty(original) || StringUtils.isNullOrEmpty(findChars)) {
            return original;
        }
        StringBuilder buff = null;
        int replaceSize = replaceChars == null ? 0 : replaceChars.length();
        int size = original.length();
        for (int i = 0; i < size; ++i) {
            char ch = original.charAt(i);
            int index = findChars.indexOf(ch);
            if (index >= 0) {
                if (buff == null) {
                    buff = new StringBuilder(size);
                    if (i > 0) {
                        buff.append(original.substring(0, i));
                    }
                }
                if (index < replaceSize) {
                    ch = replaceChars.charAt(index);
                }
            }
            if (buff == null) continue;
            buff.append(ch);
        }
        return buff == null ? original : buff.toString();
    }

    private static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuilder s = new StringBuilder();
        s.append(d);
        if (s.toString().indexOf(69) >= 0) {
            return d;
        }
        int len = s.length();
        if (len < 16) {
            return d;
        }
        if (s.toString().indexOf(46) > len - 3) {
            return d;
        }
        s.delete(len - 2, len);
        char c1 = s.charAt((len -= 2) - 2);
        char c2 = s.charAt(len - 3);
        char c3 = s.charAt(len - 4);
        if (c1 == '0' && c2 == '0' && c3 == '0') {
            s.setCharAt(len - 1, '0');
        } else if (c1 == '9' && c2 == '9' && c3 == '9') {
            s.setCharAt(len - 1, '9');
            s.append('9');
            s.append('9');
            s.append('9');
        }
        return Double.parseDouble(s.toString());
    }

    private static String getSoundex(String s) {
        int len = s.length();
        char[] chars = new char[]{'0', '0', '0', '0'};
        char lastDigit = '0';
        int j = 0;
        for (int i = 0; i < len && j < 4; ++i) {
            char newDigit;
            char c = s.charAt(i);
            char c2 = newDigit = c > SOUNDEX_INDEX.length ? (char)'\u0000' : SOUNDEX_INDEX[c];
            if (newDigit == '\u0000') continue;
            if (j == 0) {
                chars[j++] = c;
                lastDigit = newDigit;
                continue;
            }
            if (newDigit <= '6') {
                if (newDigit == lastDigit) continue;
                chars[j++] = newDigit;
                lastDigit = newDigit;
                continue;
            }
            if (newDigit != '7') continue;
            lastDigit = newDigit;
        }
        return new String(chars);
    }

    private static Integer oraHash(String s, Integer bucket, Integer seed) {
        int hc = s.hashCode();
        if (seed != null && seed != 0) {
            hc *= seed * 17;
        }
        if (bucket != null && bucket > 0) {
            hc %= bucket.intValue();
        }
        return hc;
    }

    @Override
    public int getType() {
        return this.dataType;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        for (Expression e : this.args) {
            if (e == null) continue;
            e.mapColumns(resolver, level);
        }
    }

    protected void checkParameterCount(int len) {
        boolean ok;
        int min = 0;
        int max = Integer.MAX_VALUE;
        switch (this.info.type) {
            case 52: 
            case 204: 
            case 210: 
            case 219: 
            case 220: {
                min = 1;
                break;
            }
            case 20: 
            case 112: 
            case 119: {
                max = 1;
                break;
            }
            case 21: 
            case 27: 
            case 32: 
            case 63: 
            case 69: 
            case 78: 
            case 88: 
            case 225: {
                min = 1;
                max = 2;
                break;
            }
            case 93: {
                min = 1;
                max = 3;
                break;
            }
            case 95: {
                min = 1;
                max = 3;
                break;
            }
            case 58: 
            case 62: 
            case 67: 
            case 72: 
            case 73: 
            case 90: 
            case 91: {
                min = 2;
                max = 3;
                break;
            }
            case 54: {
                min = 1;
                break;
            }
            case 92: 
            case 211: {
                min = 2;
                break;
            }
            case 84: {
                min = 1;
                max = 4;
                break;
            }
            case 121: 
            case 122: {
                min = 2;
                max = 4;
                break;
            }
            case 207: 
            case 208: {
                min = 1;
                max = 2;
                break;
            }
            case 206: 
            case 229: {
                min = 3;
                break;
            }
            case 400: 
            case 401: {
                min = 2;
                break;
            }
            case 402: {
                min = 3;
                max = 5;
                break;
            }
            case 404: {
                min = 2;
                max = 3;
                break;
            }
            case 405: {
                min = 2;
                break;
            }
            case 202: {
                min = 1;
                max = 2;
                break;
            }
            case 3: {
                min = 1;
                max = 2;
                break;
            }
            case 14: {
                min = 1;
                max = 2;
                break;
            }
            case 415: 
            case 417: {
                min = 2;
                max = 3;
                break;
            }
            case 103: {
                min = 2;
                max = 3;
                break;
            }
            case 423: {
                min = 1;
                max = 2;
                break;
            }
            case 435: {
                min = 1;
                max = 2;
                break;
            }
            case 438: {
                max = 1;
                break;
            }
            case 115: {
                min = 1;
                max = 2;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.info.type);
            }
        }
        boolean bl = ok = len >= min && len <= max;
        if (!ok) {
            throw DbException.get(7001, this.info.name, min + ".." + max);
        }
    }

    public void doneWithParameters() {
        if (this.info.parameterCount == -1) {
            int len = this.varArgs.size();
            this.checkParameterCount(len);
            this.args = new Expression[len];
            this.varArgs.toArray(this.args);
            this.varArgs = null;
        } else {
            int len = this.args.length;
            if (len > 0 && this.args[len - 1] == null) {
                throw DbException.get(7001, this.info.name, "" + len);
            }
        }
    }

    public void setDataType(Column col) {
        this.dataType = col.getType();
        this.precision = col.getPrecision();
        this.displaySize = col.getDisplaySize();
        this.scale = col.getScale();
    }

    @Override
    public Expression optimize(Session session) {
        int d;
        long p;
        int s;
        int t;
        boolean allConst = this.info.deterministic;
        for (int i = 0; i < this.args.length; ++i) {
            Expression e = this.args[i];
            if (e == null) continue;
            this.args[i] = e = e.optimize(session);
            if (e.isConstant()) continue;
            allConst = false;
        }
        Expression p0 = this.args.length < 1 ? null : this.args[0];
        switch (this.info.type) {
            case 200: 
            case 204: 
            case 205: 
            case 219: 
            case 220: {
                t = -1;
                s = 0;
                p = 0L;
                d = 0;
                for (Expression e : this.args) {
                    int type;
                    if (e == ValueExpression.getNull() || (type = e.getType()) == -1 || type == 0) continue;
                    t = Value.getHigherOrder(t, type);
                    s = Math.max(s, e.getScale());
                    p = Math.max(p, e.getPrecision());
                    d = Math.max(d, e.getDisplaySize());
                }
                if (t != -1) break;
                t = 13;
                s = 0;
                p = Integer.MAX_VALUE;
                d = Integer.MAX_VALUE;
                break;
            }
            case 206: 
            case 229: {
                int type;
                Expression elsePart;
                t = -1;
                s = 0;
                p = 0L;
                d = 0;
                int len = this.args.length;
                for (int i = 2; i < len; i += 2) {
                    int type2;
                    Expression then = this.args[i];
                    if (then == ValueExpression.getNull() || (type2 = then.getType()) == -1 || type2 == 0) continue;
                    t = Value.getHigherOrder(t, type2);
                    s = Math.max(s, then.getScale());
                    p = Math.max(p, then.getPrecision());
                    d = Math.max(d, then.getDisplaySize());
                }
                if (this.args.length % 2 == 0 && (elsePart = this.args[this.args.length - 1]) != ValueExpression.getNull() && (type = elsePart.getType()) != -1 && type != 0) {
                    t = Value.getHigherOrder(t, type);
                    s = Math.max(s, elsePart.getScale());
                    p = Math.max(p, elsePart.getPrecision());
                    d = Math.max(d, elsePart.getDisplaySize());
                }
                if (t != -1) break;
                t = 13;
                s = 0;
                p = Integer.MAX_VALUE;
                d = Integer.MAX_VALUE;
                break;
            }
            case 201: {
                t = Value.getHigherOrder(this.args[1].getType(), this.args[2].getType());
                p = Math.max(this.args[1].getPrecision(), this.args[2].getPrecision());
                d = Math.max(this.args[1].getDisplaySize(), this.args[2].getDisplaySize());
                s = Math.max(this.args[1].getScale(), this.args[2].getScale());
                break;
            }
            case 228: {
                switch (this.args[1].getType()) {
                    case 13: 
                    case 14: 
                    case 16: 
                    case 21: {
                        t = this.args[1].getType();
                        break;
                    }
                    default: {
                        t = Value.getHigherOrder(this.args[1].getType(), this.args[2].getType());
                    }
                }
                p = Math.max(this.args[1].getPrecision(), this.args[2].getPrecision());
                d = Math.max(this.args[1].getDisplaySize(), this.args[2].getDisplaySize());
                s = Math.max(this.args[1].getScale(), this.args[2].getScale());
                break;
            }
            case 202: 
            case 203: 
            case 227: {
                t = this.dataType;
                p = this.precision;
                s = this.scale;
                d = this.displaySize;
                break;
            }
            case 27: {
                t = p0.getType();
                s = p0.getScale();
                p = p0.getPrecision();
                d = p0.getDisplaySize();
                if (t == 0) {
                    t = 4;
                    p = 10L;
                    d = 11;
                    s = 0;
                    break;
                }
                if (t != 11) break;
                t = 10;
                p = 8L;
                s = 0;
                d = 10;
                break;
            }
            case 0: 
            case 13: 
            case 21: {
                t = p0.getType();
                s = p0.getScale();
                p = p0.getPrecision();
                d = p0.getDisplaySize();
                if (t != 0) break;
                t = 4;
                p = 10L;
                d = 11;
                s = 0;
                break;
            }
            case 222: {
                Expression p1 = this.args[1];
                t = p1.getType();
                p = p1.getPrecision();
                s = p1.getScale();
                d = p1.getDisplaySize();
                if (p0 instanceof Variable) break;
                throw DbException.get(90137, p0.getSQL());
            }
            case 225: {
                t = this.args.length == 1 ? 15 : 16;
                p = Integer.MAX_VALUE;
                s = 0;
                d = Integer.MAX_VALUE;
                break;
            }
            case 72: 
            case 73: {
                t = this.info.dataType;
                p = this.args[0].getPrecision();
                s = 0;
                if (this.args[1].isConstant()) {
                    p -= this.args[1].getValue(session).getLong() - 1L;
                }
                if (this.args.length == 3 && this.args[2].isConstant()) {
                    p = Math.min(p, this.args[2].getValue(session).getLong());
                }
                p = Math.max(0L, p);
                d = MathUtils.convertLongToInt(p);
                break;
            }
            default: {
                t = this.info.dataType;
                DataType type = DataType.getDataType(t);
                p = -1L;
                d = 0;
                s = type.defaultScale;
            }
        }
        this.dataType = t;
        this.precision = p;
        this.scale = s;
        this.displaySize = d;
        if (allConst) {
            Value v = this.getValue(session);
            if (v == ValueNull.INSTANCE && (this.info.type == 203 || this.info.type == 202)) {
                return this;
            }
            return ValueExpression.get(v);
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression e : this.args) {
            if (e == null) continue;
            e.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public long getPrecision() {
        if (this.precision == -1L) {
            this.calculatePrecisionAndDisplaySize();
        }
        return this.precision;
    }

    @Override
    public int getDisplaySize() {
        if (this.precision == -1L) {
            this.calculatePrecisionAndDisplaySize();
        }
        return this.displaySize;
    }

    private void calculatePrecisionAndDisplaySize() {
        switch (this.info.type) {
            case 30: 
            case 31: {
                this.precision = this.args[2].getPrecision();
                this.displaySize = this.args[2].getDisplaySize();
                break;
            }
            case 32: {
                this.precision = this.args[0].getPrecision();
                this.displaySize = this.args[0].getDisplaySize();
                break;
            }
            case 54: {
                this.precision = 0L;
                this.displaySize = 0;
                for (Expression e : this.args) {
                    this.precision += e.getPrecision();
                    this.displaySize = MathUtils.convertLongToInt((long)this.displaySize + (long)e.getDisplaySize());
                    if (this.precision >= 0L) continue;
                    this.precision = Long.MAX_VALUE;
                }
                break;
            }
            case 56: {
                this.precision = (this.args[0].getPrecision() + 3L) / 4L;
                this.displaySize = MathUtils.convertLongToInt(this.precision);
                break;
            }
            case 27: 
            case 59: 
            case 63: 
            case 68: 
            case 69: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: {
                this.precision = this.args[0].getPrecision();
                this.displaySize = this.args[0].getDisplaySize();
                break;
            }
            case 65: {
                this.precision = this.args[0].getPrecision() * 4L;
                this.displaySize = MathUtils.convertLongToInt(this.precision);
                break;
            }
            case 70: {
                this.precision = 4L;
                this.displaySize = (int)this.precision;
                break;
            }
            case 104: 
            case 111: {
                this.precision = 20L;
                this.displaySize = (int)this.precision;
                break;
            }
            default: {
                DataType type = DataType.getDataType(this.dataType);
                this.precision = type.defaultPrecision;
                this.displaySize = type.defaultDisplaySize;
            }
        }
    }

    @Override
    public String getSQL() {
        StatementBuilder buff = new StatementBuilder(this.info.name);
        if (this.info.type == 206) {
            if (this.args[0] != null) {
                buff.append(" ").append(this.args[0].getSQL());
            }
            int len = this.args.length - 1;
            for (int i = 1; i < len; i += 2) {
                buff.append(" WHEN ").append(this.args[i].getSQL());
                buff.append(" THEN ").append(this.args[i + 1].getSQL());
            }
            if (this.args.length % 2 == 0) {
                buff.append(" ELSE ").append(this.args[this.args.length - 1].getSQL());
            }
            return buff.append(" END").toString();
        }
        buff.append('(');
        switch (this.info.type) {
            case 203: {
                buff.append(this.args[0].getSQL()).append(" AS ").append(new Column(null, this.dataType, this.precision, this.scale, this.displaySize).getCreateSQL());
                break;
            }
            case 202: {
                if (this.database.getMode().swapConvertFunctionParameters) {
                    buff.append(new Column(null, this.dataType, this.precision, this.scale, this.displaySize).getCreateSQL()).append(',').append(this.args[0].getSQL());
                    break;
                }
                if (this.args.length < 2) {
                    buff.append(this.args[0].getSQL()).append(',').append(new Column(null, this.dataType, this.precision, this.scale, this.displaySize).getCreateSQL());
                    break;
                }
                buff.append(this.args[0].getSQL()).append(" USING ").append(this.args[1].getSQL());
                break;
            }
            case 120: {
                ValueString v = (ValueString)((ValueExpression)this.args[0]).getValue(null);
                buff.append(v.getString()).append(" FROM ").append(this.args[1].getSQL());
                break;
            }
            case 415: 
            case 416: 
            case 417: 
            case 418: {
                if (this.args.length == 3) {
                    buff.append(this.args[0].getSQL()).append(", INTERVAL ").append(this.args[1].getSQL()).append(" ").append(this.args[2].getSQL());
                    break;
                }
                buff.append(this.args[0].getSQL()).append(",").append(this.args[1].getSQL());
                break;
            }
            default: {
                for (Expression e : this.args) {
                    buff.appendExceptFirst(", ");
                    buff.append(e.getSQL());
                }
            }
        }
        return buff.append(')').toString();
    }

    @Override
    public void updateAggregate(Session session) {
        for (Expression e : this.args) {
            if (e == null) continue;
            e.updateAggregate(session);
        }
    }

    public int getFunctionType() {
        return this.info.type;
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] argList) {
        switch (this.info.type) {
            case 210: {
                ValueResultSet x;
                String fileName = argList[0].getValue(session).getString();
                if (fileName == null) {
                    throw DbException.get(90012, "fileName");
                }
                String columnList = argList.length < 2 ? null : argList[1].getValue(session).getString();
                Csv csv = new Csv();
                String options = argList.length < 3 ? null : argList[2].getValue(session).getString();
                String charset = null;
                if (options != null && options.indexOf(61) >= 0) {
                    charset = csv.setOptions(options);
                } else {
                    charset = options;
                    String fieldSeparatorRead = argList.length < 4 ? null : argList[3].getValue(session).getString();
                    String fieldDelimiter = argList.length < 5 ? null : argList[4].getValue(session).getString();
                    String escapeCharacter = argList.length < 6 ? null : argList[5].getValue(session).getString();
                    Function.setCsvDelimiterEscape(csv, fieldSeparatorRead, fieldDelimiter, escapeCharacter);
                }
                char fieldSeparator = csv.getFieldSeparatorRead();
                String[] columns = StringUtils.arraySplit(columnList, fieldSeparator, true);
                ResultSet rs = null;
                try {
                    rs = csv.read(fileName, columns, charset);
                    x = ValueResultSet.getCopy(rs, 0);
                }
                catch (SQLException e) {
                    throw DbException.convert(e);
                }
                finally {
                    csv.close();
                    JdbcUtils.closeSilently(rs);
                }
                return x;
            }
        }
        return (ValueResultSet)this.getValueWithArgs(session, argList);
    }

    private static void setCsvDelimiterEscape(Csv csv, String fieldSeparator, String fieldDelimiter, String escapeCharacter) {
        if (fieldSeparator != null) {
            csv.setFieldSeparatorWrite(fieldSeparator);
            if (fieldSeparator.length() > 0) {
                char fs = fieldSeparator.charAt(0);
                csv.setFieldSeparatorRead(fs);
            }
        }
        if (fieldDelimiter != null) {
            char fd = fieldDelimiter.length() == 0 ? (char)'\u0000' : fieldDelimiter.charAt(0);
            csv.setFieldDelimiter(fd);
        }
        if (escapeCharacter != null) {
            char ec = escapeCharacter.length() == 0 ? (char)'\u0000' : escapeCharacter.charAt(0);
            csv.setEscapeCharacter(ec);
        }
    }

    @Override
    public Expression[] getArgs() {
        return this.args;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        for (Expression e : this.args) {
            if (e == null || e.isEverything(visitor)) continue;
            return false;
        }
        switch (visitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                return this.info.deterministic;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + visitor.getType());
    }

    @Override
    public int getCost() {
        int cost = 3;
        for (Expression e : this.args) {
            if (e == null) continue;
            cost += e.getCost();
        }
        return cost;
    }

    @Override
    public boolean isDeterministic() {
        return this.info.deterministic;
    }

    @Override
    public boolean isBufferResultSetToLocalTemp() {
        return this.info.bufferResultSetToLocalTemp;
    }

    private static String convert(String num, int from, int to) {
        String result;
        long v = Long.parseLong(num, Math.abs(from));
        if (v < 0L && to > 0) {
            BigInteger b = Function.convertLongToUnsigned(v);
            result = b.toString(to).toUpperCase();
        } else {
            result = Long.toString(v, Math.abs(to)).toUpperCase();
        }
        return result;
    }

    private static BigInteger convertLongToUnsigned(long v) {
        return new BigInteger(1, new byte[]{(byte)(v >> 56), (byte)(v >> 48), (byte)(v >> 40), (byte)(v >> 32), (byte)(v >> 24), (byte)(v >> 16), (byte)(v >> 8), (byte)(v >> 0)});
    }

    private static String dateFormat(Date date, String format) {
        StringBuilder out = new StringBuilder();
        boolean replaced = Function.convertDateFormat(out, format, date)[0];
        if (replaced) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(out.toString(), Locale.ENGLISH);
            return dateFormat.format(date);
        }
        return out.toString();
    }

    private static boolean[] convertDateFormat(StringBuilder out, String format, Date date) {
        int len = format.length();
        char[] chars = new char[len + 1];
        format.getChars(0, len, chars, 0);
        StringBuilder keep = new StringBuilder();
        boolean replaced = false;
        boolean dated = false;
        boolean timed = false;
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (c != '%') {
                keep.append(c);
                continue;
            }
            String replace = null;
            c = chars[++i];
            switch (c) {
                case 'a': {
                    replace = "EEE";
                    dated = true;
                    break;
                }
                case 'b': {
                    replace = "MMM";
                    dated = true;
                    break;
                }
                case 'c': {
                    replace = "M";
                    dated = true;
                    break;
                }
                case 'D': {
                    keep.append(Function.dateFormatSpecial(date, c));
                    dated = true;
                    break;
                }
                case 'd': {
                    replace = "dd";
                    dated = true;
                    break;
                }
                case 'e': {
                    replace = "d";
                    dated = true;
                    break;
                }
                case 'f': {
                    replace = "SSS000";
                    timed = true;
                    break;
                }
                case 'H': {
                    int day;
                    long time;
                    if (date instanceof Time) {
                        time = DateTimeUtils.getMillis(date);
                        if (time >= (long)(day = 86400000)) {
                            keep.append(time / 3600000L);
                        } else {
                            replace = "HH";
                        }
                    } else {
                        replace = "HH";
                    }
                    timed = true;
                    break;
                }
                case 'I': 
                case 'h': {
                    replace = "hh";
                    timed = true;
                    break;
                }
                case 'i': {
                    replace = "mm";
                    timed = true;
                    break;
                }
                case 'j': {
                    replace = "DDD";
                    dated = true;
                    break;
                }
                case 'k': {
                    int day;
                    long time;
                    if (date instanceof Time) {
                        time = DateTimeUtils.getMillis(date);
                        if (time >= (long)(day = 86400000)) {
                            keep.append(time / 3600000L);
                        } else {
                            replace = "H";
                        }
                    } else {
                        replace = "H";
                    }
                    timed = true;
                    break;
                }
                case 'l': {
                    replace = "h";
                    timed = true;
                    break;
                }
                case 'M': {
                    replace = "MMMM";
                    dated = true;
                    break;
                }
                case 'm': {
                    replace = "MM";
                    dated = true;
                    break;
                }
                case 'p': {
                    replace = "a";
                    timed = true;
                    break;
                }
                case 'r': {
                    replace = "hh:mm:ss a";
                    timed = true;
                    break;
                }
                case 'S': 
                case 's': {
                    replace = "ss";
                    timed = true;
                    break;
                }
                case 'T': {
                    replace = "HH:mm:ss";
                    timed = true;
                    break;
                }
                case 'U': 
                case 'V': 
                case 'u': 
                case 'v': {
                    keep.append(Function.dateFormatSpecial(date, c));
                    dated = true;
                    break;
                }
                case 'W': {
                    replace = "EEEE";
                    dated = true;
                    break;
                }
                case 'X': 
                case 'w': 
                case 'x': {
                    keep.append(Function.dateFormatSpecial(date, c));
                    dated = true;
                    break;
                }
                case 'Y': {
                    replace = "yyyy";
                    dated = true;
                    break;
                }
                case 'y': {
                    replace = "yy";
                    dated = true;
                    break;
                }
                default: {
                    keep.append(c);
                }
            }
            if (replace == null) continue;
            replaced = true;
            if (keep.length() > 0) {
                out.append('\'').append((CharSequence)keep).append('\'');
                keep.delete(0, keep.length());
            }
            out.append(replace);
        }
        if (replaced) {
            if (keep.length() > 0) {
                out.append('\'').append((CharSequence)keep).append('\'');
            }
        } else {
            out.append((CharSequence)keep);
        }
        return new boolean[]{replaced, dated, timed};
    }

    private static String dateFormatSpecial(Date date, char spec) {
        String result = "";
        if (date == null) {
            return result;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        block0 : switch (spec) {
            case 'D': {
                int day = cal.get(5);
                result = String.format("%d", day);
                switch (day) {
                    case 1: {
                        result = result + "st";
                        break block0;
                    }
                    case 2: {
                        result = result + "nd";
                        break block0;
                    }
                    case 3: {
                        result = result + "rd";
                        break block0;
                    }
                }
                result = result + "th";
                break;
            }
            case 'U': {
                result = String.format("%02d", Function.weekOfYear(cal, true, true, true));
                break;
            }
            case 'u': {
                result = String.format("%02d", Function.weekOfYear(cal, false, false, true));
                break;
            }
            case 'V': {
                result = String.format("%02d", Function.weekOfYear(cal, true, true, false));
                break;
            }
            case 'v': {
                result = String.format("%02d", Function.weekOfYear(cal, false, false, false));
                break;
            }
            case 'w': {
                result = String.format("%d", cal.get(7) - 1);
                break;
            }
            case 'X': {
                int day = cal.get(7) - 1;
                cal.set(6, cal.get(6) - day);
                result = String.format("%d", cal.get(1));
                break;
            }
            case 'x': {
                int day = (cal.get(7) + 5) % 7;
                cal.set(6, cal.get(6) - day);
                result = String.format("%d", cal.get(1));
                break;
            }
        }
        return result;
    }

    private static int weekOfYear(Calendar cal, boolean sun1st, boolean inc1st, boolean start0) {
        int day = cal.get(6) - 1;
        int week = Function.getWeek(cal, day, sun1st, inc1st);
        if (week == 0 && !start0) {
            cal.set(6, 0);
            week = Function.getWeek(cal, day += cal.get(6), sun1st, inc1st);
        }
        return week;
    }

    private static int getWeek(Calendar cal, int day, boolean sun1st, boolean inc1st) {
        int day1weekday;
        cal.set(6, 1);
        int n = day1weekday = sun1st ? cal.get(7) - 1 : (cal.get(7) + 5) % 7;
        int week1day1 = inc1st ? (7 - day1weekday) % 7 : (day1weekday <= 3 ? -day1weekday : (7 - day1weekday) % 7);
        return (day - week1day1 + 7) / 7;
    }

    private static Date strToDate(String str, String format) {
        Date date;
        StringBuilder out = new StringBuilder();
        boolean[] flags = Function.convertDateFormat(out, format, null);
        if (!flags[0]) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(out.toString(), Locale.ENGLISH);
        try {
            date = dateFormat.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
        if (flags[1] && flags[2]) {
            return new Timestamp(date.getTime());
        }
        if (flags[1]) {
            return new java.sql.Date(date.getTime());
        }
        if (flags[2]) {
            return new Time(date.getTime());
        }
        return null;
    }

    private static int week(java.sql.Date date, int mode) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        boolean sun1st = true;
        boolean inc1st = true;
        boolean start0 = true;
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                sun1st = false;
                inc1st = false;
                break;
            }
            case 2: {
                start0 = false;
                break;
            }
            case 3: {
                sun1st = false;
                inc1st = false;
                start0 = false;
                break;
            }
            case 4: {
                inc1st = false;
                break;
            }
            case 5: {
                sun1st = false;
                break;
            }
            case 6: {
                inc1st = false;
                start0 = false;
                break;
            }
            case 7: {
                sun1st = false;
                start0 = false;
                break;
            }
        }
        return Function.weekOfYear(cal, sun1st, inc1st, start0);
    }

    private static String hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        byte[] arr$ = bytes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Byte b = arr$[i$];
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    private static String hex(long n) {
        BigInteger big = Function.convertLongToUnsigned(n);
        return big.toString(16).toUpperCase();
    }

    private static String unhex(byte[] bytes) {
        int i = bytes.length % 2;
        int[] hex = new int[bytes.length + 1];
        hex[0] = 0;
        for (byte b : bytes) {
            int v;
            if (b >= 48 && b <= 57) {
                v = b - 48;
            } else if (b >= 65 && b <= 70) {
                v = b - 65 + 10;
            } else if (b >= 97 && b <= 102) {
                v = b - 97 + 10;
            } else {
                return null;
            }
            hex[i++] = v;
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < hex.length - 1; i += 2) {
            sb.append((char)(hex[i] << 4 | hex[i + 1]));
        }
        return sb.toString();
    }

    private static byte[] intToChars(int[] args, int size) {
        byte[] bytes = new byte[size * 4];
        int len = 0;
        for (int i = 0; i < size; ++i) {
            int v = args[i];
            byte[] vs = new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 24 & 0xFF), (byte)(v >> 8 & 0xFF), (byte)(v & 0xFF)};
            boolean keep = false;
            for (int j = 0; j < 3; ++j) {
                if (keep) {
                    bytes[len++] = vs[j];
                    continue;
                }
                if (vs[j] == 0) continue;
                keep = true;
                bytes[len++] = vs[j];
            }
            bytes[len++] = vs[3];
        }
        return Arrays.copyOf(bytes, len);
    }

    static {
        DATE_PART.put("SQL_TSI_YEAR", 1);
        DATE_PART.put("YEAR", 1);
        DATE_PART.put("YYYY", 1);
        DATE_PART.put("YY", 1);
        DATE_PART.put("SQL_TSI_MONTH", 2);
        DATE_PART.put("MONTH", 2);
        DATE_PART.put("MM", 2);
        DATE_PART.put("M", 2);
        DATE_PART.put("SQL_TSI_WEEK", 3);
        DATE_PART.put("WW", 3);
        DATE_PART.put("WK", 3);
        DATE_PART.put("WEEK", 3);
        DATE_PART.put("DAY", 5);
        DATE_PART.put("DD", 5);
        DATE_PART.put("D", 5);
        DATE_PART.put("SQL_TSI_DAY", 5);
        DATE_PART.put("DAYOFYEAR", 6);
        DATE_PART.put("DAY_OF_YEAR", 6);
        DATE_PART.put("DY", 6);
        DATE_PART.put("DOY", 6);
        DATE_PART.put("SQL_TSI_HOUR", 11);
        DATE_PART.put("HOUR", 11);
        DATE_PART.put("HH", 11);
        DATE_PART.put("SQL_TSI_MINUTE", 12);
        DATE_PART.put("MINUTE", 12);
        DATE_PART.put("MI", 12);
        DATE_PART.put("N", 12);
        DATE_PART.put("SQL_TSI_SECOND", 13);
        DATE_PART.put("SECOND", 13);
        DATE_PART.put("SS", 13);
        DATE_PART.put("S", 13);
        DATE_PART.put("MILLISECOND", 14);
        DATE_PART.put("MS", 14);
        DATE_PART.put("DATE", 5);
        DATE_PART.put("QUARTER", -1);
        DATE_PART.put("MINUTE_SECOND", -2);
        DATE_PART.put("HOUR_SECOND", -3);
        DATE_PART.put("HOUR_MINUTE", -4);
        DATE_PART.put("DAY_SECOND", -5);
        DATE_PART.put("DAY_MINUTE", -6);
        DATE_PART.put("DAY_HOUR", -7);
        DATE_PART.put("YEAR_MONTH", -8);
        DATE_PART_TRANS.put(-1, 2);
        DATE_PART_TRANS.put(-2, 13);
        DATE_PART_TRANS.put(-3, 13);
        DATE_PART_TRANS.put(-4, 12);
        DATE_PART_TRANS.put(-5, 13);
        DATE_PART_TRANS.put(-6, 12);
        DATE_PART_TRANS.put(-7, 10);
        DATE_PART_TRANS.put(-8, 2);
        DATE_FORMATS.put("DATE_USA", "%m.%d.%Y");
        DATE_FORMATS.put("DATE_JIS", "%Y-%m-%d");
        DATE_FORMATS.put("DATE_ISO", "%Y-%m-%d");
        DATE_FORMATS.put("DATE_EUR", "%d.%m.%Y");
        DATE_FORMATS.put("DATE_INTERNAL", "%Y%m%d");
        DATE_FORMATS.put("TIMESTAMP_USA", "%Y-%m-%d %H.%i.%s");
        DATE_FORMATS.put("TIMESTAMP_JIS", "%Y-%m-%d %H.%i.%s");
        DATE_FORMATS.put("TIMESTAMP_ISO", "%Y-%m-%d %H.%i.%s");
        DATE_FORMATS.put("TIMESTAMP_EUR", "%Y-%m-%d %H.%i.%s");
        DATE_FORMATS.put("TIMESTAMP_INTERNAL", "%Y%m%d%H%i%s");
        DATE_FORMATS.put("TIME_USA", "%h:%i:%s %p");
        DATE_FORMATS.put("TIME_JIS", "%H:%i:%s");
        DATE_FORMATS.put("TIME_ISO", "%H:%i:%s");
        DATE_FORMATS.put("TIME_EUR", "%H:%i:%s");
        DATE_FORMATS.put("TIME_INTERNAL", "%H%i%s");
        String index = "7AEIOUY8HW1BFPV2CGJKQSXZ3DT4L5MN6R";
        char number = '\u0000';
        int length = index.length();
        for (int i = 0; i < length; ++i) {
            char c = index.charAt(i);
            if (c < '9') {
                number = c;
                continue;
            }
            Function.SOUNDEX_INDEX[c] = number;
            Function.SOUNDEX_INDEX[Character.toLowerCase((char)c)] = number;
        }
        Function.addFunction("ABS", 0, 1, 0);
        Function.addFunction("ACOS", 1, 1, 7);
        Function.addFunction("ASIN", 2, 1, 7);
        Function.addFunction("ATAN", 3, -1, 7);
        Function.addFunction("ATAN2", 4, 2, 7);
        Function.addFunction("BIN", 96, 1, 13);
        Function.addFunction("BITAND", 5, 2, 5);
        Function.addFunction("BITOR", 6, 2, 5);
        Function.addFunction("BITXOR", 7, 2, 5);
        Function.addFunction("CEILING", 8, 1, 7);
        Function.addFunction("CEIL", 8, 1, 7);
        Function.addFunction("CONV", 40, 3, 13);
        Function.addFunction("COS", 9, 1, 7);
        Function.addFunction("COSH", 36, 1, 7);
        Function.addFunction("COT", 10, 1, 7);
        Function.addFunction("CRC32", 413, 1, 5);
        Function.addFunction("DEGREES", 11, 1, 7);
        Function.addFunctionWithNull("ELT", 400, -1, 13);
        Function.addFunction("EXP", 12, 1, 7);
        Function.addFunction("EXPORT_SET", 402, -1, 13);
        Function.addFunction("FIND_IN_SET", 403, 2, 4);
        Function.addFunctionWithNull("FIELD", 401, -1, 4);
        Function.addFunction("FLOOR", 13, 1, 7);
        Function.addFunctionWithNull("FORMAT", 404, -1, 13);
        Function.addFunction("HEX", 97, 1, 13);
        Function.addFunction("UNHEX", 98, 1, 13);
        Function.addFunction("LOG", 14, -1, 7);
        Function.addFunction("LN", 39, 1, 7);
        Function.addFunction("LOG10", 15, 1, 7);
        Function.addFunction("LOG2", 414, 1, 7);
        Function.addFunctionWithNull("MAKE_SET", 405, -1, 13);
        Function.addFunction("MOD", 16, 2, 5);
        Function.addFunction("OCT", 406, 1, 13);
        Function.addFunction("ORD", 407, 1, 5);
        Function.addFunction("PI", 17, 0, 7);
        Function.addFunction("POW", 18, 2, 7);
        Function.addFunction("POWER", 18, 2, 7);
        Function.addFunctionWithNull("QUOTE", 408, 1, 13);
        Function.addFunction("RADIANS", 19, 1, 7);
        Function.addFunctionNotDeterministic("RAND", 20, -1, 7);
        Function.addFunctionNotDeterministic("RANDOM", 20, -1, 7);
        Function.addFunction("REVERSE", 409, 1, 13);
        Function.addFunction("ROUND", 21, -1, 7);
        Function.addFunction("ROUNDMAGIC", 22, 1, 7);
        Function.addFunction("SIGN", 23, 1, 4);
        Function.addFunction("SIN", 24, 1, 7);
        Function.addFunction("SINH", 37, 1, 7);
        Function.addFunction("SQRT", 25, 1, 7);
        Function.addFunction("STRCMP", 410, 2, 4);
        Function.addFunction("SUBSTRING_INDEX", 411, 3, 13);
        Function.addFunction("TAN", 26, 1, 7);
        Function.addFunction("TANH", 38, 1, 7);
        Function.addFunction("TRUNCATE", 27, -1, 0);
        Function.addFunction("TRUNC", 27, -1, 0);
        Function.addFunction("UUID", 412, 0, 13);
        Function.addFunction("HASH", 29, 3, 12);
        Function.addFunction("ENCRYPT", 30, 3, 12);
        Function.addFunction("DECRYPT", 31, 3, 12);
        Function.addFunctionNotDeterministic("SECURE_RAND", 28, 1, 12);
        Function.addFunction("COMPRESS", 32, -1, 12);
        Function.addFunction("EXPAND", 33, 1, 12);
        Function.addFunction("ZERO", 34, 0, 4);
        Function.addFunctionNotDeterministic("RANDOM_UUID", 35, 0, 20);
        Function.addFunctionNotDeterministic("SYS_GUID", 35, 0, 20);
        Function.addFunction("ASCII", 50, 1, 4);
        Function.addFunction("BIT_LENGTH", 51, 1, 5);
        Function.addFunctionWithNull("CHAR", 52, -1, 12);
        Function.addFunctionWithNull("CHR", 52, -1, 12);
        Function.addFunction("CHAR_LENGTH", 53, 1, 4);
        Function.addFunction("CHARACTER_LENGTH", 53, 1, 4);
        Function.addFunction("CONCAT", 54, -1, 13);
        Function.addFunctionWithNull("CONCAT_WS", 92, -1, 13);
        Function.addFunction("DIFFERENCE", 55, 2, 4);
        Function.addFunction("HEXTORAW", 56, 1, 13);
        Function.addFunction("INSERT", 57, 4, 13);
        Function.addFunction("LCASE", 59, 1, 13);
        Function.addFunction("LEFT", 60, 2, 13);
        Function.addFunction("LENGTH", 61, 1, 5);
        Function.addFunction("LOCATE", 62, -1, 4);
        Function.addFunction("CHARINDEX", 62, -1, 4);
        Function.addFunction("POSITION", 62, 2, 4);
        Function.addFunction("INSTR", 58, -1, 4);
        Function.addFunction("LTRIM", 63, -1, 13);
        Function.addFunction("OCTET_LENGTH", 64, 1, 5);
        Function.addFunction("RAWTOHEX", 65, 1, 13);
        Function.addFunction("REPEAT", 66, 2, 13);
        Function.addFunction("REPLACE", 67, -1, 13);
        Function.addFunction("RIGHT", 68, 2, 13);
        Function.addFunction("RTRIM", 69, -1, 13);
        Function.addFunction("SOUNDEX", 70, 1, 13);
        Function.addFunction("SPACE", 71, 1, 13);
        Function.addFunction("SUBSTR", 72, -1, 13);
        Function.addFunction("SUBSTRING", 73, -1, 13);
        Function.addFunction("MID", 73, -1, 13);
        Function.addFunction("UCASE", 74, 1, 13);
        Function.addFunction("LOWER", 75, 1, 13);
        Function.addFunction("UPPER", 76, 1, 13);
        Function.addFunction("POSITION", 77, 2, 4);
        Function.addFunction("TRIM", 78, -1, 13);
        Function.addFunction("STRINGENCODE", 79, 1, 13);
        Function.addFunction("STRINGDECODE", 80, 1, 13);
        Function.addFunction("STRINGTOUTF8", 81, 1, 12);
        Function.addFunction("UTF8TOSTRING", 82, 1, 13);
        Function.addFunction("XMLATTR", 83, 2, 13);
        Function.addFunctionWithNull("XMLNODE", 84, -1, 13);
        Function.addFunction("XMLCOMMENT", 85, 1, 13);
        Function.addFunction("XMLCDATA", 86, 1, 13);
        Function.addFunction("XMLSTARTDOC", 87, 0, 13);
        Function.addFunction("XMLTEXT", 88, -1, 13);
        Function.addFunction("REGEXP_REPLACE", 89, 3, 13);
        Function.addFunction("RPAD", 90, -1, 13);
        Function.addFunction("LPAD", 91, -1, 13);
        Function.addFunction("TO_CHAR", 93, -1, 13);
        Function.addFunction("ORA_HASH", 95, -1, 4);
        Function.addFunction("TRANSLATE", 94, 3, 13);
        Function.addFunctionNotDeterministic("CURRENT_DATE", 117, 0, 10);
        Function.addFunctionNotDeterministic("CURDATE", 100, 0, 10);
        Function.addFunctionNotDeterministic("GETDATE", 100, 0, 10);
        Function.addFunctionNotDeterministic("CURRENT_TIME", 118, 0, 9);
        Function.addFunctionNotDeterministic("CURTIME", 101, 0, 9);
        Function.addFunctionNotDeterministic("CURRENT_TIMESTAMP", 119, -1, 11);
        Function.addFunctionNotDeterministic("NOW", 112, -1, 11);
        Function.addFunctionNotDeterministic("LOCALTIME", 112, -1, 11);
        Function.addFunctionNotDeterministic("LOCALTIMESTAMP", 112, -1, 11);
        Function.addFunction("DATEADD", 102, 3, 11);
        Function.addFunction("TIMESTAMPADD", 102, 3, 5);
        Function.addFunction("DATEDIFF", 103, -1, 5);
        Function.addFunction("TIMESTAMPDIFF", 103, 3, 5);
        Function.addFunction("DAYNAME", 104, 1, 13);
        Function.addFunction("DAYNAME", 104, 1, 13);
        Function.addFunction("DAY", 105, 1, 4);
        Function.addFunction("DAY_OF_MONTH", 105, 1, 4);
        Function.addFunction("DAY_OF_WEEK", 106, 1, 4);
        Function.addFunction("DAY_OF_YEAR", 107, 1, 4);
        Function.addFunction("DAYOFMONTH", 105, 1, 4);
        Function.addFunction("DAYOFWEEK", 106, 1, 4);
        Function.addFunction("WEEKDAY", 442, 1, 4);
        Function.addFunction("DAYOFYEAR", 107, 1, 4);
        Function.addFunction("HOUR", 108, 1, 4);
        Function.addFunction("MINUTE", 109, 1, 4);
        Function.addFunction("MONTH", 110, 1, 4);
        Function.addFunction("MONTHNAME", 111, 1, 13);
        Function.addFunction("QUARTER", 113, 1, 4);
        Function.addFunction("SECOND", 114, 1, 4);
        Function.addFunction("WEEK", 115, -1, 4);
        Function.addFunction("WEEKOFYEAR", 443, 1, 4);
        Function.addFunction("YEAR", 116, 1, 4);
        Function.addFunction("EXTRACT", 120, 2, 4);
        Function.addFunctionWithNull("FORMATDATETIME", 121, -1, 13);
        Function.addFunctionWithNull("PARSEDATETIME", 122, -1, 11);
        Function.addFunction("ISO_YEAR", 123, 1, 4);
        Function.addFunction("ISO_WEEK", 124, 1, 4);
        Function.addFunction("ISO_DAY_OF_WEEK", 125, 1, 4);
        Function.addFunction("DATE_FORMAT", 126, 2, 13);
        Function.addFunction("STR_TO_DATE", 432, 2, 0);
        Function.addFunction("ADDDATE", 415, -1, 11);
        Function.addFunction("DATE_ADD", 416, 3, 11);
        Function.addFunction("SUBDATE", 417, -1, 11);
        Function.addFunction("DATE_SUB", 418, 3, 11);
        Function.addFunction("ADDTIME", 419, 2, 11);
        Function.addFunction("SUBTIME", 420, 2, 11);
        Function.addFunction("DATE", 421, 1, 10);
        Function.addFunction("FROM_DAYS", 422, 1, 10);
        Function.addFunction("FROM_UNIXTIME", 423, -1, 13);
        Function.addFunction("GET_FORMAT", 424, 2, 13);
        Function.addFunction("LAST_DAY", 425, 1, 10);
        Function.addFunction("MAKEDATE", 426, 2, 10);
        Function.addFunction("MAKETIME", 427, 3, 9);
        Function.addFunction("MICROSECOND", 428, 1, 4);
        Function.addFunction("PERIOD_ADD", 429, 2, 4);
        Function.addFunction("PERIOD_DIFF", 430, 2, 4);
        Function.addFunction("SEC_TO_TIME", 431, 1, 9);
        Function.addFunction("TIME", 433, 1, 9);
        Function.addFunction("TIMEDIFF", 434, 2, 9);
        Function.addFunction("TIMESTAMP", 435, -1, 11);
        Function.addFunction("TIME_FORMAT", 436, 2, 13);
        Function.addFunction("TIME_TO_SEC", 437, 1, 4);
        Function.addFunction("UNIX_TIMESTAMP", 438, -1, 5);
        Function.addFunction("UTC_DATE", 439, 0, 10);
        Function.addFunction("UTC_TIME", 440, 0, 9);
        Function.addFunction("UTC_TIMESTAMP", 441, 0, 11);
        Function.addFunctionNotDeterministic("DATABASE", 150, 0, 13);
        Function.addFunctionNotDeterministic("USER", 151, 0, 13);
        Function.addFunctionNotDeterministic("CURRENT_USER", 152, 0, 13);
        Function.addFunctionNotDeterministic("IDENTITY", 153, 0, 5);
        Function.addFunctionNotDeterministic("SCOPE_IDENTITY", 154, 0, 5);
        Function.addFunctionNotDeterministic("IDENTITY_VAL_LOCAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("LAST_INSERT_ID", 153, 0, 5);
        Function.addFunctionNotDeterministic("LASTVAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("AUTOCOMMIT", 155, 0, 1);
        Function.addFunctionNotDeterministic("READONLY", 156, 0, 1);
        Function.addFunction("DATABASE_PATH", 157, 0, 13);
        Function.addFunctionNotDeterministic("LOCK_TIMEOUT", 158, 0, 4);
        Function.addFunctionWithNull("IFNULL", 200, 2, 0);
        Function.addFunctionWithNull("ISNULL", 200, 2, 0);
        Function.addFunctionWithNull("CASEWHEN", 201, 3, 0);
        Function.addFunctionWithNull("CONVERT", 202, -1, 0);
        Function.addFunctionWithNull("CAST", 203, 1, 0);
        Function.addFunctionWithNull("TRUNCATE_VALUE", 227, 3, 0);
        Function.addFunctionWithNull("COALESCE", 204, -1, 0);
        Function.addFunctionWithNull("NVL", 204, -1, 0);
        Function.addFunctionWithNull("NVL2", 228, 3, 0);
        Function.addFunctionWithNull("NULLIF", 205, 2, 0);
        Function.addFunctionWithNull("CASE", 206, -1, 0);
        Function.addFunctionNotDeterministic("NEXTVAL", 207, -1, 5);
        Function.addFunctionNotDeterministic("CURRVAL", 208, -1, 5);
        Function.addFunction("ARRAY_GET", 209, 2, 13);
        Function.addFunction("ARRAY_CONTAINS", 230, 2, 1, false, true, true);
        Function.addFunction("CSVREAD", 210, -1, 18, false, false, false);
        Function.addFunction("CSVWRITE", 211, -1, 4, false, false, true);
        Function.addFunctionNotDeterministic("MEMORY_FREE", 212, 0, 4);
        Function.addFunctionNotDeterministic("MEMORY_USED", 213, 0, 4);
        Function.addFunctionNotDeterministic("LOCK_MODE", 214, 0, 4);
        Function.addFunctionNotDeterministic("SCHEMA", 215, 0, 13);
        Function.addFunctionNotDeterministic("SESSION_ID", 216, 0, 4);
        Function.addFunction("ARRAY_LENGTH", 217, 1, 4);
        Function.addFunctionNotDeterministic("LINK_SCHEMA", 218, 6, 18);
        Function.addFunctionWithNull("LEAST", 220, -1, 0);
        Function.addFunctionWithNull("GREATEST", 219, -1, 0);
        Function.addFunctionNotDeterministic("CANCEL_SESSION", 221, 1, 1);
        Function.addFunction("SET", 222, 2, 0, false, false, true);
        Function.addFunction("FILE_READ", 225, -1, 0, false, false, true);
        Function.addFunction("FILE_WRITE", 232, 2, 5, false, false, true);
        Function.addFunctionNotDeterministic("TRANSACTION_ID", 226, 0, 13);
        Function.addFunctionWithNull("DECODE", 229, -1, 0);
        Function.addFunctionNotDeterministic("DISK_SPACE_USED", 159, 1, 5);
        Function.addFunction("H2VERSION", 231, 0, 13);
        Function.addFunctionWithNull("TABLE", 223, -1, 18);
        Function.addFunctionWithNull("TABLE_DISTINCT", 224, -1, 18);
        Function.addFunctionWithNull("ROW_NUMBER", 300, 0, 5);
        Function.addFunction("VALUES", 250, 1, 0, false, true, false);
    }
}

