/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.expression;

import com.alibaba.dts.shade.org.h2.command.Parser;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.expression.Expression;
import com.alibaba.dts.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.table.ColumnResolver;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.value.Value;

public class Variable
extends Expression {
    private final String name;
    private Value lastValue;

    public Variable(Session session, String name) {
        this.name = name;
        this.lastValue = session.getVariable(name);
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public int getDisplaySize() {
        return this.lastValue.getDisplaySize();
    }

    @Override
    public long getPrecision() {
        return this.lastValue.getPrecision();
    }

    @Override
    public String getSQL() {
        return "@" + Parser.quoteIdentifier(this.name);
    }

    @Override
    public int getScale() {
        return this.lastValue.getScale();
    }

    @Override
    public int getType() {
        return this.lastValue.getType();
    }

    @Override
    public Value getValue(Session session) {
        this.lastValue = session.getVariable(this.name);
        return this.lastValue;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw DbException.throwInternalError("type=" + visitor.getType());
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
    }

    @Override
    public Expression optimize(Session session) {
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean value) {
    }

    @Override
    public void updateAggregate(Session session) {
    }

    public String getName() {
        return this.name;
    }
}

