/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.index;

import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.engine.SysProperties;
import com.alibaba.dts.shade.org.h2.index.Cursor;
import com.alibaba.dts.shade.org.h2.index.MultiVersionIndex;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.result.SearchRow;
import com.alibaba.dts.shade.org.h2.util.MathUtils;

public class MultiVersionCursor
implements Cursor {
    private final MultiVersionIndex index;
    private final Session session;
    private final Cursor baseCursor;
    private final Cursor deltaCursor;
    private final Object sync;
    private SearchRow baseRow;
    private Row deltaRow;
    private boolean onBase;
    private boolean end;
    private boolean needNewDelta;
    private boolean needNewBase;
    private boolean reverse;

    MultiVersionCursor(Session session, MultiVersionIndex index, Cursor base, Cursor delta, Object sync) {
        this.session = session;
        this.index = index;
        this.baseCursor = base;
        this.deltaCursor = delta;
        this.sync = sync;
        this.needNewDelta = true;
        this.needNewBase = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadCurrent() {
        Object object = this.sync;
        synchronized (object) {
            this.baseRow = this.baseCursor.getSearchRow();
            this.deltaRow = this.deltaCursor.get();
            this.needNewDelta = false;
            this.needNewBase = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNext(boolean base) {
        Object object = this.sync;
        synchronized (object) {
            if (base) {
                this.baseRow = this.step(this.baseCursor) ? this.baseCursor.getSearchRow() : null;
            } else {
                this.deltaRow = this.step(this.deltaCursor) ? this.deltaCursor.get() : null;
            }
        }
    }

    private boolean step(Cursor cursor) {
        return this.reverse ? cursor.previous() : cursor.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row get() {
        Object object = this.sync;
        synchronized (object) {
            if (this.end) {
                return null;
            }
            return this.onBase ? this.baseCursor.get() : this.deltaCursor.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchRow getSearchRow() {
        Object object = this.sync;
        synchronized (object) {
            if (this.end) {
                return null;
            }
            return this.onBase ? this.baseCursor.getSearchRow() : this.deltaCursor.getSearchRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() {
        Object object = this.sync;
        synchronized (object) {
            int compare;
            if (SysProperties.CHECK && this.end) {
                DbException.throwInternalError();
            }
            while (true) {
                if (this.needNewDelta) {
                    this.loadNext(false);
                    this.needNewDelta = false;
                }
                if (this.needNewBase) {
                    this.loadNext(true);
                    this.needNewBase = false;
                }
                if (this.deltaRow == null) {
                    if (this.baseRow == null) {
                        this.end = true;
                        return false;
                    }
                    this.onBase = true;
                    this.needNewBase = true;
                    return true;
                }
                int sessionId = this.deltaRow.getSessionId();
                boolean isThisSession = sessionId == this.session.getId();
                boolean isDeleted = this.deltaRow.isDeleted();
                if (isThisSession && isDeleted) {
                    this.needNewDelta = true;
                    continue;
                }
                if (this.baseRow == null) {
                    if (isDeleted) {
                        if (isThisSession) {
                            this.end = true;
                            return false;
                        }
                        this.onBase = false;
                        this.needNewDelta = true;
                        return true;
                    }
                    DbException.throwInternalError();
                }
                if ((compare = this.index.compareRows(this.deltaRow, this.baseRow)) == 0) {
                    long k1 = this.deltaRow.getKey();
                    long k2 = this.baseRow.getKey();
                    compare = MathUtils.compareLong(k1, k2);
                }
                if (compare != 0) break;
                if (isDeleted) {
                    if (!isThisSession) break;
                    DbException.throwInternalError();
                    break;
                }
                if (isThisSession) {
                    this.onBase = false;
                    this.needNewBase = true;
                    this.needNewDelta = true;
                    return true;
                }
                this.needNewBase = true;
                this.needNewDelta = true;
            }
            if (compare > 0) {
                this.onBase = true;
                this.needNewBase = true;
                return true;
            }
            this.onBase = false;
            this.needNewDelta = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() {
        this.reverse = true;
        try {
            boolean bl = this.next();
            return bl;
        }
        finally {
            this.reverse = false;
        }
    }
}

