/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.index;

import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.index.BaseIndex;
import com.alibaba.dts.shade.org.h2.index.Cursor;
import com.alibaba.dts.shade.org.h2.index.IndexType;
import com.alibaba.dts.shade.org.h2.index.RangeCursor;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.result.SearchRow;
import com.alibaba.dts.shade.org.h2.result.SortOrder;
import com.alibaba.dts.shade.org.h2.table.IndexColumn;
import com.alibaba.dts.shade.org.h2.table.RangeTable;
import com.alibaba.dts.shade.org.h2.table.TableFilter;

public class RangeIndex
extends BaseIndex {
    private final RangeTable rangeTable;

    public RangeIndex(RangeTable table, IndexColumn[] columns) {
        this.initBaseIndex(table, 0, "RANGE_INDEX", columns, IndexType.createNonUnique(true));
        this.rangeTable = table;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        long max;
        long min;
        long start = min = this.rangeTable.getMin(session);
        long end = max = this.rangeTable.getMax(session);
        long step = this.rangeTable.getStep(session);
        try {
            start = Math.max(min, first == null ? min : first.getValue(0).getLong());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            end = Math.min(max, last == null ? max : last.getValue(0).getLong());
        }
        catch (Exception e) {
            // empty catch block
        }
        return new RangeCursor(start, end, step);
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter filter, SortOrder sortOrder) {
        return 1.0;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void remove(Session session) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        long pos = first ? this.rangeTable.getMin(session) : this.rangeTable.getMax(session);
        return new RangeCursor(pos, pos);
    }

    @Override
    public long getRowCount(Session session) {
        return this.rangeTable.getRowCountApproximation();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rangeTable.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

