/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.jdbc;

import com.alibaba.dts.shade.org.h2.jdbc.JdbcConnection;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.message.TraceObject;
import com.alibaba.dts.shade.org.h2.tools.SimpleResultSet;
import com.alibaba.dts.shade.org.h2.value.Value;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class JdbcArray
extends TraceObject
implements Array {
    private Value value;
    private final JdbcConnection conn;

    JdbcArray(JdbcConnection conn, Value value, int id) {
        this.setTrace(conn.getSession().getTrace(), 16, id);
        this.conn = conn;
        this.value = value;
    }

    @Override
    public Object getArray() throws SQLException {
        try {
            this.debugCodeCall("getArray");
            this.checkClosed();
            return this.get();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        try {
            this.debugCode("getArray(" + JdbcArray.quoteMap(map) + ");");
            JdbcConnection.checkMap(map);
            this.checkClosed();
            return this.get();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        try {
            this.debugCode("getArray(" + index + ", " + count + ");");
            this.checkClosed();
            return this.get(index, count);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        try {
            this.debugCode("getArray(" + index + ", " + count + ", " + JdbcArray.quoteMap(map) + ");");
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return this.get(index, count);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getBaseType() throws SQLException {
        try {
            this.debugCodeCall("getBaseType");
            this.checkClosed();
            return 0;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        try {
            this.debugCodeCall("getBaseTypeName");
            this.checkClosed();
            return "NULL";
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            this.debugCodeCall("getResultSet");
            this.checkClosed();
            return JdbcArray.getResultSet(this.get(), 0L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        try {
            this.debugCode("getResultSet(" + JdbcArray.quoteMap(map) + ");");
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return JdbcArray.getResultSet(this.get(), 0L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        try {
            this.debugCode("getResultSet(" + index + ", " + count + ");");
            this.checkClosed();
            return JdbcArray.getResultSet(this.get(index, count), index - 1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        try {
            this.debugCode("getResultSet(" + index + ", " + count + ", " + JdbcArray.quoteMap(map) + ");");
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return JdbcArray.getResultSet(this.get(index, count), index - 1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    private static ResultSet getResultSet(Object[] array, long offset) {
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn("INDEX", -5, 0, 0);
        rs.addColumn("VALUE", 0, 0, 0);
        for (int i = 0; i < array.length; ++i) {
            rs.addRow(offset + (long)i + 1L, array[i]);
        }
        return rs;
    }

    private void checkClosed() {
        this.conn.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    private Object[] get() {
        return (Object[])this.value.convertTo(17).getObject();
    }

    private Object[] get(long index, int count) {
        Object[] array = this.get();
        if (count < 0 || count > array.length) {
            throw DbException.getInvalidValueException("count (1.." + array.length + ")", count);
        }
        if (index < 1L || index > (long)array.length) {
            throw DbException.getInvalidValueException("index (1.." + array.length + ")", index);
        }
        Object[] subset = new Object[count];
        System.arraycopy(array, (int)(index - 1L), subset, 0, count);
        return subset;
    }

    public String toString() {
        return this.value == null ? "null" : this.getTraceObjectName() + ": " + this.value.getTraceSQL();
    }
}

