/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.jdbc;

import com.alibaba.dts.shade.org.h2.jdbc.JdbcPreparedStatement;
import com.alibaba.dts.shade.org.h2.jdbc.JdbcResultSet;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.message.Trace;
import com.alibaba.dts.shade.org.h2.message.TraceObject;
import com.alibaba.dts.shade.org.h2.result.ResultInterface;
import com.alibaba.dts.shade.org.h2.util.MathUtils;
import com.alibaba.dts.shade.org.h2.value.DataType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class JdbcResultSetMetaData
extends TraceObject
implements ResultSetMetaData {
    private final String catalog;
    private final JdbcResultSet rs;
    private final JdbcPreparedStatement prep;
    private final ResultInterface result;
    private final int columnCount;

    JdbcResultSetMetaData(JdbcResultSet rs, JdbcPreparedStatement prep, ResultInterface result, String catalog, Trace trace, int id) {
        this.setTrace(trace, 5, id);
        this.catalog = catalog;
        this.rs = rs;
        this.prep = prep;
        this.result = result;
        this.columnCount = result.getVisibleColumnCount();
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            this.debugCodeCall("getColumnCount");
            this.checkClosed();
            return this.columnCount;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        try {
            this.debugCodeCall("getColumnLabel", column);
            this.checkColumnIndex(column);
            return this.result.getAlias(--column);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        try {
            this.debugCodeCall("getColumnName", column);
            this.checkColumnIndex(column);
            return this.result.getColumnName(--column);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        try {
            this.debugCodeCall("getColumnType", column);
            this.checkColumnIndex(column);
            int type = this.result.getColumnType(--column);
            return DataType.convertTypeToSQLType(type);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        try {
            this.debugCodeCall("getColumnTypeName", column);
            this.checkColumnIndex(column);
            int type = this.result.getColumnType(--column);
            return DataType.getDataType((int)type).name;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        try {
            this.debugCodeCall("getSchemaName", column);
            this.checkColumnIndex(column);
            String schema = this.result.getSchemaName(--column);
            return schema == null ? "" : schema;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getTableName(int column) throws SQLException {
        try {
            this.debugCodeCall("getTableName", column);
            this.checkColumnIndex(column);
            String table = this.result.getTableName(--column);
            return table == null ? "" : table;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        try {
            this.debugCodeCall("getCatalogName", column);
            this.checkColumnIndex(column);
            return this.catalog == null ? "" : this.catalog;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        try {
            this.debugCodeCall("isAutoIncrement", column);
            this.checkColumnIndex(column);
            return this.result.isAutoIncrement(--column);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        try {
            this.debugCodeCall("isCaseSensitive", column);
            this.checkColumnIndex(column);
            return true;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        try {
            this.debugCodeCall("isSearchable", column);
            this.checkColumnIndex(column);
            return true;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        try {
            this.debugCodeCall("isCurrency", column);
            this.checkColumnIndex(column);
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int isNullable(int column) throws SQLException {
        try {
            this.debugCodeCall("isNullable", column);
            this.checkColumnIndex(column);
            return this.result.getNullable(--column);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        try {
            this.debugCodeCall("isSigned", column);
            this.checkColumnIndex(column);
            return true;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        try {
            this.debugCodeCall("isReadOnly", column);
            this.checkColumnIndex(column);
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        try {
            this.debugCodeCall("isWritable", column);
            this.checkColumnIndex(column);
            return true;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        try {
            this.debugCodeCall("isDefinitelyWritable", column);
            this.checkColumnIndex(column);
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        try {
            this.debugCodeCall("getColumnClassName", column);
            this.checkColumnIndex(column);
            int type = this.result.getColumnType(--column);
            return DataType.getTypeClassName(type);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        try {
            this.debugCodeCall("getPrecision", column);
            this.checkColumnIndex(column);
            long prec = this.result.getColumnPrecision(--column);
            return MathUtils.convertLongToInt(prec);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getScale(int column) throws SQLException {
        try {
            this.debugCodeCall("getScale", column);
            this.checkColumnIndex(column);
            return this.result.getColumnScale(--column);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        try {
            this.debugCodeCall("getColumnDisplaySize", column);
            this.checkColumnIndex(column);
            return this.result.getDisplaySize(--column);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void checkClosed() {
        if (this.rs != null) {
            this.rs.checkClosed();
        }
        if (this.prep != null) {
            this.prep.checkClosed();
        }
    }

    private void checkColumnIndex(int columnIndex) {
        this.checkClosed();
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw DbException.getInvalidValueException("columnIndex", columnIndex);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw DbException.getInvalidValueException("iface", iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    public String toString() {
        return this.getTraceObjectName() + ": columns=" + this.columnCount;
    }
}

