/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.server.web;

import com.alibaba.dts.shade.org.h2.util.New;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PageParser {
    private static final int TAB_WIDTH = 4;
    private final String page;
    private int pos;
    private final Map<String, Object> settings;
    private final int len;
    private StringBuilder result;

    private PageParser(String page, Map<String, Object> settings, int pos) {
        this.page = page;
        this.pos = pos;
        this.len = page.length();
        this.settings = settings;
        this.result = new StringBuilder(this.len);
    }

    public static String parse(String page, Map<String, Object> settings) {
        PageParser block = new PageParser(page, settings, 0);
        return block.replaceTags();
    }

    private void setError(int i) {
        String s = this.page.substring(0, i) + "####BUG####" + this.page.substring(i);
        s = PageParser.escapeHtml(s);
        this.result = new StringBuilder();
        this.result.append(s);
    }

    private String parseBlockUntil(String end) throws ParseException {
        PageParser block = new PageParser(this.page, this.settings, this.pos);
        block.parseAll();
        if (!block.readIf(end)) {
            throw new ParseException(this.page, block.pos);
        }
        this.pos = block.pos;
        return block.result.toString();
    }

    private String replaceTags() {
        try {
            this.parseAll();
            if (this.pos != this.len) {
                this.setError(this.pos);
            }
        }
        catch (ParseException e) {
            this.setError(this.pos);
        }
        return this.result.toString();
    }

    private void parseAll() throws ParseException {
        int i;
        StringBuilder buff = this.result;
        String p = this.page;
        block4: for (i = this.pos; i < this.len; ++i) {
            char c = p.charAt(i);
            switch (c) {
                case '<': {
                    if (p.charAt(i + 3) == ':' && p.charAt(i + 1) == '/') {
                        this.pos = i;
                        return;
                    }
                    if (p.charAt(i + 2) == ':') {
                        this.pos = i;
                        if (this.readIf("<c:forEach")) {
                            String var = this.readParam("var");
                            String items = this.readParam("items");
                            this.read(">");
                            int start = this.pos;
                            ArrayList list = (ArrayList)this.get(items);
                            if (list == null) {
                                this.result.append("?items?");
                                list = New.arrayList();
                            }
                            if (list.size() == 0) {
                                this.parseBlockUntil("</c:forEach>");
                            }
                            for (Object o : list) {
                                this.settings.put(var, o);
                                this.pos = start;
                                String block = this.parseBlockUntil("</c:forEach>");
                                this.result.append(block);
                            }
                        } else if (this.readIf("<c:if")) {
                            String test = this.readParam("test");
                            int eq = test.indexOf("=='");
                            if (eq < 0) {
                                this.setError(i);
                                return;
                            }
                            String val = test.substring(eq + 3, test.length() - 1);
                            test = test.substring(0, eq);
                            String value = (String)this.get(test);
                            this.read(">");
                            String block = this.parseBlockUntil("</c:if>");
                            --this.pos;
                            if (value.equals(val)) {
                                this.result.append(block);
                            }
                        } else {
                            this.setError(i);
                            return;
                        }
                        i = this.pos;
                        continue block4;
                    }
                    buff.append(c);
                    continue block4;
                }
                case '$': {
                    if (p.length() > i + 1 && p.charAt(i + 1) == '{') {
                        int j = p.indexOf(125, i += 2);
                        if (j < 0) {
                            this.setError(i);
                            return;
                        }
                        String item = p.substring(i, j).trim();
                        i = j;
                        String s = (String)this.get(item);
                        this.replaceTags(s);
                        continue block4;
                    }
                    buff.append(c);
                    continue block4;
                }
                default: {
                    buff.append(c);
                }
            }
        }
        this.pos = i;
    }

    private Object get(String item) {
        int dot = item.indexOf(46);
        if (dot >= 0) {
            String sub = item.substring(dot + 1);
            HashMap map = (HashMap)this.settings.get(item = item.substring(0, dot));
            if (map == null) {
                return "?" + item + "?";
            }
            return map.get(sub);
        }
        return this.settings.get(item);
    }

    private void replaceTags(String s) {
        if (s != null) {
            this.result.append(PageParser.parse(s, this.settings));
        }
    }

    private String readParam(String name) throws ParseException {
        this.read(name);
        this.read("=");
        this.read("\"");
        int start = this.pos;
        while (this.page.charAt(this.pos) != '\"') {
            ++this.pos;
        }
        int end = this.pos;
        this.read("\"");
        String s = this.page.substring(start, end);
        return PageParser.parse(s, this.settings);
    }

    private void skipSpaces() {
        while (this.page.charAt(this.pos) == ' ') {
            ++this.pos;
        }
    }

    private void read(String s) throws ParseException {
        if (!this.readIf(s)) {
            throw new ParseException(s, this.pos);
        }
    }

    private boolean readIf(String s) {
        this.skipSpaces();
        if (this.page.regionMatches(this.pos, s, 0, s.length())) {
            this.pos += s.length();
            this.skipSpaces();
            return true;
        }
        return false;
    }

    static String escapeHtmlData(String s) {
        return PageParser.escapeHtml(s, false);
    }

    public static String escapeHtml(String s) {
        return PageParser.escapeHtml(s, true);
    }

    private static String escapeHtml(String s, boolean convertBreakAndSpace) {
        if (s == null) {
            return null;
        }
        if (convertBreakAndSpace && s.length() == 0) {
            return "&nbsp;";
        }
        StringBuilder buff = new StringBuilder(s.length());
        boolean convertSpace = true;
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t') {
                for (int j = 0; j < (c == ' ' ? 1 : 4); ++j) {
                    if (convertSpace && convertBreakAndSpace) {
                        buff.append("&nbsp;");
                        continue;
                    }
                    buff.append(' ');
                    convertSpace = true;
                }
                continue;
            }
            convertSpace = false;
            switch (c) {
                case '$': {
                    buff.append("&#36;");
                    continue block9;
                }
                case '<': {
                    buff.append("&lt;");
                    continue block9;
                }
                case '>': {
                    buff.append("&gt;");
                    continue block9;
                }
                case '&': {
                    buff.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    buff.append("&quot;");
                    continue block9;
                }
                case '\'': {
                    buff.append("&#39;");
                    continue block9;
                }
                case '\n': {
                    if (convertBreakAndSpace) {
                        buff.append("<br />");
                        convertSpace = true;
                        continue block9;
                    }
                    buff.append(c);
                    continue block9;
                }
                default: {
                    if (c >= '\u0080') {
                        buff.append("&#").append((int)c).append(';');
                        continue block9;
                    }
                    buff.append(c);
                }
            }
        }
        return buff.toString();
    }

    static String escapeJavaScript(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "";
        }
        StringBuilder buff = new StringBuilder(s.length());
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    buff.append("\\\"");
                    continue block8;
                }
                case '\'': {
                    buff.append("\\'");
                    continue block8;
                }
                case '\\': {
                    buff.append("\\\\");
                    continue block8;
                }
                case '\n': {
                    buff.append("\\n");
                    continue block8;
                }
                case '\r': {
                    buff.append("\\r");
                    continue block8;
                }
                case '\t': {
                    buff.append("\\t");
                    continue block8;
                }
                default: {
                    buff.append(c);
                }
            }
        }
        return buff.toString();
    }
}

