/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.server.web;

import com.alibaba.dts.shade.javax.servlet.ServletConfig;
import com.alibaba.dts.shade.javax.servlet.ServletOutputStream;
import com.alibaba.dts.shade.javax.servlet.http.HttpServlet;
import com.alibaba.dts.shade.javax.servlet.http.HttpServletRequest;
import com.alibaba.dts.shade.javax.servlet.http.HttpServletResponse;
import com.alibaba.dts.shade.org.h2.engine.Constants;
import com.alibaba.dts.shade.org.h2.server.web.PageParser;
import com.alibaba.dts.shade.org.h2.server.web.WebApp;
import com.alibaba.dts.shade.org.h2.server.web.WebServer;
import com.alibaba.dts.shade.org.h2.server.web.WebSession;
import com.alibaba.dts.shade.org.h2.util.New;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class WebServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient WebServer server;

    @Override
    public void init() {
        ServletConfig config = this.getServletConfig();
        Enumeration<String> en = config.getInitParameterNames();
        ArrayList<String> list = New.arrayList();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            String value = config.getInitParameter(name);
            if (!name.startsWith("-")) {
                name = "-" + name;
            }
            list.add(name);
            if (value.length() <= 0) continue;
            list.add(value);
        }
        String[] args = new String[list.size()];
        list.toArray(args);
        this.server = new WebServer();
        this.server.setAllowChunked(false);
        this.server.init(args);
    }

    @Override
    public void destroy() {
        this.server.stop();
    }

    private boolean allow(HttpServletRequest req) {
        if (this.server.getAllowOthers()) {
            return true;
        }
        String addr = req.getRemoteAddr();
        try {
            InetAddress address = InetAddress.getByName(addr);
            return address.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private String getAllowedFile(HttpServletRequest req, String requestedFile) {
        if (!this.allow(req)) {
            return "notAllowed.jsp";
        }
        if (requestedFile.length() == 0) {
            return "index.do";
        }
        return requestedFile;
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String value;
        String name;
        req.setCharacterEncoding("utf-8");
        String file = req.getPathInfo();
        if (file == null) {
            resp.sendRedirect(req.getRequestURI() + "/");
            return;
        }
        if (file.startsWith("/")) {
            file = file.substring(1);
        }
        file = this.getAllowedFile(req, file);
        Properties attributes = new Properties();
        Enumeration<String> en = req.getAttributeNames();
        while (en.hasMoreElements()) {
            name = en.nextElement().toString();
            value = req.getAttribute(name).toString();
            attributes.put(name, value);
        }
        en = req.getParameterNames();
        while (en.hasMoreElements()) {
            name = en.nextElement().toString();
            value = req.getParameter(name);
            attributes.put(name, value);
        }
        WebSession session = null;
        String sessionId = attributes.getProperty("jsessionid");
        if (sessionId != null) {
            session = this.server.getSession(sessionId);
        }
        WebApp app = new WebApp(this.server);
        app.setSession(session, attributes);
        String ifModifiedSince = req.getHeader("if-modified-since");
        String hostAddr = req.getRemoteAddr();
        file = app.processRequest(file, hostAddr);
        session = app.getSession();
        String mimeType = app.getMimeType();
        boolean cache = app.getCache();
        if (cache && this.server.getStartDateTime().equals(ifModifiedSince)) {
            resp.setStatus(304);
            return;
        }
        byte[] bytes = this.server.getFile(file);
        if (bytes == null) {
            resp.sendError(404);
            bytes = ("File not found: " + file).getBytes(Constants.UTF8);
        } else {
            if (session != null && file.endsWith(".jsp")) {
                String page = new String(bytes, Constants.UTF8);
                page = PageParser.parse(page, session.map);
                bytes = page.getBytes(Constants.UTF8);
            }
            resp.setContentType(mimeType);
            if (!cache) {
                resp.setHeader("Cache-Control", "no-cache");
            } else {
                resp.setHeader("Cache-Control", "max-age=10");
                resp.setHeader("Last-Modified", this.server.getStartDateTime());
            }
        }
        if (bytes != null) {
            ServletOutputStream out = resp.getOutputStream();
            out.write(bytes);
        }
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGet(req, resp);
    }
}

