/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.store;

import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.message.TraceSystem;
import com.alibaba.dts.shade.org.h2.store.FileLock;
import com.alibaba.dts.shade.org.h2.store.fs.FilePath;
import com.alibaba.dts.shade.org.h2.store.fs.FileUtils;
import com.alibaba.dts.shade.org.h2.util.New;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class FileLister {
    private FileLister() {
    }

    public static void tryUnlockDatabase(List<String> files, String message) throws SQLException {
        for (String fileName : files) {
            if (fileName.endsWith(".lock.db")) {
                FileLock lock = new FileLock(new TraceSystem(null), fileName, 1000);
                try {
                    lock.lock(1);
                    lock.unlock();
                    continue;
                }
                catch (DbException e) {
                    throw DbException.get(90133, message).getSQLException();
                }
            }
            if (!fileName.endsWith(".mv.db")) continue;
            FileChannel f = null;
            try {
                f = FilePath.get(fileName).open("r");
                java.nio.channels.FileLock lock = f.tryLock(0L, Long.MAX_VALUE, true);
                lock.release();
            }
            catch (Exception e) {
                throw DbException.get(90133, e, message).getSQLException();
            }
            finally {
                if (f == null) continue;
                try {
                    f.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static String getDir(String dir) {
        if (dir == null || dir.equals("")) {
            return ".";
        }
        return FileUtils.toRealPath(dir);
    }

    public static ArrayList<String> getDatabaseFiles(String dir, String db, boolean all) {
        ArrayList<String> files = New.arrayList();
        String start = db == null ? null : FileUtils.toRealPath(dir + "/" + db) + ".";
        for (String f : FileUtils.newDirectoryStream(dir)) {
            boolean ok = false;
            if (f.endsWith(".lobs.db")) {
                if (start == null || f.startsWith(start)) {
                    files.addAll(FileLister.getDatabaseFiles(f, null, all));
                    ok = true;
                }
            } else if (f.endsWith(".lob.db")) {
                ok = true;
            } else if (f.endsWith(".h2.db")) {
                ok = true;
            } else if (f.endsWith(".mv.db")) {
                ok = true;
            } else if (all) {
                if (f.endsWith(".lock.db")) {
                    ok = true;
                } else if (f.endsWith(".temp.db")) {
                    ok = true;
                } else if (f.endsWith(".trace.db")) {
                    ok = true;
                }
            }
            if (!ok || db != null && !f.startsWith(start)) continue;
            String fileName = f;
            files.add(fileName);
        }
        return files;
    }
}

